/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.ContextBridge;
import jp.nyx.common.db.model.User;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.web.servlet.ModelAndView;

public class ContextController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String context_type_search;
        String context_name_search;
        ModelAndView mv = super.handleRequestInternal(request, response);
        SsoManager ssoManager = super.getSsoManager();
        Access access = super.getPersonalAccess(request);
        access.setPersonalAdmin(true);
        String mode = request.getParameter("mode");
        mv.getModel().put("contextTypes", Context.ContextType.values());
        if ("user_search".equals(mode) || "owner_search".equals(mode)) {
            ConditionList uc = new ConditionList(access);
            uc.add((Object)new Condition("user_name", (Object)('%' + request.getParameter("keyvalue") + '%'), " like "));
            List<User> users = ssoManager.loadUser(0, 100, uc);
            mv.getModel().put("users", users);
            return mv;
        }
        if ("bridge_search".equals(mode)) {
            ConditionList cc = new ConditionList(access);
            if (Context.ContextType.NESTED.getValue().equals(request.getParameter("context_type"))) {
                cc.add((Object)new Condition("context_type", (Object)Context.ContextType.NESTED.getValue(), "!="));
            } else {
                cc.add((Object)new Condition("context_type", (Object)Context.ContextType.NESTED.getValue()));
            }
            cc.add((Object)new Condition("context_name", (Object)('%' + request.getParameter("keyvalue") + '%'), " like "));
            cc.setAccess(access);
            List<Context> bridge = ssoManager.loadContext(0, 100, cc);
            mv.getModel().put("bridges", bridge);
            return mv;
        }
        ConditionList cond = new ConditionList(access);
        String context_code_search = request.getParameter("context_code_search");
        if (!this.webUtil.textUtil.isEmpty(context_code_search)) {
            cond.add((Object)new Condition("context_code", (Object)this.webUtil.numUtil.parseLong((Object)context_code_search)));
        }
        if (!this.webUtil.textUtil.isEmpty(context_name_search = request.getParameter("context_name_search"))) {
            cond.add((Object)new Condition("context_name", (Object)("%" + context_name_search + "%"), "like"));
        }
        if (!this.webUtil.textUtil.isEmpty(context_type_search = request.getParameter("context_type_search")) && !"all".equals(context_type_search)) {
            cond.add((Object)new Condition("context_type", (Object)context_type_search));
        }
        this.setRowcount(mv, ssoManager.loadDataCount("m_context", cond));
        List<Context> contexts = ssoManager.loadContext(this.getOffset(mv), this.getLimit(mv), cond);
        mv.getModel().put("contexts", contexts);
        if ("add".equals(mode)) {
            Context context = new Context();
            mv.getModel().put("context", context);
        } else if ("adddo".equals(mode)) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Context context = new Context();
                context.setRegistUid(this.getRemoteUser(mv));
                context.setUpdateUid(this.getRemoteUser(mv));
                if (!this.save(context, request, status, ssoManager)) {
                    return mv;
                }
                ssoManager.saveContext(context);
                status.put("status", "Successed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br/>" + e.getMessage());
                NyxException.logger.error((Object)"\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("edit".equals(mode)) {
            Context context = ssoManager.loadContext((long)this.webUtil.numUtil.parseInt(request.getParameter("context_code")), access);
            context.setVerifyEnddate(this.webUtil.calUtil.addDay(context.getVerifyEnddate(), -1));
            mv.getModel().put("context", context);
        } else if ("editdo".equals(mode)) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Context context = ssoManager.loadContext((long)this.webUtil.numUtil.parseInt(request.getParameter("context_code")), access);
                if (!this.save(context, request, status, ssoManager)) {
                    return mv;
                }
                context.setUpdateUid(this.getRemoteUser(mv));
                ssoManager.saveContext(context);
                status.put("status", "Successed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002<br/>" + e.getMessage());
                NyxException.logger.error((Object)"\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("deldo".equals(mode)) {
            Map<String, String> status = this.getStatus(mv);
            try {
                ssoManager.deleteContext(this.webUtil.numUtil.parseInt(request.getParameter("context_code")));
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
        return mv;
    }

    private boolean save(Context context, HttpServletRequest request, Map<String, String> status, SsoManager ssoManager) throws NoSuchAlgorithmException, MessagingException, IOException, NyxException {
        Calendar cal;
        int i;
        String context_name = request.getParameter("context_name");
        if (this.webUtil.textUtil.isEmpty(context_name)) {
            status.put("status", "Failed");
            status.put("message", "\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        context.setContextName(context_name);
        context.setContextType(request.getParameter("context_type"));
        String[] users = request.getParameterValues("user");
        Set ref = context.getUser();
        ref.clear();
        for (i = 0; users != null && i < users.length; ++i) {
            ref.add(ssoManager.loadUser(users[i]));
        }
        String[] owner = request.getParameterValues("owner");
        ref = context.getOwner();
        ref.clear();
        for (i = 0; owner != null && i < owner.length; ++i) {
            ref.add(ssoManager.loadUser(owner[i]));
        }
        String verify_startdate = request.getParameter("verify_startdate");
        String verify_enddate = request.getParameter("verify_enddate");
        Timestamp startdate = null;
        Timestamp enddate = null;
        if (!this.webUtil.textUtil.isEmpty(verify_startdate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_startdate, "yyyy/MM/dd");
                startdate = new Timestamp(cal.getTimeInMillis());
                context.setVerifyStartdate(startdate);
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            context.setVerifyStartdate(null);
        }
        if (!this.webUtil.textUtil.isEmpty(verify_enddate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_enddate, "yyyy/MM/dd");
                cal.add(6, 1);
                enddate = new Timestamp(cal.getTimeInMillis());
                context.setVerifyEnddate(enddate);
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u7d42\u4e86\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            context.setVerifyEnddate(null);
        }
        context.setEnable("true".equals(request.getParameter("enable")));
        String[] bridge = request.getParameterValues("bridge");
        Set ref2 = context.getBridge();
        ref2.clear();
        boolean nexted = Context.ContextType.NESTED.getValue().equals(context.getContextType());
        for (int i2 = 0; bridge != null && i2 < bridge.length; ++i2) {
            ContextBridge cb = new ContextBridge();
            if (nexted) {
                cb.setParentContextCode(context.getContextCode());
                cb.setContextCode(this.webUtil.numUtil.parseLong((Object)bridge[i2]));
            } else {
                cb.setParentContextCode(this.webUtil.numUtil.parseLong((Object)bridge[i2]));
                cb.setContextCode(context.getContextCode());
            }
            cb.setVerifyStartdate(startdate);
            cb.setVerifyEnddate(enddate);
            ref2.add(cb);
        }
        return true;
    }
}

