/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.db.model.Site;
import jp.nyx.common.util.WebUtility;
import jp.nyx.pkg.sso.spec.AccessValidaterUtility;
import jp.nyx.pkg.sso.spec.ClientSocketParam;
import jp.nyx.pkg.sso.spec.ClientSocketPool;
import org.apache.commons.io.output.NullOutputStream;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ProxyServlet
extends HttpServlet {
    private static final WebUtility webUtil = new WebUtility();
    private static final Pattern pattern = Pattern.compile("[0-9]{3}");
    private ClientSocketPool sockets = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)super.getServletContext());
        try {
            NyxManager nyxMrg = (NyxManager)appContext.getBean("nyxManager");
            this.sockets = new ClientSocketPool(20, 5, (ApplicationContext)appContext, nyxMrg.loadSetting());
        }
        catch (Exception e) {
            ServletException se = new ServletException(e.getMessage());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long tm = System.currentTimeMillis();
        Map nyx = (Map)request.getAttribute("nyxSetting");
        boolean verbose = "on".equals(((Setting)nyx.get("kernel_log_verbose")).getValue());
        AccessValidaterUtility.AuthValue authValue = (AccessValidaterUtility.AuthValue)request.getAttribute("authValue");
        if (authValue == null) {
            webUtil.redirectError(request, response, 400, "No filtered request, from SSOFilter.", null);
            return;
        }
        URL site = authValue.getValidSite().getUrl();
        int port = site.getPort();
        port = port <= 0 ? site.getDefaultPort() : port;
        String host = request.getServerName();
        if (request.getServerPort() == port && site.getHost().equals(host)) {
            webUtil.redirectError(request, response, 500, "This request is reflexive.See SSO log.", null);
            return;
        }
        String use = authValue.getAuthUse();
        if (site == null) {
            this.warmLog(tm, System.currentTimeMillis(), authValue, "Valid site is null.");
            webUtil.sendAuthenticate(request, response, null);
            return;
        }
        if (Auth.AuthUse.FORWARD.getValue().equals(use)) {
            this.debugLog(verbose, tm, System.currentTimeMillis(), authValue, "Request dispatch to '" + site + "'.");
            webUtil.sendRedirect(this.getServletContext(), request, response, webUtil.createQueryPath(site));
            return;
        }
        ClientSocketParam socketParam = new ClientSocketParam(site.getHost(), this.getPort(site));
        socketParam.setSsl("https".equals(site.getProtocol()));
        Socket socket = null;
        boolean socketClose = false;
        try {
            RequestHeaders validSiteHeaders = new RequestHeaders(authValue, authValue.getValidSite().getUrl());
            Enumeration headNames = request.getHeaderNames();
            String contentLength = "0";
            while (headNames.hasMoreElements()) {
                String n = ((String)headNames.nextElement()).toLowerCase();
                if (n.equals("host") || n.equals("if-none-match") || n.equals("connection") || n.equals("keep-alive") || n.equals("proxy-authenticate") || n.equals("proxy-authorization") || n.equals("transfer-encoding") || n.equals("upgrade") || n.equals("trailers") || n.equals("te")) continue;
                if (n.equals("content-length")) {
                    contentLength = request.getHeader(n);
                    continue;
                }
                if (n.equalsIgnoreCase("NyxAuthGate")) continue;
                Enumeration values = request.getHeaders(n);
                while (values.hasMoreElements()) {
                    String v = (String)values.nextElement();
                    if (ProxyServlet.webUtil.textUtil.isEmpty(v)) continue;
                    validSiteHeaders.add(n, v);
                }
            }
            validSiteHeaders.add("NyxAuthGate", "xmlrpc=" + ((Setting)nyx.get("kernel_xmlrpc_url")).getValue());
            validSiteHeaders.add("Connection", "close");
            if (site.getPort() > 0) {
                validSiteHeaders.add("Host", site.getHost() + ":" + site.getPort());
            } else {
                validSiteHeaders.add("Host", site.getHost());
            }
            String charEnc = ProxyServlet.webUtil.textUtil.nvl(request.getCharacterEncoding(), authValue.getProxyCharset());
            for (AccessValidaterUtility.AuthSite inform : authValue.getInformSite()) {
                URL url = inform.getUrl();
                ClientSocketParam sp = new ClientSocketParam(url.getHost(), this.getPort(url));
                sp.setSsl("https".equals(url.getProtocol()));
                RequestHeaders informSiteHeaders = new RequestHeaders(authValue, url);
                informSiteHeaders.headers.putAll(validSiteHeaders.headers);
                Socket sc = null;
                try {
                    sc = (Socket)this.sockets.borrowObject(sp);
                    byte[] queryParamValue = this.makeParam(charEnc, inform.getParam(), informSiteHeaders, contentLength, authValue.getTriggerMethod(), authValue.isLoadedRequestParam());
                    this.debugLog(verbose, tm, System.currentTimeMillis(), authValue, "\n[inform]\n" + informSiteHeaders);
                    OutputStream out = sc.getOutputStream();
                    out.write(informSiteHeaders.toString().getBytes());
                    out.write(queryParamValue);
                    out.flush();
                    BufferedInputStream bin = new BufferedInputStream(sc.getInputStream());
                    String line = this.readLine(bin);
                    boolean informSockClose = false;
                    Map<String, Object> vParam = authValue.getValidSite().getParam();
                    while (!ProxyServlet.webUtil.textUtil.isEmpty(line = this.readLine(bin))) {
                        AccessValidaterUtility.AuthSiteParamReserve avp;
                        Object vp;
                        int i = line.indexOf(":");
                        if (i <= 1) continue;
                        String n = line.substring(0, i);
                        String nl = n.toLowerCase();
                        String v = line.substring(i + 1).trim();
                        if (nl.equals("connection") && v.equalsIgnoreCase("close")) {
                            informSockClose = true;
                        }
                        if (!((vp = vParam.get(nl)) instanceof AccessValidaterUtility.AuthSiteParamReserve) || (avp = (AccessValidaterUtility.AuthSiteParamReserve)vp).getType() != Site.SiteParamType.INFORMHEADER2PARAM) continue;
                        vParam.put(avp.getParamName(), v);
                        vParam.remove(nl);
                    }
                    if (verbose) {
                        ByteArrayOutputStream bo = new ByteArrayOutputStream();
                        webUtil.pipe((InputStream)bin, (OutputStream)bo);
                        this.debugLog(verbose, tm, System.currentTimeMillis(), authValue, "\n[inform-res]\n" + bo.toString(charEnc));
                        continue;
                    }
                    webUtil.pipe((InputStream)bin, (OutputStream)new NullOutputStream());
                }
                finally {
                    sc.close();
                    this.sockets.returnObject(sp, sc);
                    this.sockets.clear(sp);
                }
            }
            socket = (Socket)this.sockets.borrowObject(socketParam);
            byte[] queryParamValue = this.makeParam(charEnc, authValue.getValidSite().getParam(), validSiteHeaders, contentLength, authValue.getTriggerMethod(), authValue.isLoadedRequestParam());
            this.debugLog(verbose, tm, System.currentTimeMillis(), authValue, "\n[\u4e0a\u308a]\n" + validSiteHeaders);
            OutputStream out = socket.getOutputStream();
            out.write(validSiteHeaders.toString().getBytes());
            out.write(queryParamValue);
            webUtil.pipe((InputStream)request.getInputStream(), out);
            StringBuilder remoteResponce = new StringBuilder();
            BufferedInputStream bin = new BufferedInputStream(socket.getInputStream());
            try {
                String line = this.readLine(bin);
                Matcher m = pattern.matcher(line);
                if (m.find()) {
                    response.setStatus(Integer.parseInt(m.group()));
                }
                while (!ProxyServlet.webUtil.textUtil.isEmpty(line = this.readLine(bin))) {
                    String v;
                    String n;
                    block48: {
                        int i = line.indexOf(":");
                        if (i <= 1) continue;
                        n = line.substring(0, i);
                        String nl = n.toLowerCase();
                        v = line.substring(i + 1);
                        v = v.trim();
                        if (nl.equals("location")) {
                            URL tu = authValue.getTriggerSite().getUrl();
                            try {
                                String ph = webUtil.createQueryPath(new URL(v));
                                v = new URL(tu.getProtocol(), tu.getHost(), tu.getPort(), ph).toString();
                            }
                            catch (MalformedURLException e) {
                                if (v.startsWith("/")) {
                                    v = new URL(tu.getProtocol(), tu.getHost(), tu.getPort(), v).toString();
                                    break block48;
                                }
                                URL u = new URL(request.getRequestURL().toString());
                                String ph = u.getPath();
                                String qu = u.getQuery();
                                ph = ph.substring(0, ph.lastIndexOf("/")) + '/' + v.trim();
                                if (!ProxyServlet.webUtil.textUtil.isEmpty(qu)) {
                                    ph = ph + '?' + qu;
                                }
                                v = new URL(tu.getProtocol(), tu.getHost(), tu.getPort(), ph).toString();
                            }
                        } else if (nl.equals("set-cookie")) {
                            StringBuilder sb = new StringBuilder();
                            String[] pt = v.split(";");
                            for (int j = 0; j < pt.length; ++j) {
                                if (ProxyServlet.webUtil.textUtil.isEmpty(pt[j])) continue;
                                if (j > 0) {
                                    sb.append(";");
                                }
                                if (pt[j].startsWith("domain")) {
                                    sb.append("domain=");
                                    sb.append(((Setting)nyx.get("base_host")).getValue());
                                    continue;
                                }
                                sb.append(pt[j]);
                            }
                            v = sb.toString();
                        } else if (nl.equals("connection")) {
                            if (v.equalsIgnoreCase("close")) {
                                socketClose = true;
                            }
                        } else if (nl.equals("transfer-encoding")) continue;
                    }
                    remoteResponce.append(n);
                    remoteResponce.append(":");
                    remoteResponce.append(v);
                    remoteResponce.append("\r\n");
                    response.addHeader(n, v);
                }
                this.debugLog(verbose, tm, System.currentTimeMillis(), authValue, "\n[\u4e0b\u308a]\n" + remoteResponce.toString());
                webUtil.pipe((InputStream)bin, (OutputStream)response.getOutputStream());
            }
            catch (SocketTimeoutException e) {
                this.warmLog(tm, System.currentTimeMillis(), authValue, e.getMessage());
                webUtil.redirectError(request, response, 504, e.getMessage(), authValue.getFailerSite().getUrl());
            }
            catch (SocketException e) {
                this.warmLog(tm, System.currentTimeMillis(), authValue, "\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306b\u30b3\u30f3\u30c6\u30f3\u30c4\u9001\u4fe1\u4e2d\u306b\u63a5\u7d9a\u304c\u9589\u3058\u3089\u308c\u307e\u3057\u305f\u3002" + e.getMessage());
            }
            bin.close();
        }
        catch (ConnectException e) {
            this.warmLog(tm, System.currentTimeMillis(), authValue, e.getMessage());
            webUtil.redirectError(request, response, 504, e.getMessage(), authValue.getFailerSite().getUrl());
        }
        catch (Exception e) {
            ServletException ex = new ServletException((Throwable)e);
            ex.initCause((Throwable)e);
            this.warmLog(tm, System.currentTimeMillis(), authValue, e.getMessage());
            throw ex;
        }
        finally {
            try {
                socket.close();
                this.sockets.returnObject(socketParam, socket);
                this.sockets.clear(socketParam);
            }
            catch (Exception e) {
                this.warmLog(tm, System.currentTimeMillis(), authValue, e.getMessage());
            }
        }
        this.debugLog(verbose, tm, System.currentTimeMillis(), authValue, "Proxy complate.");
    }

    private byte[] makeParam(String charEnc, Map<String, Object> param, RequestHeaders headers, String contentLength, String method, boolean loadedRequestParam) throws UnsupportedEncodingException {
        String queryParam = webUtil.makeQueryString(param);
        byte[] queryParamValue = new byte[]{};
        if (loadedRequestParam) {
            queryParamValue = queryParam.toString().getBytes(charEnc);
            if (!"GET".equals(method)) {
                contentLength = String.valueOf(queryParamValue.length);
            }
        }
        headers.add("Content-Length", contentLength);
        return queryParamValue;
    }

    private void warmLog(long proxyStart, long proxyEnd, AccessValidaterUtility.AuthValue value, String message) {
        if (!NyxException.logger.isWarnEnabled()) {
            return;
        }
        long proxyTime = proxyEnd - proxyStart;
        StringBuffer sb = new StringBuffer("\u8ee2\u9001:");
        URL tu = value.getTriggerSite().getUrl();
        NyxException.logger.warn((Object)sb.append(proxyTime).append("ms").append(" Type=").append(value.getAuthType()).append(" Use=").append(value.getAuthUse()).append(" User=").append(value.getUserId()).append(" Client=").append(value.getClientAddress()).append(" Trigger=[").append(value.getTriggerMethod()).append("]").append(tu.getPath()).append(" ValidSite=").append(value.getValidSite().getUrl()).append(" Cause=").append(value.getLog()).append(" Message=").append(message).append(" Session=").append(value.getSessionId()));
    }

    private void debugLog(boolean debugEnabled, long proxyStart, long proxyEnd, AccessValidaterUtility.AuthValue value, String message) {
        if (!debugEnabled) {
            return;
        }
        long proxyTime = proxyEnd - proxyStart;
        URL tu = value.getTriggerSite().getUrl();
        StringBuffer sb = new StringBuffer("\u8ee2\u9001:");
        sb.append(proxyTime).append("ms");
        sb.append(" Type=").append(value.getAuthType());
        sb.append(" Use=").append(value.getAuthUse());
        sb.append(" User=").append(value.getUserId());
        sb.append(" Client=").append(value.getClientAddress());
        sb.append(" Trigger=[").append(value.getTriggerMethod()).append("]").append(tu.getPath());
        sb.append(" ValidSite=").append(value.getValidSite().getUrl());
        sb.append(" Cause=").append(value.getLog());
        sb.append(" Message=").append(message);
        sb.append(" Session=").append(value.getSessionId());
        NyxException.logger.debug((Object)sb.toString());
    }

    private int getPort(URL site) {
        int port = site.getPort();
        if (port > 0) {
            return port;
        }
        if ("http".equals(site.getProtocol())) {
            return 80;
        }
        if ("https".equals(site.getProtocol())) {
            return 443;
        }
        return 80;
    }

    private String readLine(BufferedInputStream bin) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        boolean r = false;
        int i = -1;
        while ((i = bin.read()) > 0) {
            if (i == 13) {
                r = true;
                continue;
            }
            if (r && i == 10) break;
            b.write(i);
        }
        b.close();
        return new String(b.toByteArray());
    }

    private class RequestHeaders {
        private final Map<Header, Object> headers = new TreeMap<Header, Object>();
        private AccessValidaterUtility.AuthValue authValue = null;
        private URL triggerUrl = null;

        private RequestHeaders(AccessValidaterUtility.AuthValue authValue, URL triggerUrl) {
            this.authValue = authValue;
            this.triggerUrl = triggerUrl;
        }

        public void add(String key, String value) {
            Header h = new Header();
            h.key = key;
            h.value = value;
            this.headers.put(h, null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.authValue != null) {
                sb.append(this.authValue.getTriggerMethod());
                sb.append(" ");
                sb.append(webUtil.createQueryPath(this.triggerUrl));
                sb.append(" HTTP/1.0\r\n");
            }
            HashSet hd = new HashSet();
            for (Header h : this.headers.keySet()) {
                if (h == null || webUtil.textUtil.isEmpty(h.key) || webUtil.textUtil.isEmpty(h.value)) continue;
                if (hd.contains(h.key)) {
                    sb.append(",");
                } else {
                    sb.append(h.key);
                    sb.append(":");
                }
                sb.append(h.value);
                sb.append("\r\n");
            }
            sb.append("\r\n");
            return sb.toString();
        }
    }

    private class Header
    implements Comparable<Header> {
        private String key = "";
        private String value = "";

        private Header() {
        }

        public int hashCode() {
            return (this.key + this.value).hashCode();
        }

        public boolean equals(Object obj) {
            return obj == null ? false : this.hashCode() == obj.hashCode();
        }

        @Override
        public int compareTo(Header o) {
            return this.key.compareTo(o.key);
        }
    }
}

