/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import jp.nyx.NyxException;
import jp.nyx.common.db.Setting;
import jp.nyx.common.web.DefaultFilter;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.spec.AccessValidaterUtility;
import org.springframework.context.ApplicationContext;

public class SsoFilter
extends DefaultFilter {
    public static final String ATTR_AUTHVALUE = "authValue";
    public static final String ATTR_SSODATASOURCE = "ssoDataSource";
    public static final String SESSION_LOGOFF = "logoff";
    public static final String REQUEST_PARAM_RELOGIN = "ssorelogin";
    private static final int LOG_LIMITED = 10000;
    private AccessValidaterUtility util = null;
    private DataSource ssoDs = null;
    private HashSet<String> excludes = new HashSet();

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long tm = System.currentTimeMillis();
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Unsupported Request." + request);
        }
        if (this.excludes.contains(((HttpServletRequest)request).getServletPath())) {
            super.doFilter(request, response, chain);
            return;
        }
        super.filtering(request, response, chain);
        HttpSession session = ((HttpServletRequest)request).getSession(true);
        boolean logoff = false;
        Object o = session.getAttribute(SESSION_LOGOFF);
        if (o != null) {
            logoff = (Boolean)o;
        }
        AccessValidaterUtility.AuthValue authValue = this.util.new AccessValidaterUtility.AuthValue();
        try {
            if (logoff) {
                this.util.redirectError((HttpServletRequest)request, (HttpServletResponse)response, 401, "Your logged out.", null);
                return;
            }
            authValue.setSessionId(session.getId());
            boolean auth = this.util.valid(this.ssoDs, (HttpServletRequest)request, authValue);
            if (!auth) {
                AccessValidaterUtility.AuthSite failer = authValue.getFailerSite();
                this.util.sendAuthenticate((HttpServletRequest)request, (HttpServletResponse)response, failer == null ? null : failer.getUrl());
                this.completeLog(tm, System.currentTimeMillis(), authValue);
                return;
            }
            String uid = authValue.getUserId();
            if (uid != null) {
                request.setAttribute("nyxAdmin", (Object)this.nyxMrg.isAdmin(uid));
                request.setAttribute("nyxPersonalAdmin", (Object)this.nyxMrg.isPersonalAdmin(uid));
            }
            request.setAttribute("nyxUserId", (Object)uid);
            request.setAttribute(ATTR_AUTHVALUE, (Object)authValue);
            this.completeLog(tm, System.currentTimeMillis(), authValue);
        }
        catch (Exception e) {
            authValue.setLastAccess(tm);
            NyxException.logger.warn((Object)("No init SSO database yet.(" + e.getMessage() + ")"), (Throwable)e);
            String uid = this.util.parseRequestUser((HttpServletRequest)request);
            if (uid == null) {
                AccessValidaterUtility.AuthSite failer = authValue.getFailerSite();
                this.util.sendAuthenticate((HttpServletRequest)request, (HttpServletResponse)response, failer == null ? null : failer.getUrl());
                return;
            }
            request.setAttribute("nyxUserId", (Object)uid);
            boolean admin = false;
            try {
                admin = this.nyxMrg.isAdmin(uid);
            }
            catch (SQLException e1) {
                // empty catch block
            }
            if (!admin) {
                AccessValidaterUtility.AuthSite failer = authValue.getFailerSite();
                this.util.sendAuthenticate((HttpServletRequest)request, (HttpServletResponse)response, failer == null ? null : failer.getUrl());
                return;
            }
            request.setAttribute("nyxAdmin", (Object)admin);
        }
        chain.doFilter(request, response);
    }

    private void completeLog(long authStart, long authEnd, AccessValidaterUtility.AuthValue value) {
        if (value.getLastAccess() + 10000L >= authStart) {
            return;
        }
        value.setProxyLogWrite(true);
        value.setLastAccess(authStart);
        long authTime = authEnd - authStart;
        StringBuffer sb = new StringBuffer("\u8a8d\u8a3c:");
        NyxException.logger.info((Object)sb.append(authTime).append("ms").append(" Type=").append(value.getAuthType()).append(" Use=").append(value.getAuthUse()).append(" User=").append(value.getUserId()).append(" Client=").append(value.getClientAddress()).append(" Trigger=[").append(value.getTriggerMethod()).append("]").append(value.getTriggerSite().getUrl().getPath()).append(" ValidSite=").append(value.getValidSite().getUrl()).append(" Cause=").append(value.getLog()).append(" Session=").append(value.getSessionId()));
    }

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.util = new AccessValidaterUtility(this.nyxMrg);
        this.ssoDs = (DataSource)this.appCtx.getBean(ATTR_SSODATASOURCE);
        Enumeration params = config.getInitParameterNames();
        while (params.hasMoreElements()) {
            String k = params.nextElement().toString();
            if (!k.startsWith("exclude")) continue;
            String v = config.getInitParameter(k);
            System.out.println("SsoFilter : " + k + " = " + v);
            this.excludes.add(v);
        }
        System.out.println("============================================================");
        System.out.println("[ Nyx Auth Gate version 0.5.9.e ]");
        System.out.println("  Powered by Nyx Kernel ver 0.5.9.e");
        System.out.println("  Copyright (C) 2005-2008 Nyx Project. All right reserved.");
        System.out.println("============================================================");
        try {
            Method m = this.ssoDs.getClass().getMethod("setDriverClassName", String.class);
            m.invoke((Object)this.ssoDs, ((Setting)this.nyx.get("sso_jdbc_driver")).getValue());
            m = this.ssoDs.getClass().getMethod("setUrl", String.class);
            m.invoke((Object)this.ssoDs, ((Setting)this.nyx.get("sso_jdbc_url")).getValue());
            m = this.ssoDs.getClass().getMethod("setUsername", String.class);
            m.invoke((Object)this.ssoDs, ((Setting)this.nyx.get("sso_jdbc_user")).getValue());
            m = this.ssoDs.getClass().getMethod("setPassword", String.class);
            m.invoke((Object)this.ssoDs, ((Setting)this.nyx.get("sso_jdbc_pass")).getValue());
            SsoManager ssoManager = (SsoManager)this.appCtx.getBean("ssoManager");
            if (!ssoManager.isInit((ApplicationContext)this.appCtx)) {
                ssoManager.init((ApplicationContext)this.appCtx);
            }
        }
        catch (Exception e) {
            ServletException se = new ServletException(e.getMessage());
            se.initCause((Throwable)e);
            throw se;
        }
    }
}

