/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.db.model.User;
import jp.nyx.common.util.DigestUtility;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.web.servlet.ModelAndView;

public class UserController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        SsoManager ssoManager = super.getSsoManager();
        Access access = super.getPersonalAccess(request);
        access.setPersonalAdmin(true);
        mv.getModel().put("userTypes", User.UserType.values());
        String user_id_search = request.getParameter("user_id_search");
        String user_name_search = request.getParameter("user_name_search");
        ConditionList cond = new ConditionList(access);
        if (!this.webUtil.textUtil.isEmpty(user_id_search)) {
            cond.add((Object)new Condition("user_id", (Object)("%" + user_id_search + "%"), "like"));
        }
        if (!this.webUtil.textUtil.isEmpty(user_name_search)) {
            cond.add((Object)new Condition("user_name", (Object)("%" + user_name_search + "%"), "like"));
        }
        this.setRowcount(mv, ssoManager.loadDataCount("m_user", cond));
        cond.setAccess(access);
        List<User> users = ssoManager.loadUser(this.getOffset(mv), this.getLimit(mv), cond);
        mv.getModel().put("users", users);
        if ("add".equals(request.getParameter("mode"))) {
            User user = new User();
            mv.getModel().put("user", user);
        } else if ("adddo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                User user = new User();
                user.setUserId(request.getParameter("user_id"));
                user.setRegistUid(this.getRemoteUser(mv));
                user.setUpdateUid(this.getRemoteUser(mv));
                String password = request.getParameter("password");
                if (this.webUtil.textUtil.isEmpty(password)) {
                    status.put("status", "Failed");
                    status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return mv;
                }
                if (!this.save(user, request, status)) {
                    return mv;
                }
                if (user.getUnixUid() < 0) {
                    user.setUnixUid((int)ssoManager.loadMaxLong("unix_uid", "m_user") + 1);
                }
                if (user.getUnixGid() < 0) {
                    user.setUnixGid((int)ssoManager.loadMaxLong("unix_gid", "m_user") + 1);
                }
                ssoManager.saveUser(user, access);
                status.put("status", "Successed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("edit".equals(request.getParameter("mode"))) {
            User user = ssoManager.loadUser(request.getParameter("user_id"));
            user.setVerifyEnddate(this.webUtil.calUtil.addDay(user.getVerifyEnddate(), -1));
            mv.getModel().put("user", user);
            mv.getModel().put("extKeies", user.getExt().keySet());
        } else if ("editdo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                User user = ssoManager.loadUser(request.getParameter("user_id"));
                if (!this.save(user, request, status)) {
                    return mv;
                }
                user.setUpdateUid(this.getRemoteUser(mv));
                ssoManager.saveUser(user, access);
                status.put("status", "Successed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("deldo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                ssoManager.deleteUser(request.getParameter("user_id"), access);
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
        return mv;
    }

    private boolean save(User user, HttpServletRequest request, Map<String, String> status) throws NoSuchAlgorithmException, MessagingException, IOException {
        Calendar cal;
        String user_name = request.getParameter("user_name");
        if (this.webUtil.textUtil.isEmpty(user_name)) {
            status.put("status", "Failed");
            status.put("message", "\u30e6\u30fc\u30b6\u30fc\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        user.setUserName(user_name);
        String password = request.getParameter("password");
        String password2 = request.getParameter("password2");
        if (!this.webUtil.textUtil.isEmpty(password) || !this.webUtil.textUtil.isEmpty(password2)) {
            if (!this.webUtil.textUtil.isEquals(password, password2)) {
                status.put("status", "Failed");
                status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
                return false;
            }
            user.setPasswd(DigestUtility.md5((String)password));
        }
        user.setUserType(request.getParameter("user_type"));
        user.setModificationId(request.getParameter("modification_id"));
        user.setModificationValue(request.getParameter("modification_value"));
        user.setUnixUid(this.webUtil.numUtil.parseInt(request.getParameter("unix_uid"), -1));
        user.setUnixGid(this.webUtil.numUtil.parseInt(request.getParameter("unix_gid"), -1));
        user.setUnixGname(request.getParameter("unix_gname"));
        String verify_startdate = request.getParameter("verify_startdate");
        String verify_enddate = request.getParameter("verify_enddate");
        if (!this.webUtil.textUtil.isEmpty(verify_startdate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_startdate, "yyyy/MM/dd");
                user.setVerifyStartdate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            user.setVerifyStartdate(null);
        }
        if (!this.webUtil.textUtil.isEmpty(verify_enddate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_enddate, "yyyy/MM/dd");
                cal.add(6, 1);
                user.setVerifyEnddate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u7d42\u4e86\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            user.setVerifyEnddate(null);
        }
        user.setEnable("true".equals(request.getParameter("enable")));
        String[] field_name = request.getParameterValues("field_name[]");
        Map ext = user.getExt();
        ext.clear();
        for (int i = 0; field_name != null && i < field_name.length; ++i) {
            if (this.webUtil.textUtil.isEmpty(field_name[i])) continue;
            String field_del = request.getParameter("field_del[" + field_name[i] + "]");
            String field_value = request.getParameter("field_value[" + field_name[i] + "]");
            String field_modify = request.getParameter("field_modify[" + field_name[i] + "]");
            Ext p = new Ext();
            if ("true".equals(field_del)) {
                p.setSessionDisable(true);
            }
            this.save(user, ext, p, field_name[i], field_value, field_modify);
        }
        String field_name_new = request.getParameter("field_name_new");
        if (!this.webUtil.textUtil.isEmpty(field_name_new)) {
            String field_value_new = request.getParameter("field_value_new");
            String field_modify_new = request.getParameter("field_modify_new");
            Ext p = new Ext();
            this.save(user, ext, p, field_name_new, field_value_new, field_modify_new);
        }
        return true;
    }

    private void save(User user, Map<String, Ext> ext, Ext p, String field_name, String field_value, String field_modify) {
        p.setFieldName(field_name);
        p.setFieldModify(field_modify);
        p.setFieldValue(field_value);
        p.setRegistUid(user.getUpdateUid());
        p.setUpdateUid(user.getUpdateUid());
        p.setVerifyStartdate(user.getVerifyStartdate());
        p.setVerifyEnddate(user.getVerifyEnddate());
        p.setEnable(true);
        ext.put(p.getFieldName(), p);
    }
}

