/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.unification.web;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.ContextLink;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.db.model.User;
import jp.nyx.common.util.DigestUtility;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.web.servlet.ModelAndView;

public class UnifiedUserController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, String> status;
        User user;
        User user22;
        ModelAndView mv = super.handleRequestInternal(request, response);
        SsoManager ssoManager = super.getSsoManager();
        Access access = super.getPersonalAccess(request);
        access.setPersonalAdmin(true);
        String id_search = request.getParameter("id_search");
        String user_name_search = request.getParameter("user_name_search");
        String context_name_search = request.getParameter("context_name_search");
        ConditionList countCond = new ConditionList(access);
        ConditionList resCond = new ConditionList(access);
        if (!this.webUtil.textUtil.isEmpty(id_search)) {
            countCond.add((Object)new Condition("u.user_id", (Object)("%" + id_search + "%"), "like"));
            resCond.add((Object)new Condition("user_id", (Object)("%" + id_search + "%"), "like"));
        }
        if (!this.webUtil.textUtil.isEmpty(user_name_search)) {
            countCond.add((Object)new Condition("u.user_name", (Object)("%" + user_name_search + "%"), "like"));
            resCond.add((Object)new Condition("user_name", (Object)("%" + user_name_search + "%"), "like"));
        }
        if (!this.webUtil.textUtil.isEmpty(context_name_search)) {
            countCond.add((Object)new Condition("c.context_name", (Object)("%" + context_name_search + "%"), "like"));
            resCond.add((Object)new Condition("users.context_name", (Object)("%" + context_name_search + "%"), "like"));
        }
        countCond.setAccess(access);
        resCond.setAccess(access);
        String table = "(m_user u left join m_context_user cu on (u.user_id=cu.user_id) left join m_context c on (cu.context_code=c.context_code and c.enable='t'))";
        this.setRowcount(mv, ssoManager.loadDataCount(table, "u.user_id", countCond));
        List<User> users = ssoManager.loadUser(this.getOffset(mv), this.getLimit(mv), resCond);
        mv.getModel().put("users", users);
        mv.getModel().put("visibleContextType", Context.ContextType.getVisibleMap());
        Calendar now = this.webUtil.calUtil.getCalendar();
        for (User user22 : users) {
            Calendar start = Calendar.getInstance();
            start.setTime(user22.getVerifyStartdate());
            Calendar end = Calendar.getInstance();
            end.setTime(user22.getVerifyEnddate());
            Ext color = new Ext();
            color.setFieldName("color");
            if (now.before(start)) {
                color.setFieldValue("off");
            } else if (now.after(end)) {
                color.setFieldValue("off");
            } else {
                color.setFieldValue("on");
            }
            user22.getExt().put(color.getFieldName(), color);
        }
        if ("add".equals(request.getParameter("mode"))) {
            user = new User();
            mv.getModel().put("user", user);
        } else if ("adddo".equals(request.getParameter("mode"))) {
            status = this.getStatus(mv);
            try {
                String userId = request.getParameter("user_id");
                User userCheck = ssoManager.loadUser(userId);
                if (this.webUtil.textUtil.isEmpty(userId)) {
                    status.put("status", "Failed");
                    status.put("message", "\u30e6\u30fc\u30b6\u30fcID\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return mv;
                }
                if (userId.equals(userCheck.getUnixGname())) {
                    status.put("status", "Failed");
                    status.put("message", "\u30e6\u30fc\u30b6\u30fcID\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002");
                    return mv;
                }
                User user3 = new User();
                user3.setUserId(userId);
                user3.setRegistUid(this.getRemoteUser(mv));
                user3.setUpdateUid(this.getRemoteUser(mv));
                String password = request.getParameter("password");
                if (this.webUtil.textUtil.isEmpty(password)) {
                    status.put("status", "Failed");
                    status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return mv;
                }
                if (!this.save(user3, request, status)) {
                    return mv;
                }
                if (user3.getUnixUid() < 0) {
                    user3.setUnixUid((int)ssoManager.loadMaxLong("unix_uid", "m_user") + 1);
                }
                if (user3.getUnixGid() < 0) {
                    user3.setUnixGid((int)ssoManager.loadMaxLong("unix_gid", "m_user") + 1);
                }
                ssoManager.saveUser(user3, access, true);
                status.put("status", "Successed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("edit".equals(request.getParameter("mode"))) {
            user = ssoManager.loadUser(request.getParameter("user_id"));
            Timestamp endTime = this.webUtil.calUtil.addDay(user.getVerifyEnddate(), -1);
            user.setVerifyEnddate(endTime);
            mv.getModel().put("user", user);
            mv.getModel().put("extKeies", user.getExt().keySet());
            Map ext = user.getExt();
            Ext mailExt = (Ext)ext.get("email");
            if (mailExt != null) {
                mv.getModel().put("email", mailExt.getFieldValue());
            }
        } else if ("editdo".equals(request.getParameter("mode"))) {
            status = this.getStatus(mv);
            try {
                user22 = ssoManager.loadUser(request.getParameter("user_id"));
                int uid = user22.getUnixUid();
                int gid = user22.getUnixGid();
                if (!this.save(user22, request, status)) {
                    return mv;
                }
                user22.setUnixUid(uid);
                user22.setUnixGid(gid);
                user22.setUpdateUid(this.getRemoteUser(mv));
                ssoManager.saveUser(user22, access, true);
                status.put("status", "Successed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("deldo".equals(request.getParameter("mode"))) {
            status = this.getStatus(mv);
            try {
                user22 = ssoManager.loadUser(request.getParameter("user_id"));
                user22.getContextLink().clear();
                user22.setUpdateUid(this.getRemoteUser(mv));
                ssoManager.saveUser(user22, access, true);
                ssoManager.deleteUser(request.getParameter("user_id"), access);
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
        return mv;
    }

    private boolean save(User user, HttpServletRequest request, Map<String, String> status) throws NoSuchAlgorithmException, MessagingException, IOException {
        Calendar cal;
        String user_name = request.getParameter("user_name");
        if (this.webUtil.textUtil.isEmpty(user_name)) {
            status.put("status", "Failed");
            status.put("message", "\u30e6\u30fc\u30b6\u30fc\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        user.setUserName(user_name);
        String password = request.getParameter("password");
        String password2 = request.getParameter("password2");
        if (!this.webUtil.textUtil.isEmpty(password) || !this.webUtil.textUtil.isEmpty(password2)) {
            if (!this.webUtil.textUtil.isEquals(password, password2)) {
                status.put("status", "Failed");
                status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
                return false;
            }
            user.setPasswd(DigestUtility.md5((String)password));
        }
        Pattern ptn = Pattern.compile("^[0-9a-zA-Z]+");
        Matcher mc = ptn.matcher(password);
        if ("adddo".equals(request.getParameter("mode")) && !mc.matches()) {
            status.put("status", "Failed");
            status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u306f\u534a\u89d2\u82f1\u6570\u5b57\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        if (!(!"editdo".equals(request.getParameter("mode")) || this.webUtil.textUtil.isEmpty(password) && this.webUtil.textUtil.isEmpty(password2) || mc.matches())) {
            status.put("status", "Failed");
            status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u306f\u534a\u89d2\u82f1\u6570\u5b57\u3067\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return false;
        }
        user.setUnixUid(this.webUtil.numUtil.parseInt(request.getParameter("unix_uid"), -1));
        user.setUnixGid(this.webUtil.numUtil.parseInt(request.getParameter("unix_gid"), -1));
        user.setUnixGname(request.getParameter("user_id"));
        String verify_startdate = request.getParameter("verify_startdate");
        String verify_enddate = request.getParameter("verify_enddate");
        if (!this.webUtil.textUtil.isEmpty(verify_startdate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_startdate, "yyyy/MM/dd");
                user.setVerifyStartdate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            user.setVerifyStartdate(null);
        }
        if (!this.webUtil.textUtil.isEmpty(verify_enddate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_enddate, "yyyy/MM/dd");
                cal.add(6, 1);
                user.setVerifyEnddate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u7d42\u4e86\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            user.setVerifyEnddate(null);
        }
        if (user.getVerifyStartdate().getTime() >= user.getVerifyEnddate().getTime()) {
            status.put("status", "Failed");
            status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u5229\u7528\u7d42\u4e86\u65e5\u3088\u308a\u5f8c\u306e\u65e5\u4ed8\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
            return false;
        }
        String[] acontext = request.getParameterValues("context");
        user.getContextLink().clear();
        if (acontext == null) {
            status.put("status", "Failed");
            status.put("message", "\u30b0\u30eb\u30fc\u30d7\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        for (String contextCode : acontext) {
            ContextLink cl = new ContextLink();
            cl.setContextCode(this.webUtil.numUtil.parseLong((Object)contextCode));
            user.getContextLink().add(cl);
        }
        String[] acontext_hidden = request.getParameterValues("context_hidden");
        if (acontext_hidden != null) {
            for (String contextCode_hidden : acontext_hidden) {
                ContextLink c2 = new ContextLink();
                c2.setContextCode(this.webUtil.numUtil.parseLong((Object)contextCode_hidden));
                user.getContextLink().add(c2);
            }
        }
        user.setEnable("true".equals(request.getParameter("enable")));
        Map ext = user.getExt();
        String field_value_new = request.getParameter("mail");
        String field_name_new = "email";
        String field_modify_new = "open";
        Ext p = new Ext();
        this.save(user, ext, p, field_name_new, field_value_new, field_modify_new);
        return true;
    }

    private void save(User user, Map<String, Ext> ext, Ext p, String field_name, String field_value, String field_modify) {
        p.setFieldName(field_name);
        p.setFieldModify(field_modify);
        p.setFieldValue(field_value);
        p.setRegistUid(user.getUpdateUid());
        p.setUpdateUid(user.getUpdateUid());
        p.setVerifyStartdate(user.getVerifyStartdate());
        p.setVerifyEnddate(user.getVerifyEnddate());
        p.setEnable(true);
        ext.put(p.getFieldName(), p);
    }
}

