/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.sql.Connection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetXAConnection;
import org.apache.derby.client.net.NetXAResource;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derby.jdbc.ClientXADataSource;

public class ClientXAConnection
extends ClientPooledConnection
implements XAConnection {
    private static int rmIdSeed_ = 95688932;
    private ClientXADataSource derbyds_ = null;
    private XAResource xares_ = null;
    private NetXAResource netXares_ = null;
    private boolean fFirstGetConnection_ = true;
    private Connection logicalCon_;
    private NetXAConnection controlCon_ = null;

    public ClientXAConnection(ClientXADataSource clientXADataSource, NetLogWriter netLogWriter, String string, String string2) throws SqlException {
        super(clientXADataSource, netLogWriter, string, string2, ClientXAConnection.getUnigueRmId());
        this.derbyds_ = clientXADataSource;
        this.logicalCon_ = super.getConnection();
        this.netXares_ = new NetXAResource(this, this.rmId_, string, string2, this.netXAPhysicalConnection_);
        this.xares_ = this.netXares_;
    }

    public Connection getConnection() throws SqlException {
        if (this.fFirstGetConnection_) {
            this.fFirstGetConnection_ = false;
        } else {
            this.logicalCon_ = super.getConnection();
            if (this.physicalConnection_ != null && this.netXAPhysicalConnection_ != null) {
                this.netXares_.initForReuse();
            }
        }
        return this.logicalCon_;
    }

    private static synchronized int getUnigueRmId() {
        return ++rmIdSeed_;
    }

    public int getRmId() {
        return this.rmId_;
    }

    public XAResource getXAResource() throws SqlException {
        if (this.logWriter_ != null) {
            this.logWriter_.traceExit((Object)this, "getXAResource", this.xares_);
        }
        return this.xares_;
    }

    public ClientXADataSource getDataSource() throws SqlException {
        if (this.logWriter_ != null) {
            this.logWriter_.traceExit((Object)this, "getDataSource", this.derbyds_);
        }
        return this.derbyds_;
    }

    public NetXAConnection createControlConnection(NetLogWriter netLogWriter, String string, String string2, ClientDataSource clientDataSource, int n, boolean bl) throws SqlException {
        this.controlCon_ = new NetXAConnection(netLogWriter, string, string2, clientDataSource, n, bl);
        this.controlCon_.setTransactionIsolation(1);
        if (this.logWriter_ != null) {
            this.logWriter_.traceExit((Object)this, "createControlConnection", this.controlCon_);
        }
        return this.controlCon_;
    }

    public synchronized void close() throws SqlException {
        super.close();
    }
}

