/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RealmVerifier {
    private static Logger _log = Logger.getLogger((Class)RealmVerifier.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final int OK = 0;
    public static final int DENIED_REALM = 1;
    public static final int MALFORMED_REALM = 2;
    public static final int MALFORMED_RETURN_TO_URL = 3;
    public static final int FRAGMENT_NOT_ALLOWED = 4;
    public static final int PROTOCOL_MISMATCH = 5;
    public static final int PORT_MISMATCH = 6;
    public static final int PATH_MISMATCH = 7;
    public static final int DOMAIN_MISMATCH = 8;
    private List _deniedRealmDomains = new ArrayList();
    private List _deniedRealmRegExps;

    public RealmVerifier() {
        this.addDeniedRealmDomain("\\*\\.[^\\.]+");
        this.addDeniedRealmDomain("\\*\\.[a-z]{2}\\.[a-z]{2}");
    }

    public void addDeniedRealmDomain(String deniedRealmDomain) {
        this._deniedRealmDomains.add(deniedRealmDomain);
        this.compileDeniedRealms();
    }

    public List getDeniedRealmDomains() {
        return this._deniedRealmDomains;
    }

    public void setDeniedRealmDomains(List deniedRealmDomains) {
        this._deniedRealmDomains = deniedRealmDomains;
        this.compileDeniedRealms();
    }

    private void compileDeniedRealms() {
        this._deniedRealmRegExps = new ArrayList(this._deniedRealmDomains.size());
        for (int i = 0; i < this._deniedRealmDomains.size(); ++i) {
            String deniedRealm = (String)this._deniedRealmDomains.get(i);
            Pattern deniedRealmPattern = Pattern.compile(deniedRealm, 2);
            this._deniedRealmRegExps.add(deniedRealmPattern);
        }
    }

    public int match(String realm, String returnTo) {
        URL returnToUrl;
        URL realmUrl;
        if (DEBUG) {
            _log.debug((Object)("Verifying realm: " + realm + " on return URL: " + returnTo));
        }
        try {
            realmUrl = new URL(realm);
        }
        catch (MalformedURLException e) {
            _log.error((Object)("Invalid realm URL: " + realm), (Throwable)e);
            return 2;
        }
        String realmDomain = realmUrl.getHost();
        if (this.isDeniedRealmDomain(realmDomain)) {
            _log.warn((Object)("Blacklisted realm domain: " + realmDomain));
            return 1;
        }
        try {
            returnToUrl = new URL(returnTo);
        }
        catch (MalformedURLException e) {
            _log.error((Object)("Invalid return URL: " + returnTo));
            return 3;
        }
        if (realmUrl.getRef() != null) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: URL fragments are not allowed.");
            }
            return 4;
        }
        if (!realmUrl.getProtocol().equalsIgnoreCase(returnToUrl.getProtocol())) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: protocol mismatch.");
            }
            return 5;
        }
        if (!this.domainMatch(realmDomain, returnToUrl.getHost())) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: domain mismatch.");
            }
            return 8;
        }
        if (!this.portMatch(realmUrl, returnToUrl)) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: port mismatch.");
            }
            return 6;
        }
        if (!this.pathMatch(realmUrl, returnToUrl)) {
            if (DEBUG) {
                _log.debug((Object)"Realm verification failed: path mismatch.");
            }
            return 7;
        }
        _log.info((Object)("Realm verified: " + realm));
        return 0;
    }

    private boolean isDeniedRealmDomain(String realmDomain) {
        for (int i = 0; i < this._deniedRealmRegExps.size(); ++i) {
            Pattern realmPattern = (Pattern)this._deniedRealmRegExps.get(i);
            if (!realmPattern.matcher(realmDomain).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean portMatch(URL realmUrl, URL returnToUrl) {
        int realmPort = realmUrl.getPort();
        int returnToPort = returnToUrl.getPort();
        if (realmPort == -1) {
            realmPort = realmUrl.getDefaultPort();
        }
        if (returnToPort == -1) {
            returnToPort = returnToUrl.getDefaultPort();
        }
        return realmPort == returnToPort;
    }

    private boolean pathMatch(URL realmUrl, URL returnToUrl) {
        String realmPath = realmUrl.getPath();
        String returnToPath = returnToUrl.getPath();
        if (!realmPath.endsWith("/")) {
            realmPath = realmPath + "/";
        }
        if (!returnToPath.endsWith("/")) {
            returnToPath = returnToPath + "/";
        }
        return returnToPath.startsWith(realmPath);
    }

    private boolean domainMatch(String realmDomain, String returnToDomain) {
        if (realmDomain.startsWith("*.")) {
            realmDomain = realmDomain.substring(1).toLowerCase();
            returnToDomain = "." + returnToDomain.toLowerCase();
            return returnToDomain.endsWith(realmDomain);
        }
        return realmDomain.equalsIgnoreCase(returnToDomain);
    }
}

