/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.nyx.SecureSwitchUtility;
import jp.nyx.loader.NyxBootLoader;
import jp.nyx.update.NyxDownload;
import jp.nyx.update.NyxDownloadObserverImpl;
import jp.nyx.update.NyxUpdate;
import jp.nyx.update.NyxUpdateObserverImpl;

public class SecureSwitch {
    public static final String VERSION = "1.0.2";
    private static final Pattern macro = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private static final Pattern cleanProp = Pattern.compile("nyx\\.clean\\.(.+)");
    private static final Pattern nyxEditLibProp = Pattern.compile("nyx\\.edit\\.libs\\.(.+)");
    private static final Pattern nyxEditDirProp = Pattern.compile("nyx\\.edit\\.dirs\\.(.+)");
    private static final Pattern nyxEditVmProp = Pattern.compile("nyx\\.edit\\.property\\.(.+)");
    private static final Pattern nyxEditExProp = Pattern.compile("nyx\\.edit\\.extends\\.(.+)");
    private static final Pattern nyxCliLibProp = Pattern.compile("nyx\\.cli\\.libs\\.(.+)");
    private static final Pattern nyxCliDirProp = Pattern.compile("nyx\\.cli\\.dirs\\.(.+)");
    private static final Pattern nyxCliVmProp = Pattern.compile("nyx\\.cli\\.property\\.(.+)");
    private static final Pattern nyxCliExProp = Pattern.compile("nyx\\.cli\\.extends\\.(.+)");
    private static final Pattern servletVmProp = Pattern.compile("servlet\\.container\\.property\\.(.+)");
    private static final Pattern servletExProp = Pattern.compile("servlet\\.container\\.extends\\.(.+)");
    private static final Pattern servletBootDirProp = Pattern.compile("servlet\\.container\\.boot\\.dirs\\.(.+)");
    private static final Pattern servletBootLibProp = Pattern.compile("servlet\\.container\\.boot\\.libs\\.(.+)");
    private static final Pattern nyxUpdateLibProp = Pattern.compile("nyx\\.update\\.libs\\.(.+)");
    private static final Pattern nyxUpdateDirProp = Pattern.compile("nyx\\.update\\.dirs\\.(.+)");
    private static final Pattern nyxDownloadUrlProp = Pattern.compile("nyx\\.download\\.urls\\.(.+)");
    private static final Pattern nyxDownloadLibProp = Pattern.compile("nyx\\.download\\.libs\\.(.+)");
    private static final Pattern nyxDownloadDirProp = Pattern.compile("nyx\\.download\\.dirs\\.(.+)");
    private String[] args;
    private String confFile;
    private Mode mode;
    private Properties configure = new Properties();
    private Properties nyxEditVmArgs = new Properties();
    private Properties nyxEditExArgs = new Properties();
    private Properties nyxCliVmArgs = new Properties();
    private Properties nyxCliExArgs = new Properties();
    private Properties servletVmArgs = new Properties();
    private Properties servletExArgs = new Properties();
    private ArrayList<File> cleanFiles = new ArrayList();
    private ArrayList<File> nyxEditLib = new ArrayList();
    private ArrayList<File> nyxEditDir = new ArrayList();
    private ArrayList<File> nyxCliLib = new ArrayList();
    private ArrayList<File> nyxCliDir = new ArrayList();
    private ArrayList<File> servletBootDir = new ArrayList();
    private ArrayList<File> servletBootLib = new ArrayList();
    private ArrayList<File> nyxUpdateLib = new ArrayList();
    private ArrayList<File> nyxUpdateDir = new ArrayList();
    private ArrayList<String> nyxDownloadUrl = new ArrayList();
    private ArrayList<File> nyxDownloadLib = new ArrayList();
    private ArrayList<File> nyxDownloadDir = new ArrayList();

    public SecureSwitch(String[] args) throws IOException {
        if (args == null) {
            throw new UnsupportedOperationException("Args is null.");
        }
        this.args = args;
    }

    public boolean initEnveloment() throws IOException {
        String nyxHome = System.getProperty("nyx.home", ".");
        this.confFile = System.getProperty("nyx.conf", new File(new File(nyxHome).getAbsoluteFile(), "/conf/nyx.properties").getAbsolutePath());
        SecureSwitchUtility.getOut().println("============================================================");
        SecureSwitchUtility.getOut().println("[ SecureSwitch BootLoader version 1.0.2]");
        SecureSwitchUtility.getOut().println("  Powered by Nyx Kernel");
        SecureSwitchUtility.getOut().println("  Copyright (C) Nyx Project. All right reserved.");
        SecureSwitchUtility.getOut().println("============================================================");
        SecureSwitchUtility.getOut().println("nyx.home : " + nyxHome);
        SecureSwitchUtility.getOut().println("nyx.conf : " + this.confFile);
        SecureSwitchUtility.getOut().println("------------------------------------------------------------");
        if (this.args.length > 0) {
            this.mode = Mode.parse(this.args[0]);
        } else {
            SecureSwitchUtility.getOut().println("Boot mode\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            Mode.echoHelp();
            SecureSwitchUtility.getOut().print("Boot mode\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044 > ");
            String[] part = SecureSwitchUtility.getInput().split("\\s+");
            if (part == null || part.length <= 0) {
                part = new String[]{Mode.HELP.value};
            }
            this.args = part;
            this.mode = Mode.parse(part[0]);
        }
        SecureSwitchUtility.getOut().println("Boot mode : " + (Object)((Object)this.mode));
        SecureSwitchUtility.getOut().println("");
        Properties conf = new Properties();
        conf.load(new FileInputStream(this.confFile));
        if (!".".equals(nyxHome)) {
            conf.setProperty("nyx.home", nyxHome.replace("\\", "\\\\"));
        }
        this.initEnveloment(conf);
        for (Object key : this.configure.keySet()) {
            String value = this.configure.getProperty((String)key);
            Matcher servletVmPropMt = servletVmProp.matcher((String)key);
            if (servletVmPropMt.find()) {
                this.servletVmArgs.put(servletVmPropMt.group(1), value);
                continue;
            }
            Matcher servletExPropMt = servletExProp.matcher((String)key);
            if (servletExPropMt.find()) {
                this.servletExArgs.put(servletExPropMt.group(1), value);
                continue;
            }
            Matcher nyxEditVmPropMt = nyxEditVmProp.matcher((String)key);
            if (nyxEditVmPropMt.find()) {
                this.nyxEditVmArgs.put(nyxEditVmPropMt.group(1), value);
                continue;
            }
            Matcher nyxEditExPropMt = nyxEditExProp.matcher((String)key);
            if (nyxEditExPropMt.find()) {
                this.nyxEditExArgs.put(nyxEditExPropMt.group(1), value);
                continue;
            }
            Matcher nyxCliVmPropMt = nyxCliVmProp.matcher((String)key);
            if (nyxCliVmPropMt.find()) {
                this.nyxCliVmArgs.put(nyxCliVmPropMt.group(1), value);
                continue;
            }
            Matcher nyxCliExPropMt = nyxCliExProp.matcher((String)key);
            if (nyxCliExPropMt.find()) {
                this.nyxCliExArgs.put(nyxCliExPropMt.group(1), value);
                continue;
            }
            Matcher cleanPropMt = cleanProp.matcher((String)key);
            if (cleanPropMt.find()) {
                this.cleanFiles.add(new File(value));
                continue;
            }
            Matcher nyxEditPropLibMt = nyxEditLibProp.matcher((String)key);
            if (nyxEditPropLibMt.find()) {
                this.nyxEditLib.add(new File(value));
                continue;
            }
            Matcher nyxEditPropDirMt = nyxEditDirProp.matcher((String)key);
            if (nyxEditPropDirMt.find()) {
                this.nyxEditDir.add(new File(value));
                continue;
            }
            Matcher nyxCliPropLibMt = nyxCliLibProp.matcher((String)key);
            if (nyxCliPropLibMt.find()) {
                this.nyxCliLib.add(new File(value));
                continue;
            }
            Matcher nyxCliPropDirMt = nyxCliDirProp.matcher((String)key);
            if (nyxCliPropDirMt.find()) {
                this.nyxCliDir.add(new File(value));
                continue;
            }
            Matcher servletBootDirPropMt = servletBootDirProp.matcher((String)key);
            if (servletBootDirPropMt.find()) {
                this.servletBootDir.add(new File(value));
                continue;
            }
            Matcher servletBootLibPropMt = servletBootLibProp.matcher((String)key);
            if (servletBootLibPropMt.find()) {
                this.servletBootLib.add(new File(value));
                continue;
            }
            Matcher nyxUpdatePropLibMt = nyxUpdateLibProp.matcher((String)key);
            if (nyxUpdatePropLibMt.find()) {
                this.nyxUpdateLib.add(new File(value));
                continue;
            }
            Matcher nyxUpdatePropDirMt = nyxUpdateDirProp.matcher((String)key);
            if (nyxUpdatePropDirMt.find()) {
                this.nyxUpdateDir.add(new File(value));
                continue;
            }
            Matcher nyxDownloadPropUrlMt = nyxDownloadUrlProp.matcher((String)key);
            if (nyxDownloadPropUrlMt.find()) {
                this.nyxDownloadUrl.add(value);
                continue;
            }
            Matcher nyxDownloadPropLibMt = nyxDownloadLibProp.matcher((String)key);
            if (nyxDownloadPropLibMt.find()) {
                this.nyxDownloadLib.add(new File(value));
                continue;
            }
            Matcher nyxDownloadPropDirMt = nyxDownloadDirProp.matcher((String)key);
            if (!nyxDownloadPropDirMt.find()) continue;
            this.nyxDownloadDir.add(new File(value));
        }
        return true;
    }

    private void initEnveloment(Properties conf) {
        String value;
        Matcher macroMt;
        boolean foundMacro = false;
        for (Object key : conf.keySet()) {
            if (!(key instanceof String) || !(macroMt = macro.matcher(value = conf.getProperty((String)key))).find()) continue;
            foundMacro = true;
            break;
        }
        if (!foundMacro) {
            return;
        }
        for (Object key : conf.keySet()) {
            String v;
            if (!(key instanceof String)) continue;
            value = conf.getProperty((String)key);
            macroMt = macro.matcher(value);
            if (macroMt.find() && (v = this.configure.getProperty(macroMt.group(1))) != null) {
                v = v.replace("$", "\\$");
                value = macroMt.replaceAll(v);
            }
            this.configure.put(key, value);
        }
        this.initEnveloment(this.configure);
    }

    private boolean delete(File file) {
        if (!file.exists()) {
            SecureSwitchUtility.getErr().println("Not found : " + file.getAbsolutePath());
            return false;
        }
        if (file.delete()) {
            SecureSwitchUtility.getOut().println("Delete Success : " + file.getAbsolutePath());
            return true;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (this.delete(f)) continue;
                SecureSwitchUtility.getErr().println("Delete Failed : " + f.getAbsolutePath());
            }
            if (file.delete()) {
                SecureSwitchUtility.getOut().println("Delete Success : " + file.getAbsolutePath());
                return true;
            }
        }
        return false;
    }

    public void execute() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException, InterruptedException, URISyntaxException, NoSuchFieldException {
        if (Mode.HELP == this.mode) {
            SecureSwitchUtility.getOut().println("-- Command Usage -------------------------------------------");
            SecureSwitchUtility.getOut().println("java -Dnyx.home=<NYX_HOME> -Dnyx.conf=<NYX_CONF> ");
            SecureSwitchUtility.getOut().println("     -cp <CLASSPATH> jp.nyx.SecureSwitch <BOOT_MODE>");
            SecureSwitchUtility.getOut().println("");
            SecureSwitchUtility.getOut().println(" NYX_HOME  : It's SecureSwitch home directory.");
            SecureSwitchUtility.getOut().println(" NYX_CONF  : It's nyx.properties file path.");
            SecureSwitchUtility.getOut().println(" CLASSPATH : It's nyx-loader.jar file path.");
            SecureSwitchUtility.getOut().println(" BOOT_MODE");
            Mode.echoHelp();
            return;
        }
        if (Mode.CLEAN == this.mode) {
            for (File f : this.cleanFiles) {
                this.delete(f);
            }
            return;
        }
        if (Mode.ENV == this.mode) {
            NyxBootLoader nyxEditLoader = new NyxBootLoader(this.nyxEditLib.toArray(new File[0]), this.nyxEditDir.toArray(new File[0]));
            NyxBootLoader nyxCliLoader = new NyxBootLoader(this.nyxCliLib.toArray(new File[0]), this.nyxCliDir.toArray(new File[0]));
            NyxBootLoader nyxDownloadLoader = new NyxBootLoader(this.nyxDownloadLib.toArray(new File[0]), this.nyxDownloadDir.toArray(new File[0]));
            NyxBootLoader nyxUpdateLoader = new NyxBootLoader(this.nyxUpdateLib.toArray(new File[0]), this.nyxUpdateDir.toArray(new File[0]));
            NyxBootLoader servletLoader = new NyxBootLoader(this.servletBootLib.toArray(new File[0]));
            SecureSwitchUtility.getOut().println("-- " + this.confFile + " ---------");
            this.configure.store(SecureSwitchUtility.getOut(), "SecureSwitch System Properties");
            SecureSwitchUtility.getOut().println("");
            SecureSwitchUtility.getOut().println("-- Nyx CLI jar files -----------------------------------------");
            for (URL u : nyxCliLoader.getUrls()) {
                SecureSwitchUtility.getOut().println(u);
            }
            SecureSwitchUtility.getOut().println("-- Nyx Edit jar files -----------------------------------------");
            for (URL u : nyxEditLoader.getUrls()) {
                SecureSwitchUtility.getOut().println(u);
            }
            SecureSwitchUtility.getOut().println("-- Nyx Update jar files -----------------------------------------");
            for (URL u : nyxUpdateLoader.getUrls()) {
                SecureSwitchUtility.getOut().println(u);
            }
            SecureSwitchUtility.getOut().println("-- Nyx Update Module Download jar files -----------------------------------------");
            for (URL u : nyxDownloadLoader.getUrls()) {
                SecureSwitchUtility.getOut().println(u);
            }
            SecureSwitchUtility.getOut().println("-- Servlet Boot jar files -----------------------------------------");
            for (URL u : servletLoader.getUrls()) {
                SecureSwitchUtility.getOut().println(u);
            }
            return;
        }
        if (Mode.EDIT == this.mode) {
            File home = new File(this.configure.getProperty("nyx.edit.home"));
            File[] bootLibs = this.nyxEditLib.toArray(new File[0]);
            File[] bootDirs = this.nyxEditDir.toArray(new File[0]);
            String bootClassName = this.configure.getProperty("nyx.edit.class");
            List<String> cmdarray = this.makeJavaCommandArray(this.nyxEditVmArgs, this.nyxEditExArgs, bootLibs, bootDirs, bootClassName);
            this.printCommand(cmdarray);
            Process p = Runtime.getRuntime().exec(cmdarray.toArray(new String[0]), null, home);
            this.waitProcess(p);
            return;
        }
        if (Mode.CLI == this.mode) {
            File home = new File(this.configure.getProperty("nyx.cli.home"));
            File[] bootLibs = this.nyxCliLib.toArray(new File[0]);
            File[] bootDirs = this.nyxCliDir.toArray(new File[0]);
            String bootClassName = this.configure.getProperty("nyx.cli.class");
            List<String> cmdarray = this.makeJavaCommandArray(this.nyxCliVmArgs, this.nyxCliExArgs, bootLibs, bootDirs, bootClassName);
            for (int i = 1; i < this.args.length; ++i) {
                cmdarray.add(this.args[i]);
            }
            this.printCommand(cmdarray);
            Process p = Runtime.getRuntime().exec(cmdarray.toArray(new String[0]), null, home);
            this.waitProcess(p);
            return;
        }
        if (Mode.UPDATE == this.mode) {
            SecureSwitchUtility.getOut().println("-- Local Update -------------------------------------------");
            NyxBootLoader nyxUpdateLoader = new NyxBootLoader(this.nyxUpdateLib.toArray(new File[0]), this.nyxUpdateDir.toArray(new File[0]));
            File nyxHome = new File(System.getProperty("nyx.home", "."));
            File updateDir = new File(this.configure.getProperty("nyx.update.base"));
            NyxUpdateObserverImpl observer = new NyxUpdateObserverImpl();
            NyxUpdate update = new NyxUpdate(nyxHome, updateDir, observer);
            update.update(nyxUpdateLoader);
            return;
        }
        if (Mode.DOWNLOAD == this.mode) {
            SecureSwitchUtility.getOut().println("-- Download -------------------------------------------");
            NyxBootLoader nyxDownloadLoader = new NyxBootLoader(this.nyxDownloadLib.toArray(new File[0]), this.nyxDownloadDir.toArray(new File[0]));
            File nyxHome = new File(System.getProperty("nyx.home", "."));
            String[] startURLs = this.nyxDownloadUrl.toArray(new String[0]);
            File downloadDir = new File(this.configure.getProperty("nyx.download.dir"));
            NyxDownloadObserverImpl observer = new NyxDownloadObserverImpl();
            NyxDownload download = new NyxDownload(nyxHome, startURLs, downloadDir, observer);
            download.download(nyxDownloadLoader);
            return;
        }
        File home = new File(this.configure.getProperty("servlet.container.home"));
        File[] servletBootLibs = this.servletBootLib.toArray(new File[0]);
        File[] servletBootDirs = this.servletBootDir.toArray(new File[0]);
        String servletBootClassName = this.configure.getProperty("servlet.container.class");
        if (Mode.START == this.mode) {
            List<String> cmdarray = this.makeJavaCommandArray(this.servletVmArgs, this.servletExArgs, servletBootLibs, servletBootDirs, servletBootClassName);
            cmdarray.add(this.configure.getProperty("servlet.container.command.start"));
            this.printCommand(cmdarray);
            Process p = Runtime.getRuntime().exec(cmdarray.toArray(new String[0]), null, home);
            this.waitProcess(p);
            return;
        }
        if (Mode.STOP == this.mode) {
            List<String> cmdarray = this.makeJavaCommandArray(this.servletVmArgs, new Properties(), servletBootLibs, servletBootDirs, servletBootClassName);
            cmdarray.add(this.configure.getProperty("servlet.container.command.stop"));
            this.printCommand(cmdarray);
            Process p = Runtime.getRuntime().exec(cmdarray.toArray(new String[0]), null, home);
            this.waitProcess(p);
            return;
        }
    }

    private void printCommand(List<String> cmdarray) {
        SecureSwitchUtility.getOut().println("--");
        for (String cmd : cmdarray) {
            SecureSwitchUtility.getOut().print(cmd + " ");
        }
        SecureSwitchUtility.getOut().println("");
    }

    private List<String> makeJavaCommandArray(Properties vmArgs, Properties exArgs, File[] libPath, File[] classPath, String bootClassName) throws URISyntaxException {
        String javaHome = System.getProperty("java.home");
        String javaCommand = new File(javaHome, "bin/java").getAbsolutePath();
        if (System.getProperty("os.name").startsWith("Windows")) {
            javaCommand = javaCommand + ".exe";
        }
        ArrayList<String> cmdarray = new ArrayList<String>();
        cmdarray.add(javaCommand);
        for (Object key : vmArgs.keySet()) {
            cmdarray.add("-D" + key + "=" + vmArgs.getProperty((String)key));
        }
        for (Object key : exArgs.keySet()) {
            cmdarray.add("-X" + exArgs.getProperty((String)key));
        }
        cmdarray.add("-cp");
        NyxBootLoader loader = new NyxBootLoader(libPath, classPath);
        StringBuilder cp = new StringBuilder();
        for (URL u : loader.getUrls()) {
            cp.append(new File(u.toURI()).getAbsolutePath());
            cp.append(File.pathSeparatorChar);
        }
        cmdarray.add(cp.toString());
        cmdarray.add(bootClassName);
        return cmdarray;
    }

    private void waitProcess(Process p) {
        final BufferedInputStream bstd = new BufferedInputStream(p.getInputStream());
        final BufferedInputStream berr = new BufferedInputStream(p.getErrorStream());
        Thread ts = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int b = -1;
                    while ((b = bstd.read()) > 0) {
                        SecureSwitchUtility.getOut().write(b);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Thread te = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int b = -1;
                    while ((b = berr.read()) > 0) {
                        SecureSwitchUtility.getOut().write(b);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        ts.start();
        te.start();
    }

    public static void main(String[] args) {
        try {
            SecureSwitch ss = new SecureSwitch(args);
            if (ss.initEnveloment()) {
                ss.execute();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static enum Mode {
        START("start", "SecureSwitch\u3092\u8d77\u52d5\u3057\u307e\u3059"),
        STOP("stop", "SecureSwitch\u3092\u505c\u6b62\u3057\u307e\u3059"),
        UPDATE("update", "SecureSwitch\u306e\u30d7\u30ed\u30b0\u30e9\u30e0\u3092\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u3057\u307e\u3059"),
        DOWNLOAD("download", "\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3057\u307e\u3059"),
        EDIT("edit", "SecureSwitch\u306e\u30ab\u30fc\u30cd\u30eb\u8a2d\u5b9aDB\u3092\u7de8\u96c6\u3057\u307e\u3059"),
        CLEAN("clean", "SecureSwitch\u306e\u30c6\u30f3\u30dd\u30e9\u30ea\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3057\u307e\u3059"),
        ENV("env", "SecureSwitch\u306e\u74b0\u5883\u8a2d\u5b9a\u3092\u8868\u793a\u3057\u307e\u3059"),
        CLI("cli", "SecureSwitch\u306eRPC\u30b3\u30de\u30f3\u30c9\u3092\u5b9f\u884c\u3057\u307e\u3059"),
        HELP("help", "\u30d8\u30eb\u30d7\u3092\u8868\u793a\u3057\u307e\u3059");

        private String value;
        private String text;

        private Mode(String value, String text) {
            this.value = value;
            this.text = text;
        }

        public static Mode parse(String value) {
            for (Mode m : Mode.values()) {
                if (!m.value.equals(value)) continue;
                return m;
            }
            return HELP;
        }

        public static void echoHelp() {
            for (Mode m : Mode.values()) {
                SecureSwitchUtility.getOut().print("  ");
                SecureSwitchUtility.getOut().print(m.value);
                SecureSwitchUtility.getOut().print("\t: ");
                SecureSwitchUtility.getOut().println(m.text);
            }
        }
    }
}

