/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.io.Serializable;
import java.util.Date;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.openid4java.consumer.AbstractNonceVerifier;

public class EhcacheNonceVerifier
extends AbstractNonceVerifier {
    private static Logger _log = Logger.getLogger((Class)EhcacheNonceVerifier.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private Cache _cache;

    public EhcacheNonceVerifier(int maxAge) {
        super(maxAge);
    }

    public void setCache(Cache cache) {
        if (cache.getTimeToLiveSeconds() != (long)this._maxAge) {
            throw new IllegalArgumentException("Max Age: " + this._maxAge + ", same expected for cache, but found: " + cache.getTimeToLiveSeconds());
        }
        if (cache.getTimeToLiveSeconds() != cache.getTimeToIdleSeconds()) {
            throw new IllegalArgumentException("Cache must have same timeToLive (" + cache.getTimeToLiveSeconds() + ") as timeToIdle (" + cache.getTimeToIdleSeconds() + ")");
        }
        this._cache = cache;
    }

    protected int seen(Date now, String idpUrl, String nonce) {
        String pair = idpUrl + '#' + nonce;
        Element element = new Element((Serializable)((Object)pair), (Serializable)((Object)pair));
        if (this._cache.get((Serializable)((Object)pair)) != null) {
            _log.error((Object)("Possible replay attack! Already seen nonce: " + nonce));
            return 1;
        }
        this._cache.put(element);
        if (DEBUG) {
            _log.debug((Object)("Nonce verified: " + nonce));
        }
        return 0;
    }
}

