/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import org.apache.log4j.Logger;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;

public class IndirectError
extends Message {
    private static Logger _log = Logger.getLogger((Class)IndirectError.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected IndirectError(String msg, String returnTo) {
        this(msg, returnTo, false);
    }

    protected IndirectError(String msg, String returnTo, boolean compatibility) {
        this.set("openid.mode", "error");
        this.set("openid.error", msg);
        this._destinationUrl = returnTo;
        if (!compatibility) {
            this.set("ns", "http://specs.openid.net/auth/2.0");
        }
    }

    protected IndirectError(ParameterList params) {
        super(params);
    }

    public static IndirectError createIndirectError(String msg, String returnTo) {
        return IndirectError.createIndirectError(msg, returnTo, false);
    }

    public static IndirectError createIndirectError(String msg, String returnTo, boolean compatibility) {
        IndirectError err = new IndirectError(msg, returnTo, compatibility);
        if (!err.isValid()) {
            _log.error((Object)("Invalid " + (compatibility ? "OpenID1" : "OpenID2") + " indirect error message created for message: " + msg));
        }
        _log.debug((Object)("Created indirect error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    public static IndirectError createIndirectError(ParameterList params) {
        IndirectError err = new IndirectError(params);
        if (!err.isValid()) {
            _log.error((Object)("Invalid direct error message created: " + err.keyValueFormEncoding()));
        }
        _log.debug((Object)("Created indirect error message:\n" + err.keyValueFormEncoding()));
        return err;
    }

    public void setErrorMsg(String msg) {
        this.set("openid.error", msg);
    }

    public String getErrorMsg() {
        return this.getParameterValue("openid.error");
    }

    public void setContact(String contact) {
        this.set("openid.contact", contact);
    }

    public String getContact() {
        return this.getParameterValue("openid.contact");
    }

    public void setReference(String reference) {
        this.set("openid.reference", reference);
    }

    public String getReference() {
        return this.getParameterValue("openid.reference");
    }
}

