/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.PGNotification;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.Logger;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Query;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.ResultCursor;
import org.postgresql.core.ResultHandler;
import org.postgresql.core.Utils;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.jdbc2.AbstractJdbc2Statement;
import org.postgresql.jdbc2.TimestampUtils;
import org.postgresql.jdbc2.TypeInfoCache;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.GT;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Connection
implements BaseConnection {
    private static int nextConnectionID = 1;
    private final Logger logger;
    private final String creatingURL;
    private Throwable openStackTrace;
    private final ProtocolConnection protoConnection;
    private final String compatible;
    private final String dbVersionNumber;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private TypeInfoCache _typeCache;
    protected int prepareThreshold;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public final boolean bindStringAsVarchar;
    public SQLWarning firstWarning = null;
    private final TimestampUtils timestampUtils;
    protected Map typemap;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    protected DatabaseMetaData metadata;
    static /* synthetic */ Class class$org$postgresql$jdbc2$AbstractJdbc2Connection;
    static /* synthetic */ Class class$org$postgresql$geometric$PGbox;
    static /* synthetic */ Class class$org$postgresql$geometric$PGcircle;
    static /* synthetic */ Class class$org$postgresql$geometric$PGline;
    static /* synthetic */ Class class$org$postgresql$geometric$PGlseg;
    static /* synthetic */ Class class$org$postgresql$geometric$PGpath;
    static /* synthetic */ Class class$org$postgresql$geometric$PGpoint;
    static /* synthetic */ Class class$org$postgresql$geometric$PGpolygon;
    static /* synthetic */ Class class$org$postgresql$util$PGmoney;
    static /* synthetic */ Class class$org$postgresql$util$PGInterval;

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractJdbc2Connection(String host, int port, String user, String database, Properties info, String url) throws SQLException {
        String stringType;
        this.creatingURL = url;
        int logLevel = Driver.getLogLevel();
        String connectionLogLevel = info.getProperty("loglevel");
        if (connectionLogLevel != null) {
            try {
                logLevel = Integer.parseInt(connectionLogLevel);
            }
            catch (Exception l_e) {
                // empty catch block
            }
        }
        Class clazz = class$org$postgresql$jdbc2$AbstractJdbc2Connection == null ? (class$org$postgresql$jdbc2$AbstractJdbc2Connection = AbstractJdbc2Connection.class$("org.postgresql.jdbc2.AbstractJdbc2Connection")) : class$org$postgresql$jdbc2$AbstractJdbc2Connection;
        synchronized (clazz) {
            this.logger = new Logger(nextConnectionID++);
            this.logger.setLogLevel(logLevel);
        }
        if (logLevel > 0) {
            this.enableDriverManagerLogging();
        }
        this.prepareThreshold = 5;
        try {
            this.prepareThreshold = Integer.parseInt(info.getProperty("prepareThreshold", "5"));
            if (this.prepareThreshold < 0) {
                this.prepareThreshold = 0;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.logger.logInfo()) {
            this.logger.info(Driver.getVersion());
        }
        this.protoConnection = ConnectionFactory.openConnection(host, port, user, database, info, this.logger);
        this.dbVersionNumber = this.protoConnection.getServerVersion();
        this.compatible = info.getProperty("compatible", "8.2");
        if (this.logger.logDebug()) {
            this.logger.debug("    compatible = " + this.compatible);
            this.logger.debug("    loglevel = " + logLevel);
            this.logger.debug("    prepare threshold = " + this.prepareThreshold);
        }
        if ((stringType = info.getProperty("stringtype")) != null) {
            if (stringType.equalsIgnoreCase("unspecified")) {
                this.bindStringAsVarchar = false;
            } else {
                if (!stringType.equalsIgnoreCase("varchar")) throw new PSQLException(GT.tr("Unsupported value for stringtype parameter: {0}", stringType), PSQLState.INVALID_PARAMETER_VALUE);
                this.bindStringAsVarchar = true;
            }
        } else {
            this.bindStringAsVarchar = this.haveMinimumCompatibleVersion("8.0");
        }
        this.timestampUtils = new TimestampUtils(this.haveMinimumServerVersion("7.4"));
        this.commitQuery = this.getQueryExecutor().createSimpleQuery("COMMIT");
        this.rollbackQuery = this.getQueryExecutor().createSimpleQuery("ROLLBACK");
        this._typeCache = new TypeInfoCache(this);
        this.initObjectTypes(info);
        if (!Boolean.valueOf(info.getProperty("logUnclosedConnections")).booleanValue()) return;
        this.openStackTrace = new Throwable("Connection was created at this point:");
        this.enableDriverManagerLogging();
    }

    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    public Map getTypeMap() throws SQLException {
        return this.typemap;
    }

    public QueryExecutor getQueryExecutor() {
        return this.protoConnection.getQueryExecutor();
    }

    public void addWarning(SQLWarning warn) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(warn);
        } else {
            this.firstWarning = warn;
        }
    }

    public ResultSet execSQLQuery(String s) throws SQLException {
        return this.execSQLQuery(s, 1003, 1007);
    }

    public ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseStatement stat = (BaseStatement)this.createStatement(resultSetType, resultSetConcurrency);
        boolean hasResultSet = stat.executeWithFlags(s, 16);
        while (!hasResultSet && stat.getUpdateCount() != -1) {
            hasResultSet = stat.getMoreResults();
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        SQLWarning warnings = stat.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        return stat.getResultSet();
    }

    public void execSQLUpdate(String s) throws SQLException {
        BaseStatement stmt = (BaseStatement)this.createStatement();
        if (stmt.executeWithFlags(s, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        stmt.close();
    }

    public void setCursorName(String cursor) throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.protoConnection.getUser();
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    public Object getObject(String type, String value) throws SQLException {
        SQLData d;
        if (this.typemap != null && (d = (SQLData)this.typemap.get(type)) != null) {
            if (this.logger.logDebug()) {
                this.logger.debug("getObject(String,String) with custom typemap");
            }
            throw Driver.notImplemented(this.getClass(), "getObject(String,String)");
        }
        PGobject obj = null;
        if (this.logger.logDebug()) {
            this.logger.debug("Constructing object from type=" + type + " value=<" + value + ">");
        }
        try {
            Class klass = this._typeCache.getPGobject(type);
            if (klass != null) {
                obj = (PGobject)klass.newInstance();
                obj.setType(type);
                obj.setValue(value);
            } else {
                obj = new PGobject();
                obj.setType(type);
                obj.setValue(value);
            }
            return obj;
        }
        catch (SQLException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Failed to create object for: {0}.", type), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    public void addDataType(String type, String name) {
        try {
            this.addDataType(type, Class.forName(name));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register new type: " + e);
        }
    }

    public void addDataType(String type, Class klass) throws SQLException {
        this._typeCache.addDataType(type, klass);
    }

    private void initObjectTypes(Properties info) throws SQLException {
        this.addDataType("box", class$org$postgresql$geometric$PGbox == null ? (class$org$postgresql$geometric$PGbox = AbstractJdbc2Connection.class$("org.postgresql.geometric.PGbox")) : class$org$postgresql$geometric$PGbox);
        this.addDataType("circle", class$org$postgresql$geometric$PGcircle == null ? (class$org$postgresql$geometric$PGcircle = AbstractJdbc2Connection.class$("org.postgresql.geometric.PGcircle")) : class$org$postgresql$geometric$PGcircle);
        this.addDataType("line", class$org$postgresql$geometric$PGline == null ? (class$org$postgresql$geometric$PGline = AbstractJdbc2Connection.class$("org.postgresql.geometric.PGline")) : class$org$postgresql$geometric$PGline);
        this.addDataType("lseg", class$org$postgresql$geometric$PGlseg == null ? (class$org$postgresql$geometric$PGlseg = AbstractJdbc2Connection.class$("org.postgresql.geometric.PGlseg")) : class$org$postgresql$geometric$PGlseg);
        this.addDataType("path", class$org$postgresql$geometric$PGpath == null ? (class$org$postgresql$geometric$PGpath = AbstractJdbc2Connection.class$("org.postgresql.geometric.PGpath")) : class$org$postgresql$geometric$PGpath);
        this.addDataType("point", class$org$postgresql$geometric$PGpoint == null ? (class$org$postgresql$geometric$PGpoint = AbstractJdbc2Connection.class$("org.postgresql.geometric.PGpoint")) : class$org$postgresql$geometric$PGpoint);
        this.addDataType("polygon", class$org$postgresql$geometric$PGpolygon == null ? (class$org$postgresql$geometric$PGpolygon = AbstractJdbc2Connection.class$("org.postgresql.geometric.PGpolygon")) : class$org$postgresql$geometric$PGpolygon);
        this.addDataType("money", class$org$postgresql$util$PGmoney == null ? (class$org$postgresql$util$PGmoney = AbstractJdbc2Connection.class$("org.postgresql.util.PGmoney")) : class$org$postgresql$util$PGmoney);
        this.addDataType("interval", class$org$postgresql$util$PGInterval == null ? (class$org$postgresql$util$PGInterval = AbstractJdbc2Connection.class$("org.postgresql.util.PGInterval")) : class$org$postgresql$util$PGInterval);
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            Class<?> klass;
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith("datatype.")) continue;
            String typeName = propertyName.substring(9);
            String className = info.getProperty(propertyName);
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PSQLException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", new Object[]{className, typeName}), PSQLState.SYSTEM_ERROR, (Throwable)cnfe);
            }
            this.addDataType(typeName, klass);
        }
    }

    public void close() {
        this.protoConnection.close();
        this.openStackTrace = null;
    }

    public String nativeSQL(String sql) throws SQLException {
        StringBuffer buf = new StringBuffer(sql.length());
        AbstractJdbc2Statement.parseSql(sql, 0, buf, false, this.getStandardConformingStrings());
        return buf.toString();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        SQLWarning newWarnings = this.protoConnection.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = newWarnings;
        } else {
            this.firstWarning.setNextWarning(newWarnings);
        }
        return this.firstWarning;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.protoConnection.getWarnings();
        this.firstWarning = null;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (this.haveMinimumServerVersion("7.4") && readOnly != this.readOnly) {
            String readOnlySql = "SET SESSION CHARACTERISTICS AS TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE");
            this.execSQLUpdate(readOnlySql);
        }
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        this.getQueryExecutor().execute(query, null, (ResultHandler)new TransactionCommandHandler(), 0, 0, 22);
    }

    public void commit() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    public void rollback() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.rollbackQuery);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        String level = null;
        if (this.haveMinimumServerVersion("7.3")) {
            ResultSet rs = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
            if (rs.next()) {
                level = rs.getString(1);
            }
            rs.close();
        } else {
            SQLWarning saveWarnings = this.getWarnings();
            this.clearWarnings();
            this.execSQLUpdate("SHOW TRANSACTION ISOLATION LEVEL");
            SQLWarning warning = this.getWarnings();
            if (warning != null) {
                level = warning.getMessage();
            }
            this.clearWarnings();
            if (saveWarnings != null) {
                this.addWarning(saveWarnings);
            }
        }
        if (level == null) {
            return 2;
        }
        if ((level = level.toUpperCase()).indexOf("READ COMMITTED") != -1) {
            return 2;
        }
        if (level.indexOf("READ UNCOMMITTED") != -1) {
            return 1;
        }
        if (level.indexOf("REPEATABLE READ") != -1) {
            return 4;
        }
        if (level.indexOf("SERIALIZABLE") != -1) {
            return 8;
        }
        return 2;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String isolationLevelName = this.getIsolationLevelName(level);
        if (isolationLevelName == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", new Integer(level)), PSQLState.NOT_IMPLEMENTED);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
    }

    protected String getIsolationLevelName(int level) {
        boolean pg80 = this.haveMinimumServerVersion("8.0");
        if (level == 2) {
            return "READ COMMITTED";
        }
        if (level == 8) {
            return "SERIALIZABLE";
        }
        if (pg80 && level == 1) {
            return "READ UNCOMMITTED";
        }
        if (pg80 && level == 4) {
            return "REPEATABLE READ";
        }
        return null;
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.protoConnection.getDatabase();
    }

    protected void finalize() throws Throwable {
        if (this.openStackTrace != null) {
            this.logger.log(GT.tr("Finalizing a Connection that was never closed:"), this.openStackTrace);
        }
        this.close();
    }

    public String getDBVersionNumber() {
        return this.dbVersionNumber;
    }

    private static int integerPart(String dirtyString) {
        int start = 0;
        while (start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start))) {
            ++start;
        }
        int end = start;
        while (end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end))) {
            ++end;
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            versionTokens.nextToken();
            return AbstractJdbc2Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public boolean haveMinimumServerVersion(String ver) {
        return this.dbVersionNumber.compareTo(ver) >= 0;
    }

    public boolean haveMinimumCompatibleVersion(String ver) {
        return this.compatible.compareTo(ver) >= 0;
    }

    public Encoding getEncoding() {
        return this.protoConnection.getEncoding();
    }

    public byte[] encodeString(String str) throws SQLException {
        try {
            return this.getEncoding().encode(str);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding."), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    public String escapeString(String str) throws SQLException {
        return Utils.appendEscapedString(null, str, this.protoConnection.getStandardConformingStrings()).toString();
    }

    public boolean getStandardConformingStrings() {
        return this.protoConnection.getStandardConformingStrings();
    }

    public int getSQLType(int oid) throws SQLException {
        return this._typeCache.getSQLType(oid);
    }

    public Iterator getPGTypeNamesWithSQLTypes() {
        AbstractJdbc2Connection abstractJdbc2Connection = this;
        return abstractJdbc2Connection._typeCache.getPGTypeNamesWithSQLTypes();
    }

    public int getPGType(String typeName) throws SQLException {
        return this._typeCache.getPGType(typeName);
    }

    public String getJavaClass(int oid) throws SQLException {
        return this._typeCache.getJavaClass(oid);
    }

    public String getPGType(int oid) throws SQLException {
        return this._typeCache.getPGType(oid);
    }

    public boolean isClosed() throws SQLException {
        return this.protoConnection.isClosed();
    }

    public void cancelQuery() throws SQLException {
        this.protoConnection.sendQueryCancel();
    }

    public PGNotification[] getNotifications() throws SQLException {
        PGNotification[] notifications = this.protoConnection.getNotifications();
        return notifications.length == 0 ? null : notifications;
    }

    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    public void setPrepareThreshold(int newThreshold) {
        this.prepareThreshold = newThreshold <= 0 ? 0 : newThreshold;
    }

    public void setTypeMapImpl(Map map) throws SQLException {
        this.typemap = map;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogWriter() == null) {
            DriverManager.setLogWriter(new PrintWriter(System.out, true));
        }
    }

    public int getSQLType(String pgTypeName) {
        return TypeInfoCache.getSQLType(pgTypeName);
    }

    public int getProtocolVersion() {
        return this.protoConnection.getProtocolVersion();
    }

    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TransactionCommandHandler
    implements ResultHandler {
        private SQLException error;

        private TransactionCommandHandler() {
        }

        public void handleResultRows(Query fromQuery, Field[] fields, Vector tuples, ResultCursor cursor) {
        }

        public void handleCommandStatus(String status, int updateCount, long insertOID) {
        }

        public void handleWarning(SQLWarning warning) {
            AbstractJdbc2Connection.this.addWarning(warning);
        }

        public void handleError(SQLException newError) {
            if (this.error == null) {
                this.error = newError;
            } else {
                this.error.setNextException(newError);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

