/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import org.apache.catalina.cluster.MembershipListener;
import org.apache.catalina.cluster.mcast.McastMember;
import org.apache.catalina.cluster.mcast.McastMembership;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class McastServiceImpl {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$mcast$McastService == null ? (class$org$apache$catalina$cluster$mcast$McastService = McastServiceImpl.class$("org.apache.catalina.cluster.mcast.McastService")) : class$org$apache$catalina$cluster$mcast$McastService));
    protected boolean doRun = false;
    protected MulticastSocket socket;
    protected McastMember member;
    protected InetAddress address;
    protected int port;
    protected long timeToExpiration;
    protected long sendFrequency;
    protected DatagramPacket sendPacket;
    protected DatagramPacket receivePacket;
    protected McastMembership membership;
    protected MembershipListener service;
    protected ReceiverThread receiver;
    protected SenderThread sender;
    protected long serviceStartTime = System.currentTimeMillis();
    protected int mcastTTL = -1;
    protected int mcastSoTimeout = -1;
    protected InetAddress mcastBindAddress = null;
    static /* synthetic */ Class class$org$apache$catalina$cluster$mcast$McastService;

    public McastServiceImpl(McastMember member, long sendFrequency, long expireTime, int port, InetAddress bind, InetAddress mcastAddress, int ttl, int soTimeout, MembershipListener service) throws IOException {
        this.member = member;
        this.address = mcastAddress;
        this.port = port;
        this.mcastSoTimeout = soTimeout;
        this.mcastTTL = ttl;
        this.mcastBindAddress = bind;
        this.setupSocket();
        this.sendPacket = new DatagramPacket(new byte[1000], 1000);
        this.sendPacket.setAddress(this.address);
        this.sendPacket.setPort(port);
        this.receivePacket = new DatagramPacket(new byte[1000], 1000);
        this.receivePacket.setAddress(this.address);
        this.receivePacket.setPort(port);
        this.membership = new McastMembership(member.getName());
        this.timeToExpiration = expireTime;
        this.service = service;
        this.sendFrequency = sendFrequency;
    }

    protected void setupSocket() throws IOException {
        this.socket = this.mcastBindAddress != null ? new MulticastSocket(new InetSocketAddress(this.mcastBindAddress, this.port)) : new MulticastSocket(this.port);
        if (this.mcastBindAddress != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting multihome multicast interface to:" + this.mcastBindAddress));
            }
            this.socket.setInterface(this.mcastBindAddress);
        }
        if (this.mcastSoTimeout >= 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting cluster mcast soTimeout to " + this.mcastSoTimeout));
            }
            this.socket.setSoTimeout(this.mcastSoTimeout);
        }
        if (this.mcastTTL >= 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting cluster mcast TTL to " + this.mcastTTL));
            }
            this.socket.setTimeToLive(this.mcastTTL);
        }
    }

    public synchronized void start(int level) throws IOException {
        if (this.sender != null && this.receiver != null) {
            throw new IllegalStateException("Service already running.");
        }
        if (level == 1) {
            this.socket.joinGroup(this.address);
            this.doRun = true;
            this.receiver = new ReceiverThread();
            this.receiver.setDaemon(true);
            this.receiver.start();
        }
        if (level == 2) {
            this.serviceStartTime = System.currentTimeMillis();
            this.sender = new SenderThread(this.sendFrequency);
            this.sender.setDaemon(true);
            this.sender.start();
        }
    }

    public synchronized void stop() throws IOException {
        this.socket.leaveGroup(this.address);
        this.doRun = false;
        this.sender = null;
        this.receiver = null;
        this.serviceStartTime = Long.MAX_VALUE;
    }

    public void receive() throws IOException {
        this.socket.receive(this.receivePacket);
        byte[] data = new byte[this.receivePacket.getLength()];
        System.arraycopy(this.receivePacket.getData(), this.receivePacket.getOffset(), data, 0, data.length);
        McastMember m = McastMember.getMember(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mcast receive ping from member " + m));
        }
        if (this.membership.memberAlive(m)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mcast add member " + m));
            }
            this.service.memberAdded(m);
        }
        McastMember[] expired = this.membership.expire(this.timeToExpiration);
        for (int i = 0; i < expired.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mcast exipre  member " + m));
            }
            this.service.memberDisappeared(expired[i]);
        }
    }

    public void send() throws Exception {
        this.member.inc();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mcast send ping from member " + this.member));
        }
        byte[] data = this.member.getData(this.serviceStartTime);
        DatagramPacket p = new DatagramPacket(data, data.length);
        p.setAddress(this.address);
        p.setPort(this.port);
        this.socket.send(p);
    }

    public long getServiceStartTime() {
        return this.serviceStartTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SenderThread
    extends Thread {
        long time;

        public SenderThread(long time) {
            this.time = time;
            this.setName("Cluster-MembershipSender");
        }

        public void run() {
            while (McastServiceImpl.this.doRun) {
                try {
                    McastServiceImpl.this.send();
                }
                catch (Exception x) {
                    log.warn((Object)"Unable to send mcast message.", (Throwable)x);
                }
                try {
                    Thread.sleep(this.time);
                }
                catch (Exception exception) {}
            }
        }
    }

    public class ReceiverThread
    extends Thread {
        public ReceiverThread() {
            this.setName("Cluster-MembershipReceiver");
        }

        public void run() {
            while (McastServiceImpl.this.doRun) {
                try {
                    McastServiceImpl.this.receive();
                }
                catch (Exception x) {
                    log.warn((Object)"Error receiving mcast package. Sleeping 500ms", (Throwable)x);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

