/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.Constants;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class NioSender
extends AbstractSender
implements DataSender {
    protected static Log log = LogFactory.getLog(NioSender.class);
    protected Selector selector;
    protected SocketChannel socketChannel;
    protected ByteBuffer readbuf = null;
    protected ByteBuffer writebuf = null;
    protected byte[] current = null;
    protected XByteBuffer ackbuf = new XByteBuffer(128, true);
    protected int remaining = 0;
    protected boolean complete;
    protected boolean connecting = false;

    /*
     * Enabled aggressive block sorting
     */
    public boolean process(SelectionKey key, boolean waitForAck) throws IOException {
        int ops = key.readyOps();
        key.interestOps(key.interestOps() & ~ops);
        if (!this.isConnected() && !this.connecting) {
            throw new IOException("Sender has been disconnected, can't selection key.");
        }
        if (!key.isValid()) {
            throw new IOException("Key is not valid, it must have been cancelled.");
        }
        if (key.isConnectable()) {
            if (this.socketChannel.finishConnect()) {
                this.completeConnect();
                if (this.current == null) return false;
                key.interestOps(key.interestOps() | 4);
                return false;
            }
            key.interestOps(key.interestOps() | 8);
            return false;
        }
        if (key.isWritable()) {
            boolean writecomplete = this.write(key);
            if (!writecomplete) {
                key.interestOps(key.interestOps() | 4);
                return false;
            }
            if (waitForAck) {
                key.interestOps(key.interestOps() | 1);
                return false;
            }
            this.read(key);
            this.setRequestCount(this.getRequestCount() + 1);
            return true;
        }
        if (!key.isReadable()) {
            log.warn((Object)("Data is in unknown state. readyOps=" + ops));
            throw new IOException("Data is in unknown state. readyOps=" + ops);
        }
        boolean readcomplete = this.read(key);
        if (readcomplete) {
            this.setRequestCount(this.getRequestCount() + 1);
            return true;
        }
        key.interestOps(key.interestOps() | 1);
        return false;
    }

    private void completeConnect() throws SocketException {
        this.setConnected(true);
        this.connecting = false;
        this.setRequestCount(0);
        this.setConnectTime(System.currentTimeMillis());
        this.socketChannel.socket().setSendBufferSize(this.getTxBufSize());
        this.socketChannel.socket().setReceiveBufferSize(this.getRxBufSize());
        this.socketChannel.socket().setSoTimeout((int)this.getTimeout());
        this.socketChannel.socket().setSoLinger(this.getSoLingerOn(), this.getSoLingerOn() ? this.getSoLingerTime() : 0);
        this.socketChannel.socket().setTcpNoDelay(this.getTcpNoDelay());
        this.socketChannel.socket().setKeepAlive(this.getSoKeepAlive());
        this.socketChannel.socket().setReuseAddress(this.getSoReuseAddress());
        this.socketChannel.socket().setOOBInline(this.getOoBInline());
        this.socketChannel.socket().setSoLinger(this.getSoLingerOn(), this.getSoLingerTime());
        this.socketChannel.socket().setTrafficClass(this.getSoTrafficClass());
    }

    protected boolean read(SelectionKey key) throws IOException {
        if (this.current == null) {
            return true;
        }
        int read = this.socketChannel.read(this.readbuf);
        if (read == -1) {
            throw new IOException("Unable to receive an ack message. EOF on socket channel has been reached.");
        }
        if (read == 0) {
            return false;
        }
        this.readbuf.flip();
        this.ackbuf.append(this.readbuf, read);
        this.readbuf.clear();
        if (this.ackbuf.doesPackageExist()) {
            byte[] ackcmd = this.ackbuf.extractDataPackage(true).getBytes();
            boolean ack = Arrays.equals(ackcmd, Constants.ACK_DATA);
            boolean fack = Arrays.equals(ackcmd, Constants.FAIL_ACK_DATA);
            if (fack && this.getThrowOnFailedAck()) {
                throw new RemoteProcessException("Received a failed ack:org.apache.catalina.tribes.transport.Constants.FAIL_ACK_DATA");
            }
            return ack || fack;
        }
        return false;
    }

    protected boolean write(SelectionKey key) throws IOException {
        if (!this.isConnected() || this.socketChannel == null) {
            throw new IOException("NioSender is not connected, this should not occur.");
        }
        if (this.current != null) {
            if (this.remaining > 0) {
                int byteswritten = this.socketChannel.write(this.writebuf);
                if (byteswritten == -1) {
                    throw new EOFException();
                }
                this.remaining -= byteswritten;
                if (this.remaining < 0) {
                    this.remaining = 0;
                }
            }
            return this.remaining == 0;
        }
        return true;
    }

    public synchronized void connect() throws IOException {
        if (this.connecting) {
            return;
        }
        this.connecting = true;
        if (this.isConnected()) {
            throw new IOException("NioSender is already in connected state.");
        }
        if (this.readbuf == null) {
            this.readbuf = this.getReadBuffer();
        } else {
            this.readbuf.clear();
        }
        if (this.writebuf == null) {
            this.writebuf = this.getWriteBuffer();
        } else {
            this.writebuf.clear();
        }
        InetSocketAddress addr = new InetSocketAddress(this.getAddress(), this.getPort());
        if (this.socketChannel != null) {
            throw new IOException("Socket channel has already been established. Connection might be in progress.");
        }
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        if (this.socketChannel.connect(addr)) {
            this.completeConnect();
            this.socketChannel.register(this.getSelector(), 4, this);
        } else {
            this.socketChannel.register(this.getSelector(), 8, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        block12: {
            try {
                this.connecting = false;
                this.setConnected(false);
                if (this.socketChannel == null) break block12;
                try {
                    try {
                        this.socketChannel.socket().close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    try {
                        this.socketChannel.close();
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                finally {
                    this.socketChannel = null;
                }
            }
            catch (Exception x) {
                log.error((Object)("Unable to disconnect NioSender. msg=" + x.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unable to disconnect NioSender. msg=" + x.getMessage()), (Throwable)x);
                }
            }
        }
    }

    public void reset() {
        if (this.isConnected() && this.readbuf == null) {
            this.readbuf = this.getReadBuffer();
        }
        if (this.readbuf != null) {
            this.readbuf.clear();
        }
        if (this.writebuf != null) {
            this.writebuf.clear();
        }
        this.current = null;
        this.ackbuf.clear();
        this.remaining = 0;
        this.complete = false;
        this.setAttempt(0);
        this.setRequestCount(0);
        this.setConnectTime(-1L);
    }

    private ByteBuffer getReadBuffer() {
        return this.getBuffer(this.getRxBufSize());
    }

    private ByteBuffer getWriteBuffer() {
        return this.getBuffer(this.getTxBufSize());
    }

    private ByteBuffer getBuffer(int size) {
        return this.getDirectBuffer() ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    public synchronized void setMessage(byte[] data) throws IOException {
        this.setMessage(data, 0, data.length);
    }

    public synchronized void setMessage(byte[] data, int offset, int length) throws IOException {
        if (data != null) {
            this.current = data;
            this.remaining = length;
            this.ackbuf.clear();
            if (this.writebuf != null) {
                this.writebuf.clear();
            } else {
                this.writebuf = this.getBuffer(length);
            }
            if (this.writebuf.capacity() < length) {
                this.writebuf = this.getBuffer(length);
            }
            this.writebuf.put(data, offset, length);
            this.writebuf.flip();
            if (this.isConnected()) {
                this.socketChannel.register(this.getSelector(), 4, this);
            }
        }
    }

    public byte[] getMessage() {
        return this.current;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }
}

