/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.mail.CorrectedContentTypeDataSource;
import com.sk_jp.mail.CorrectedContentTypeDataSourceUTF7Support;
import com.sk_jp.mail.FirstPlainPartExtractor;
import com.sk_jp.mail.PartHandler;
import com.sk_jp.mail.PlainPartExtractor;
import java.io.IOException;
import javax.activation.DataHandler;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class MultipartUtility {
    private static CorrectedContentTypeDataSource correctedDataSource = new CorrectedContentTypeDataSourceUTF7Support();
    private static DataHandler correctedDataHandler = new DataHandler(correctedDataSource);

    public static Object getContent(Part part) throws MessagingException, IOException {
        return MultipartUtility.getContent(part, "ISO-2022-JP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getContent(Part part, String string) throws MessagingException, IOException {
        CorrectedContentTypeDataSource correctedContentTypeDataSource = correctedDataSource;
        synchronized (correctedContentTypeDataSource) {
            correctedDataSource.setPart(part);
            correctedDataSource.setDefaultCharset(string);
            return correctedDataHandler.getContent();
        }
    }

    public static String getFirstPlainText(Part part) throws MessagingException {
        FirstPlainPartExtractor firstPlainPartExtractor = new FirstPlainPartExtractor();
        MultipartUtility.process(part, firstPlainPartExtractor);
        return firstPlainPartExtractor.getText();
    }

    public static String getPlainText(Part part) throws MessagingException {
        PlainPartExtractor plainPartExtractor = new PlainPartExtractor();
        MultipartUtility.process(part, plainPartExtractor);
        return plainPartExtractor.getText();
    }

    public static void process(Part part, PartHandler partHandler) throws MessagingException {
        MultipartUtility.process(part, partHandler, null);
    }

    private static boolean process(Part part, PartHandler partHandler, ContentType contentType) throws MessagingException {
        try {
            if (part.isMimeType("multipart/*")) {
                Multipart multipart = (Multipart)part.getContent();
                ContentType contentType2 = new ContentType(part.getContentType());
                for (int i = 0; i < multipart.getCount(); ++i) {
                    if (MultipartUtility.process((Part)multipart.getBodyPart(i), partHandler, contentType2)) continue;
                    return false;
                }
                return true;
            }
            return partHandler.processPart(part, contentType);
        }
        catch (IOException iOException) {
            throw new MessagingException("Got exception \nin " + part + "\n", (Exception)iOException);
        }
    }

    public static void addBodyPart(Part part, MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            ((MimeMultipart)part.getContent()).addBodyPart((BodyPart)mimeBodyPart);
            return;
        }
        MimeMultipart mimeMultipart = new MimeMultipart("mixed");
        MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
        mimeBodyPart2.setContent(part.getContent(), part.getContentType());
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        part.setContent((Multipart)mimeMultipart);
    }

    public static void dump(Part part) {
        MultipartUtility.dump(part, 0);
    }

    private static void dump(Part part, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("    ");
        }
        try {
            System.out.println(part.getClass() + ":" + part.getContentType());
            if (part.isMimeType("multipart/*")) {
                MimeMultipart mimeMultipart = (MimeMultipart)part.getContent();
                for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                    MultipartUtility.dump((Part)mimeMultipart.getBodyPart(i), n + 1);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

