/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import org.apache.derby.client.am.Utils;

public class Types {
    public static final int SMALLINT = 5;
    public static final int INTEGER = 4;
    public static final int BIGINT = -5;
    public static final int REAL = 7;
    public static final int DOUBLE = 8;
    public static final int DECIMAL = 3;
    public static final int CHAR = 1;
    public static final int VARCHAR = 12;
    public static final int LONGVARCHAR = -1;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int BINARY = -2;
    public static final int VARBINARY = -3;
    public static final int LONGVARBINARY = -4;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int DERBY_SQLTYPE_DATE = 384;
    public static final int DERBY_SQLTYPE_NDATE = 385;
    public static final int DERBY_SQLTYPE_TIME = 388;
    public static final int DERBY_SQLTYPE_NTIME = 389;
    public static final int DERBY_SQLTYPE_TIMESTAMP = 392;
    public static final int DERBY_SQLTYPE_NTIMESTAMP = 393;
    public static final int DERBY_SQLTYPE_BLOB = 404;
    public static final int DERBY_SQLTYPE_NBLOB = 405;
    public static final int DERBY_SQLTYPE_CLOB = 408;
    public static final int DERBY_SQLTYPE_NCLOB = 409;
    public static final int DERBY_SQLTYPE_VARCHAR = 448;
    public static final int DERBY_SQLTYPE_NVARCHAR = 449;
    public static final int DERBY_SQLTYPE_CHAR = 452;
    public static final int DERBY_SQLTYPE_NCHAR = 453;
    public static final int DERBY_SQLTYPE_LONG = 456;
    public static final int DERBY_SQLTYPE_NLONG = 457;
    public static final int DERBY_SQLTYPE_CSTR = 460;
    public static final int DERBY_SQLTYPE_NCSTR = 461;
    public static final int DERBY_SQLTYPE_FLOAT = 480;
    public static final int DERBY_SQLTYPE_NFLOAT = 481;
    public static final int DERBY_SQLTYPE_DECIMAL = 484;
    public static final int DERBY_SQLTYPE_NDECIMAL = 485;
    public static final int DERBY_SQLTYPE_BIGINT = 492;
    public static final int DERBY_SQLTYPE_NBIGINT = 493;
    public static final int DERBY_SQLTYPE_INTEGER = 496;
    public static final int DERBY_SQLTYPE_NINTEGER = 497;
    public static final int DERBY_SQLTYPE_SMALL = 500;
    public static final int DERBY_SQLTYPE_NSMALL = 501;
    public static final int DERBY_SQLTYPE_NUMERIC = 504;
    public static final int DERBY_SQLTYPE_NNUMERIC = 505;

    private Types() {
    }

    public static int mapDERBYTypeToDriverType(boolean bl, int n, long l, int n2) {
        switch (Utils.getNonNullableSqlType(n)) {
            case 500: {
                return 5;
            }
            case 496: {
                return 4;
            }
            case 492: {
                return -5;
            }
            case 480: {
                if (l == 16L) {
                    return 3;
                }
                if (l == 8L) {
                    return 8;
                }
                if (l == 4L) {
                    return 7;
                }
                return 0;
            }
            case 484: 
            case 504: {
                return 3;
            }
            case 452: {
                if (bl && (n2 == 65535 || n2 == 0)) {
                    return -2;
                }
                return 1;
            }
            case 460: {
                return 1;
            }
            case 448: {
                if (bl && (n2 == 65535 || n2 == 0)) {
                    return -3;
                }
                return 12;
            }
            case 456: {
                if (bl && (n2 == 65535 || n2 == 0)) {
                    return -4;
                }
                return -1;
            }
            case 384: {
                return 91;
            }
            case 388: {
                return 92;
            }
            case 392: {
                return 93;
            }
            case 408: {
                return 2005;
            }
            case 404: {
                return 2004;
            }
        }
        return 0;
    }
}

