/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.method;

import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.intercept.AbstractSecurityInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MethodInvocationPrivilegeEvaluator
implements InitializingBean {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$intercept$method$MethodInvocationPrivilegeEvaluator == null ? (class$org$acegisecurity$intercept$method$MethodInvocationPrivilegeEvaluator = MethodInvocationPrivilegeEvaluator.class$("org.acegisecurity.intercept.method.MethodInvocationPrivilegeEvaluator")) : class$org$acegisecurity$intercept$method$MethodInvocationPrivilegeEvaluator));
    private AbstractSecurityInterceptor securityInterceptor;
    static /* synthetic */ Class class$org$acegisecurity$intercept$method$MethodInvocationPrivilegeEvaluator;
    static /* synthetic */ Class class$org$aopalliance$intercept$MethodInvocation;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.securityInterceptor, (String)"SecurityInterceptor required");
    }

    public boolean isAllowed(MethodInvocation mi, Authentication authentication) {
        Assert.notNull((Object)mi, (String)"MethodInvocation required");
        Assert.notNull((Object)mi.getMethod(), (String)"MethodInvocation must provide a non-null getMethod()");
        ConfigAttributeDefinition attrs = this.securityInterceptor.obtainObjectDefinitionSource().getAttributes(mi);
        if (attrs == null) {
            return !this.securityInterceptor.isRejectPublicInvocations();
        }
        if (authentication == null || authentication.getAuthorities() == null || authentication.getAuthorities().length == 0) {
            return false;
        }
        try {
            this.securityInterceptor.getAccessDecisionManager().decide(authentication, mi, attrs);
        }
        catch (AccessDeniedException unauthorized) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(mi.toString() + " denied for " + authentication.toString()), (Throwable)((Object)unauthorized));
            }
            return false;
        }
        return true;
    }

    public void setSecurityInterceptor(AbstractSecurityInterceptor securityInterceptor) {
        Assert.notNull((Object)securityInterceptor, (String)"AbstractSecurityInterceptor cannot be null");
        Assert.isTrue((boolean)(class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = MethodInvocationPrivilegeEvaluator.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation).equals(securityInterceptor.getSecureObjectClass()), (String)"AbstractSecurityInterceptor does not support MethodInvocations");
        Assert.notNull((Object)securityInterceptor.getAccessDecisionManager(), (String)"AbstractSecurityInterceptor must provide a non-null AccessDecisionManager");
        this.securityInterceptor = securityInterceptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

