/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import jp.nyx.loader.NyxBootLoader;

public class SecureSwitchUtility {
    private static final String NYX_LISENCE_CLASS_NAME = "jp.nyx.NyxLicense";
    private static PrintStream _out = System.out;
    private static PrintStream _err = System.err;
    private static BufferedReader _in = new BufferedReader(new InputStreamReader(System.in));
    private static boolean _allYesNo = false;
    private static boolean _useAll = false;

    public static void setErr(PrintStream err) {
        if (err == null) {
            throw new UnsupportedOperationException("Don't set null stream.");
        }
        _err = err;
    }

    public static void setOut(PrintStream out) {
        if (out == null) {
            throw new UnsupportedOperationException("Don't set null stream.");
        }
        _out = out;
    }

    public static String getInput() throws IOException {
        BufferedReader in = SecureSwitchUtility.getIn();
        String line = in.readLine();
        if (line == null) {
            return null;
        }
        return line.trim();
    }

    public static boolean getYesNo(String confirm, boolean useAll) throws IOException {
        if (_useAll) {
            return _allYesNo;
        }
        if (useAll) {
            _out.print(confirm + " ( yes / no / yesall / noall ) > ");
        } else {
            _out.print(confirm + " ( yes / no ) > ");
        }
        _useAll = useAll;
        String ki = SecureSwitchUtility.getInput();
        if (useAll) {
            if ("yesall".equals(ki)) {
                _allYesNo = true;
                return _allYesNo;
            }
            if ("noall".equals(ki)) {
                _allYesNo = false;
                return _allYesNo;
            }
        }
        _useAll = false;
        return "y".equals(ki) || "yes".equals(ki);
    }

    public static double loadCrtKernelVersion(NyxBootLoader loader) throws ClassNotFoundException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (loader == null) {
            return -1.0;
        }
        Class<?> lisenceClass = loader.loadClass(NYX_LISENCE_CLASS_NAME);
        Field value = lisenceClass.getField("KERNEL_VERSION_VALUE");
        return value.getDouble(null);
    }

    public static PrintStream getOut() {
        return _out;
    }

    public static PrintStream getErr() {
        return _err;
    }

    public static BufferedReader getIn() {
        return _in;
    }

    public static void setUseAll(boolean all) {
        _useAll = all;
    }
}

