/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.StringManager;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.ImmutableNameNotFoundException;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.naming.resources.ResourceCache;

public class ProxyDirContext
implements DirContext {
    public static final String CONTEXT = "context";
    public static final String HOST = "host";
    protected ProxyDirContext proxy = this;
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager("org.apache.naming.resources");
    protected DirContext dirContext;
    protected String vPath = null;
    protected String hostName;
    protected String contextName;
    protected String cacheClassName = "org.apache.naming.resources.ResourceCache";
    protected ResourceCache cache = null;
    protected int cacheTTL = 5000;
    protected int cacheObjectMaxSize = 512;
    protected NameNotFoundException notFoundException = new ImmutableNameNotFoundException();
    protected String[] nonCacheable = new String[]{"/WEB-INF/lib/", "/WEB-INF/classes/"};

    public ProxyDirContext(Hashtable env, DirContext dirContext) {
        BaseDirContext baseDirContext;
        this.env = env;
        this.dirContext = dirContext;
        if (dirContext instanceof BaseDirContext && (baseDirContext = (BaseDirContext)dirContext).isCached()) {
            try {
                this.cache = (ResourceCache)Class.forName(this.cacheClassName).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cache.setCacheMaxSize(baseDirContext.getCacheMaxSize());
            this.cacheTTL = baseDirContext.getCacheTTL();
            this.cacheObjectMaxSize = baseDirContext.getCacheMaxSize() / 20;
        }
        this.hostName = (String)env.get(HOST);
        this.contextName = (String)env.get(CONTEXT);
    }

    public ResourceCache getCache() {
        return this.cache;
    }

    public DirContext getDirContext() {
        return this.dirContext;
    }

    public String getDocBase() {
        if (this.dirContext instanceof BaseDirContext) {
            return ((BaseDirContext)this.dirContext).getDocBase();
        }
        return "";
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Object lookup(Name name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name.toString());
        if (entry != null) {
            if (!entry.exists) {
                throw this.notFoundException;
            }
            if (entry.resource != null) {
                return entry.resource;
            }
            return entry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(name));
        if (object instanceof InputStream) {
            return new Resource((InputStream)object);
        }
        return object;
    }

    public Object lookup(String name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name);
        if (entry != null) {
            if (!entry.exists) {
                throw this.notFoundException;
            }
            if (entry.resource != null) {
                return entry.resource;
            }
            return entry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(name));
        if (object instanceof InputStream) {
            return new Resource((InputStream)object);
        }
        if (object instanceof DirContext) {
            return object;
        }
        if (object instanceof Resource) {
            return object;
        }
        return new Resource(new ByteArrayInputStream(object.toString().getBytes()));
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj);
        this.cacheUnload(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj);
        this.cacheUnload(name);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj);
        this.cacheUnload(name.toString());
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj);
        this.cacheUnload(name);
    }

    public void unbind(Name name) throws NamingException {
        this.dirContext.unbind(this.parseName(name));
        this.cacheUnload(name.toString());
    }

    public void unbind(String name) throws NamingException {
        this.dirContext.unbind(this.parseName(name));
        this.cacheUnload(name);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.dirContext.rename(this.parseName(oldName), this.parseName(newName));
        this.cacheUnload(oldName.toString());
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.dirContext.rename(this.parseName(oldName), this.parseName(newName));
        this.cacheUnload(oldName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.dirContext.list(this.parseName(name));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.dirContext.list(this.parseName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.dirContext.listBindings(this.parseName(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.dirContext.listBindings(this.parseName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.dirContext.destroySubcontext(this.parseName(name));
        this.cacheUnload(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        this.dirContext.destroySubcontext(this.parseName(name));
        this.cacheUnload(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        Context context = this.dirContext.createSubcontext(this.parseName(name));
        this.cacheUnload(name.toString());
        return context;
    }

    public Context createSubcontext(String name) throws NamingException {
        Context context = this.dirContext.createSubcontext(this.parseName(name));
        this.cacheUnload(name);
        return context;
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.dirContext.lookupLink(this.parseName(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.dirContext.lookupLink(this.parseName(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.dirContext.getNameParser(this.parseName(name));
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.dirContext.getNameParser(this.parseName(name));
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)prefix.clone();
        return prefix.addAll(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.dirContext.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.dirContext.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.dirContext.getEnvironment();
    }

    public void close() throws NamingException {
        this.dirContext.close();
    }

    public String getNameInNamespace() throws NamingException {
        return this.dirContext.getNameInNamespace();
    }

    public Attributes getAttributes(Name name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name.toString());
        if (entry != null) {
            if (!entry.exists) {
                throw this.notFoundException;
            }
            return entry.attributes;
        }
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name));
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public Attributes getAttributes(String name) throws NamingException {
        CacheEntry entry = this.cacheLookup(name);
        if (entry != null) {
            if (!entry.exists) {
                throw this.notFoundException;
            }
            return entry.attributes;
        }
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name));
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name), attrIds);
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name), attrIds);
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), mod_op, attrs);
        this.cacheUnload(name.toString());
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), mod_op, attrs);
        this.cacheUnload(name);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), mods);
        this.cacheUnload(name.toString());
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), mods);
        this.cacheUnload(name);
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj, attrs);
        this.cacheUnload(name.toString());
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.bind(this.parseName(name), obj, attrs);
        this.cacheUnload(name);
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj, attrs);
        this.cacheUnload(name.toString());
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.dirContext.rebind(this.parseName(name), obj, attrs);
        this.cacheUnload(name);
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        DirContext context = this.dirContext.createSubcontext(this.parseName(name), attrs);
        this.cacheUnload(name.toString());
        return context;
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        DirContext context = this.dirContext.createSubcontext(this.parseName(name), attrs);
        this.cacheUnload(name);
        return context;
    }

    public DirContext getSchema(Name name) throws NamingException {
        return this.dirContext.getSchema(this.parseName(name));
    }

    public DirContext getSchema(String name) throws NamingException {
        return this.dirContext.getSchema(this.parseName(name));
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.parseName(name));
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.parseName(name));
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.dirContext.search(this.parseName(name), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.dirContext.search(this.parseName(name), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.dirContext.search(this.parseName(name), matchingAttributes);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return this.dirContext.search(this.parseName(name), matchingAttributes);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.parseName(name), filter, cons);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.parseName(name), filter, cons);
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.parseName(name), filterExpr, filterArgs, cons);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.dirContext.search(this.parseName(name), filterExpr, filterArgs, cons);
    }

    public CacheEntry lookupCache(String name) {
        CacheEntry entry = this.cacheLookup(name);
        if (entry == null) {
            entry = new CacheEntry();
            entry.name = name;
            try {
                Object object = this.dirContext.lookup(this.parseName(name));
                if (object instanceof InputStream) {
                    entry.resource = new Resource((InputStream)object);
                } else if (object instanceof DirContext) {
                    entry.context = (DirContext)object;
                } else {
                    entry.resource = object instanceof Resource ? (Resource)object : new Resource(new ByteArrayInputStream(object.toString().getBytes()));
                }
                Attributes attributes = this.dirContext.getAttributes(this.parseName(name));
                if (!(attributes instanceof ResourceAttributes)) {
                    attributes = new ResourceAttributes(attributes);
                }
                entry.attributes = (ResourceAttributes)attributes;
            }
            catch (NamingException e) {
                entry.exists = false;
            }
        }
        return entry;
    }

    protected String parseName(String name) throws NamingException {
        return name;
    }

    protected Name parseName(Name name) throws NamingException {
        return name;
    }

    protected CacheEntry cacheLookup(String name) {
        if (this.cache == null) {
            return null;
        }
        if (name == null) {
            name = "";
        }
        for (int i = 0; i < this.nonCacheable.length; ++i) {
            if (!name.startsWith(this.nonCacheable[i])) continue;
            return null;
        }
        CacheEntry cacheEntry = this.cache.lookup(name);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            cacheEntry.name = name;
            this.cacheLoad(cacheEntry);
        } else {
            if (!this.validate(cacheEntry)) {
                if (!this.revalidate(cacheEntry)) {
                    this.cacheUnload(cacheEntry.name);
                    return null;
                }
                cacheEntry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
            }
            ++cacheEntry.accessCount;
        }
        return cacheEntry;
    }

    protected boolean validate(CacheEntry entry) {
        return (!entry.exists || entry.context != null || entry.resource != null && entry.resource.getContent() != null) && System.currentTimeMillis() < entry.timestamp;
    }

    protected boolean revalidate(CacheEntry entry) {
        if (!entry.exists) {
            return false;
        }
        if (entry.attributes == null) {
            return false;
        }
        long lastModified = entry.attributes.getLastModified();
        long contentLength = entry.attributes.getContentLength();
        if (lastModified <= 0L) {
            return false;
        }
        try {
            Attributes tempAttributes = this.dirContext.getAttributes(entry.name);
            ResourceAttributes attributes = null;
            attributes = !(tempAttributes instanceof ResourceAttributes) ? new ResourceAttributes(tempAttributes) : (ResourceAttributes)tempAttributes;
            long lastModified2 = attributes.getLastModified();
            long contentLength2 = attributes.getContentLength();
            return lastModified == lastModified2 && contentLength == contentLength2;
        }
        catch (NamingException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheLoad(CacheEntry entry) {
        String name = entry.name;
        boolean exists = true;
        if (entry.attributes == null) {
            try {
                Attributes attributes = this.dirContext.getAttributes(entry.name);
                entry.attributes = !(attributes instanceof ResourceAttributes) ? new ResourceAttributes(attributes) : (ResourceAttributes)attributes;
            }
            catch (NamingException e) {
                exists = false;
            }
        }
        if (exists && entry.resource == null && entry.context == null) {
            try {
                Object object = this.dirContext.lookup(name);
                if (object instanceof InputStream) {
                    entry.resource = new Resource((InputStream)object);
                } else if (object instanceof DirContext) {
                    entry.context = (DirContext)object;
                } else {
                    entry.resource = object instanceof Resource ? (Resource)object : new Resource(new ByteArrayInputStream(object.toString().getBytes()));
                }
            }
            catch (NamingException e) {
                exists = false;
            }
        }
        if (exists && entry.resource != null && entry.resource.getContent() == null && entry.attributes.getContentLength() >= 0L && entry.attributes.getContentLength() < (long)(this.cacheObjectMaxSize * 1024)) {
            int length = (int)entry.attributes.getContentLength();
            entry.size = (int)((long)entry.size + entry.attributes.getContentLength() / 1024L);
            InputStream is = null;
            try {
                int n;
                is = entry.resource.streamContent();
                byte[] b = new byte[length];
                for (int pos = 0; pos < length && (n = is.read(b, pos, length - pos)) >= 0; pos += n) {
                }
                entry.resource.setContent(b);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        entry.exists = exists;
        entry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
        ResourceCache resourceCache = this.cache;
        synchronized (resourceCache) {
            if (this.cache.lookup(name) == null && this.cache.allocate(entry.size)) {
                this.cache.load(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cacheUnload(String name) {
        if (this.cache == null) {
            return false;
        }
        ResourceCache resourceCache = this.cache;
        synchronized (resourceCache) {
            return this.cache.unload(name);
        }
    }
}

