/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.deploy;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.ha.deploy.FileChangeListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class WarWatcher {
    public static Log log = LogFactory.getLog(WarWatcher.class);
    protected File watchDir = null;
    protected FileChangeListener listener = null;
    protected Map currentStatus = new HashMap();

    public WarWatcher() {
    }

    public WarWatcher(FileChangeListener listener, File watchDir) {
        this.listener = listener;
        this.watchDir = watchDir;
    }

    public void check() {
        File[] list;
        if (log.isInfoEnabled()) {
            log.info((Object)("check cluster wars at " + this.watchDir));
        }
        if ((list = this.watchDir.listFiles(new WarFilter())) == null) {
            list = new File[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            this.addWarInfo(list[i]);
        }
        for (Map.Entry entry : this.currentStatus.entrySet()) {
            WarInfo info = (WarInfo)entry.getValue();
            int check = info.check();
            if (check == 1) {
                this.listener.fileModified(info.getWar());
                continue;
            }
            if (check != -1) continue;
            this.listener.fileRemoved(info.getWar());
            this.currentStatus.remove(info.getWar());
        }
    }

    protected void addWarInfo(File warfile) {
        WarInfo info = (WarInfo)this.currentStatus.get(warfile.getAbsolutePath());
        if (info == null) {
            info = new WarInfo(warfile);
            info.setLastState(-1);
            this.currentStatus.put(warfile.getAbsolutePath(), info);
        }
    }

    public void clear() {
        this.currentStatus.clear();
    }

    public File getWatchDir() {
        return this.watchDir;
    }

    public void setWatchDir(File watchDir) {
        this.watchDir = watchDir;
    }

    public FileChangeListener getListener() {
        return this.listener;
    }

    public void setListener(FileChangeListener listener) {
        this.listener = listener;
    }

    protected class WarInfo {
        protected File war = null;
        protected long lastChecked = 0L;
        protected long lastState = 0L;

        public WarInfo(File war) {
            this.war = war;
            this.lastChecked = war.lastModified();
            if (!war.exists()) {
                this.lastState = -1L;
            }
        }

        public boolean modified() {
            return this.war.exists() && this.war.lastModified() > this.lastChecked;
        }

        public boolean exists() {
            return this.war.exists();
        }

        public int check() {
            int result = 0;
            if (this.modified()) {
                result = 1;
                this.lastState = result;
            } else if (!this.exists() && this.lastState != -1L) {
                result = -1;
                this.lastState = result;
            } else if (this.lastState == -1L && this.exists()) {
                result = 1;
                this.lastState = result;
            }
            this.lastChecked = System.currentTimeMillis();
            return result;
        }

        public File getWar() {
            return this.war;
        }

        public int hashCode() {
            return this.war.getAbsolutePath().hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof WarInfo) {
                WarInfo wo = (WarInfo)other;
                return wo.getWar().equals(this.getWar());
            }
            return false;
        }

        protected void setLastState(int lastState) {
            this.lastState = lastState;
        }
    }

    protected class WarFilter
    implements FilenameFilter {
        protected WarFilter() {
        }

        public boolean accept(File path, String name) {
            if (name == null) {
                return false;
            }
            return name.endsWith(".war");
        }
    }
}

