/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.mail.MultipartUtility;
import com.sk_jp.mail.PartHandler;
import java.io.IOException;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;

public class PlainPartExtractor
implements PartHandler {
    private String text = null;

    public boolean processPart(Part part, ContentType contentType) throws MessagingException, IOException {
        if (!part.isMimeType("text/plain")) {
            return true;
        }
        if (this.text == null) {
            this.text = (String)MultipartUtility.getContent(part);
        } else {
            String string = part.getDisposition();
            if (string == null || string.equalsIgnoreCase("inline")) {
                this.text = this.text + "\r\n\r\n-- inline --\r\n\r\n" + (String)MultipartUtility.getContent(part);
            }
        }
        return true;
    }

    public String getText() {
        return this.text;
    }

    public static void main(String[] stringArray) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null), System.in);
        PlainPartExtractor plainPartExtractor = new PlainPartExtractor();
        MultipartUtility.process((Part)mimeMessage, plainPartExtractor);
        System.out.println("This is the detected text/plain parts.");
        System.out.println(plainPartExtractor.getText());
    }
}

