/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import java.util.Date;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.server.ServerAssociationStore;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class JdbcServerAssociationStore
extends JdbcDaoSupport
implements ServerAssociationStore {
    private static Logger _log = Logger.getLogger((Class)JdbcServerAssociationStore.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static Random _random = new Random(System.currentTimeMillis());
    private String _tableName;

    public JdbcServerAssociationStore() {
    }

    public JdbcServerAssociationStore(String tableName) {
        this._tableName = tableName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public Association generate(String type, int expiryIn) throws AssociationException {
        String sql = "INSERT INTO " + this._tableName + " (handle, type, mackey, expdate) VALUES (?,?,?,?)";
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
        for (int attemptsLeft = 5; attemptsLeft > 0; --attemptsLeft) {
            try {
                String handle = Long.toHexString(_random.nextLong());
                Association association = Association.generate(type, handle, expiryIn);
                int cnt = jdbcTemplate.update(sql, new Object[]{association.getHandle(), association.getType(), new String(Base64.encodeBase64((byte[])association.getMacKey().getEncoded())), association.getExpiry()});
                if (cnt != 1) continue;
                if (DEBUG) {
                    _log.debug((Object)("Generated association, handle: " + handle + " type: " + type + " expires in: " + expiryIn + " seconds."));
                }
                return association;
            }
            catch (DataAccessException e) {
                _log.error((Object)("Error generating association; attempts left: " + (attemptsLeft - 1)), (Throwable)e);
            }
        }
        throw new AssociationException("JDBCServerAssociationStore: Error generating association.");
    }

    /*
     * WARNING - void declaration
     */
    public Association load(String handle) {
        try {
            void var8_11;
            Association assoc;
            String sql = "SELECT type,mackey,expdate FROM " + this._tableName + " WHERE handle=?";
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
            Map res = jdbcTemplate.queryForMap(sql, new Object[]{handle});
            String type = (String)res.get("type");
            String macKey = (String)res.get("mackey");
            Date expDate = (Date)res.get("expdate");
            if (type == null || macKey == null || expDate == null) {
                throw new AssociationException("Invalid association data retrived from database; cannot create Association object for handle: " + handle);
            }
            if ("HMAC-SHA1".equals(type)) {
                assoc = Association.createHmacSha1(handle, Base64.decodeBase64((byte[])macKey.getBytes()), expDate);
            } else if ("HMAC-SHA256".equals(type)) {
                assoc = Association.createHmacSha256(handle, Base64.decodeBase64((byte[])macKey.getBytes()), expDate);
            } else {
                throw new AssociationException("Invalid association type retrieved from database: " + type);
            }
            if (DEBUG) {
                _log.debug((Object)("Retrieved association from database, handle: " + handle));
            }
            return var8_11;
        }
        catch (AssociationException ase) {
            _log.error((Object)"Error rerieving association from database.", (Throwable)ase);
            return null;
        }
        catch (IncorrectResultSizeDataAccessException rse) {
            _log.warn((Object)("Association not found in the database for handle: " + handle));
            return null;
        }
        catch (DataAccessException dae) {
            _log.error((Object)("Error retrieving association from database, handle: " + handle), (Throwable)dae);
            return null;
        }
    }

    public void remove(String handle) {
        try {
            String sql = "DELETE FROM " + this._tableName + " WHERE handle=?";
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
            int cnt = jdbcTemplate.update(sql, new Object[]{handle});
            if (cnt == 1 && DEBUG) {
                _log.debug((Object)("Removed association, handle: " + handle));
            }
            if (cnt != 1) {
                _log.warn((Object)("Trying to remove handle: " + handle + " from database; affected entries: " + cnt));
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error removing association from database.", (Throwable)e);
        }
    }
}

