/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class MailAuth {
    public static final MailAuth INSTANCE = new MailAuth();
    public static final Command NULL_COMMAND = new Command(){

        public void execute(Object object) {
        }
    };
    private static final long CHECK_INTERVAL = 0x6DDD00L;
    private static final long ARRIVE_PERIOD = 86400000L;
    private File dir;
    private Thread sweeper;

    public void init(File file) {
        this.dir = file;
    }

    public void startSweeper() {
        this.startSweeper(0x6DDD00L, 86400000L);
    }

    public void startSweeper(long l, long l2) {
        if (this.dir == null) {
            throw new IllegalStateException();
        }
        this.sweeper = new Sweeper(this.dir, l, l2);
        this.sweeper.start();
    }

    public void stopSweeper() {
        this.sweeper.interrupt();
    }

    public String generateKey() throws IOException {
        return this.generateKey(NULL_COMMAND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateKey(Command command) throws IOException {
        String string = "";
        File file = File.createTempFile(string, "", this.dir);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            try {
                objectOutputStream.writeObject(command);
            }
            finally {
                objectOutputStream.close();
            }
            String string2 = file.getName();
            string2 = string2.substring(0, string2.lastIndexOf(46));
            return string2;
        }
        catch (IOException iOException) {
            file.delete();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command auth(String string) {
        Command command;
        File file = new File(this.dir, string);
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        try {
            command = (Command)objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                objectInputStream.close();
                file.delete();
                throw throwable;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InternalError();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        objectInputStream.close();
        file.delete();
        return command;
    }

    private MailAuth() {
    }

    static class Sweeper
    extends Thread {
        private File dir;
        private long checkInterval;
        private long arrivePeriod;

        public Sweeper(File file, long l, long l2) {
            this.dir = file;
            this.checkInterval = l;
            this.arrivePeriod = l2;
        }

        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Thread.sleep(this.checkInterval);
                    this.sweep();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void sweep() {
            long l = System.currentTimeMillis() - this.arrivePeriod;
            File[] fileArray = this.dir.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].lastModified() > l) continue;
                fileArray[i].delete();
            }
        }
    }

    public static interface Command
    extends Serializable {
        public void execute(Object var1) throws Exception;
    }
}

