/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NyxConfigure {
    private static Configure conf;

    private static void init() throws IOException {
        if (conf != null) {
            return;
        }
        conf = new Configure();
    }

    public static String getProperty(String key) throws IOException {
        NyxConfigure.init();
        return conf.configure.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) throws IOException {
        NyxConfigure.init();
        return conf.configure.getProperty(key, defaultValue);
    }

    public static Set<?> keySet() throws IOException {
        NyxConfigure.init();
        return conf.configure.keySet();
    }

    public static void store(OutputStream out, String comments) throws IOException {
        NyxConfigure.init();
        conf.configure.store(out, comments);
    }

    public static void store(Writer out, String comments) throws IOException {
        NyxConfigure.init();
        conf.configure.store(out, comments);
    }

    public static File getNyxHome() throws IOException {
        NyxConfigure.init();
        return conf.nyxHome;
    }

    public static File getNyxConf() throws IOException {
        NyxConfigure.init();
        return conf.nyxConf;
    }

    private static class Configure {
        private static final Pattern macro = Pattern.compile("\\$\\{([^\\}]+)\\}");
        private Properties configure = new Properties();
        private File nyxHome;
        private File nyxConf;

        private Configure() throws IOException {
            String nh = System.getProperty("nyx.home");
            if (nh == null) {
                throw new IOException("\"nyx.home\" JVM property is not set.");
            }
            this.nyxHome = new File(nh).getAbsoluteFile();
            this.nyxConf = new File(System.getProperty("nyx.conf", new File(this.nyxHome, "/conf/nyx.properties").getAbsolutePath()));
            Properties conf = new Properties();
            conf.load(new FileInputStream(this.nyxConf));
            conf.setProperty("nyx.home", this.nyxHome.getAbsolutePath().replace('\\', '/'));
            conf.setProperty("nyx.conf", this.nyxConf.getAbsolutePath().replace('\\', '/'));
            this.initEnveloment(conf);
        }

        private void initEnveloment(Properties conf) {
            String value;
            Matcher macroMt;
            boolean foundMacro = false;
            for (Object key : conf.keySet()) {
                if (!(key instanceof String) || !(macroMt = macro.matcher(value = conf.getProperty((String)key))).find()) continue;
                foundMacro = true;
                break;
            }
            if (!foundMacro) {
                return;
            }
            for (Object key : conf.keySet()) {
                String v;
                if (!(key instanceof String)) continue;
                value = conf.getProperty((String)key);
                macroMt = macro.matcher(value);
                if (macroMt.find() && (v = this.configure.getProperty(macroMt.group(1))) != null) {
                    v = v.replace("$", "\\$");
                    value = macroMt.replaceAll(v);
                }
                this.configure.put(key, value);
            }
            this.initEnveloment(this.configure);
        }
    }
}

