/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.apache.naming.resources.RecyclableNamingEnumeration;

public class ResourceAttributes
implements Attributes {
    public static final String CREATION_DATE = "creationdate";
    public static final String ALTERNATE_CREATION_DATE = "creation-date";
    public static final String LAST_MODIFIED = "getlastmodified";
    public static final String ALTERNATE_LAST_MODIFIED = "last-modified";
    public static final String NAME = "displayname";
    public static final String TYPE = "resourcetype";
    public static final String ALTERNATE_TYPE = "content-type";
    public static final String SOURCE = "source";
    public static final String CONTENT_TYPE = "getcontenttype";
    public static final String CONTENT_LANGUAGE = "getcontentlanguage";
    public static final String CONTENT_LENGTH = "getcontentlength";
    public static final String ALTERNATE_CONTENT_LENGTH = "content-length";
    public static final String ETAG = "getetag";
    public static final String COLLECTION_TYPE = "<collection/>";
    protected static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    protected boolean collection = false;
    protected long contentLength = -1L;
    protected long creation = -1L;
    protected Date creationDate = null;
    protected long lastModified = -1L;
    protected Date lastModifiedDate = null;
    protected String lastModifiedHttp = null;
    protected String mimeType = null;
    protected String name = null;
    protected String weakETag = null;
    protected String strongETag = null;
    protected Attributes attributes = null;

    public ResourceAttributes() {
    }

    public ResourceAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public boolean isCollection() {
        if (this.attributes != null) {
            return COLLECTION_TYPE.equals(this.getResourceType());
        }
        return this.collection;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
        if (this.attributes != null) {
            String value = "";
            if (collection) {
                value = COLLECTION_TYPE;
            }
            this.attributes.put(TYPE, value);
        }
    }

    public long getContentLength() {
        Attribute attribute;
        if (this.contentLength != -1L) {
            return this.contentLength;
        }
        if (this.attributes != null && (attribute = this.attributes.get(CONTENT_LENGTH)) != null) {
            try {
                Object value = attribute.get();
                if (value instanceof Long) {
                    this.contentLength = (Long)value;
                } else {
                    try {
                        this.contentLength = Long.parseLong(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
        if (this.attributes != null) {
            this.attributes.put(CONTENT_LENGTH, new Long(contentLength));
        }
    }

    public long getCreation() {
        Attribute attribute;
        if (this.creation != -1L) {
            return this.creation;
        }
        if (this.creationDate != null) {
            return this.creationDate.getTime();
        }
        if (this.attributes != null && (attribute = this.attributes.get(CREATION_DATE)) != null) {
            try {
                Object value = attribute.get();
                if (value instanceof Long) {
                    this.creation = (Long)value;
                } else if (value instanceof Date) {
                    this.creation = ((Date)value).getTime();
                    this.creationDate = (Date)value;
                } else {
                    String creationDateValue = value.toString();
                    Date result = null;
                    for (int i = 0; result == null && i < formats.length; ++i) {
                        try {
                            result = formats[i].parse(creationDateValue);
                            continue;
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    if (result != null) {
                        this.creation = result.getTime();
                        this.creationDate = result;
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.creation;
    }

    public void setCreation(long creation) {
        this.creation = creation;
        this.creationDate = null;
        if (this.attributes != null) {
            this.attributes.put(CREATION_DATE, new Date(creation));
        }
    }

    public Date getCreationDate() {
        Attribute attribute;
        if (this.creationDate != null) {
            return this.creationDate;
        }
        if (this.creation != -1L) {
            this.creationDate = new Date(this.creation);
            return this.creationDate;
        }
        if (this.attributes != null && (attribute = this.attributes.get(CREATION_DATE)) != null) {
            try {
                Object value = attribute.get();
                if (value instanceof Long) {
                    this.creation = (Long)value;
                    this.creationDate = new Date(this.creation);
                } else if (value instanceof Date) {
                    this.creation = ((Date)value).getTime();
                    this.creationDate = (Date)value;
                } else {
                    String creationDateValue = value.toString();
                    Date result = null;
                    for (int i = 0; result == null && i < formats.length; ++i) {
                        try {
                            result = formats[i].parse(creationDateValue);
                            continue;
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    if (result != null) {
                        this.creation = result.getTime();
                        this.creationDate = result;
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creation = creationDate.getTime();
        this.creationDate = creationDate;
        if (this.attributes != null) {
            this.attributes.put(CREATION_DATE, creationDate);
        }
    }

    public long getLastModified() {
        Attribute attribute;
        if (this.lastModified != -1L) {
            return this.lastModified;
        }
        if (this.lastModifiedDate != null) {
            return this.lastModifiedDate.getTime();
        }
        if (this.attributes != null && (attribute = this.attributes.get(LAST_MODIFIED)) != null) {
            try {
                Object value = attribute.get();
                if (value instanceof Long) {
                    this.lastModified = (Long)value;
                } else if (value instanceof Date) {
                    this.lastModified = ((Date)value).getTime();
                    this.lastModifiedDate = (Date)value;
                } else {
                    String lastModifiedDateValue = value.toString();
                    Date result = null;
                    for (int i = 0; result == null && i < formats.length; ++i) {
                        try {
                            result = formats[i].parse(lastModifiedDateValue);
                            continue;
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    if (result != null) {
                        this.lastModified = result.getTime();
                        this.lastModifiedDate = result;
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
        this.lastModifiedDate = null;
        if (this.attributes != null) {
            this.attributes.put(LAST_MODIFIED, new Date(lastModified));
        }
    }

    public void setLastModified(Date lastModified) {
        this.setLastModifiedDate(lastModified);
    }

    public Date getLastModifiedDate() {
        Attribute attribute;
        if (this.lastModifiedDate != null) {
            return this.lastModifiedDate;
        }
        if (this.lastModified != -1L) {
            this.lastModifiedDate = new Date(this.lastModified);
            return this.lastModifiedDate;
        }
        if (this.attributes != null && (attribute = this.attributes.get(LAST_MODIFIED)) != null) {
            try {
                Object value = attribute.get();
                if (value instanceof Long) {
                    this.lastModified = (Long)value;
                    this.lastModifiedDate = new Date(this.lastModified);
                } else if (value instanceof Date) {
                    this.lastModified = ((Date)value).getTime();
                    this.lastModifiedDate = (Date)value;
                } else {
                    String lastModifiedDateValue = value.toString();
                    Date result = null;
                    for (int i = 0; result == null && i < formats.length; ++i) {
                        try {
                            result = formats[i].parse(lastModifiedDateValue);
                            continue;
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    if (result != null) {
                        this.lastModified = result.getTime();
                        this.lastModifiedDate = result;
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModified = lastModifiedDate.getTime();
        this.lastModifiedDate = lastModifiedDate;
        if (this.attributes != null) {
            this.attributes.put(LAST_MODIFIED, lastModifiedDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastModifiedHttp() {
        if (this.lastModifiedHttp != null) {
            return this.lastModifiedHttp;
        }
        Date modifiedDate = this.getLastModifiedDate();
        if (modifiedDate == null) {
            modifiedDate = this.getCreationDate();
        }
        if (modifiedDate == null) {
            modifiedDate = new Date();
        }
        SimpleDateFormat simpleDateFormat = format;
        synchronized (simpleDateFormat) {
            this.lastModifiedHttp = format.format(modifiedDate);
        }
        return this.lastModifiedHttp;
    }

    public void setLastModifiedHttp(String lastModifiedHttp) {
        this.lastModifiedHttp = lastModifiedHttp;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getName() {
        Attribute attribute;
        if (this.name != null) {
            return this.name;
        }
        if (this.attributes != null && (attribute = this.attributes.get(NAME)) != null) {
            try {
                this.name = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.attributes != null) {
            this.attributes.put(NAME, name);
        }
    }

    public String getResourceType() {
        Attribute attribute;
        String result = null;
        if (this.attributes != null && (attribute = this.attributes.get(TYPE)) != null) {
            try {
                result = attribute.get().toString();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = this.collection ? COLLECTION_TYPE : null;
        }
        return result;
    }

    public void setResourceType(String resourceType) {
        this.collection = resourceType.equals(COLLECTION_TYPE);
        if (this.attributes != null) {
            this.attributes.put(TYPE, resourceType);
        }
    }

    public String getETag() {
        return this.getETag(false);
    }

    public String getETag(boolean strong) {
        Attribute attribute;
        String result = null;
        if (this.attributes != null && (attribute = this.attributes.get(ETAG)) != null) {
            try {
                result = attribute.get().toString();
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        if (strong) {
            result = this.strongETag;
        } else {
            if (this.weakETag == null) {
                this.weakETag = "W/\"" + this.getContentLength() + "-" + this.getLastModified() + "\"";
            }
            result = this.weakETag;
        }
        return result;
    }

    public void setETag(String eTag) {
        this.strongETag = eTag;
        if (this.attributes != null) {
            this.attributes.put(ETAG, eTag);
        }
    }

    public String getCanonicalPath() {
        return null;
    }

    public Attribute get(String attrID) {
        if (this.attributes == null) {
            if (attrID.equals(CREATION_DATE)) {
                Date creationDate = this.getCreationDate();
                if (creationDate == null) {
                    return null;
                }
                return new BasicAttribute(CREATION_DATE, creationDate);
            }
            if (attrID.equals(ALTERNATE_CREATION_DATE)) {
                Date creationDate = this.getCreationDate();
                if (creationDate == null) {
                    return null;
                }
                return new BasicAttribute(ALTERNATE_CREATION_DATE, creationDate);
            }
            if (attrID.equals(LAST_MODIFIED)) {
                Date lastModifiedDate = this.getLastModifiedDate();
                if (lastModifiedDate == null) {
                    return null;
                }
                return new BasicAttribute(LAST_MODIFIED, lastModifiedDate);
            }
            if (attrID.equals(ALTERNATE_LAST_MODIFIED)) {
                Date lastModifiedDate = this.getLastModifiedDate();
                if (lastModifiedDate == null) {
                    return null;
                }
                return new BasicAttribute(ALTERNATE_LAST_MODIFIED, lastModifiedDate);
            }
            if (attrID.equals(NAME)) {
                String name = this.getName();
                if (name == null) {
                    return null;
                }
                return new BasicAttribute(NAME, name);
            }
            if (attrID.equals(TYPE)) {
                String resourceType = this.getResourceType();
                if (resourceType == null) {
                    return null;
                }
                return new BasicAttribute(TYPE, resourceType);
            }
            if (attrID.equals(ALTERNATE_TYPE)) {
                String resourceType = this.getResourceType();
                if (resourceType == null) {
                    return null;
                }
                return new BasicAttribute(ALTERNATE_TYPE, resourceType);
            }
            if (attrID.equals(CONTENT_LENGTH)) {
                long contentLength = this.getContentLength();
                if (contentLength < 0L) {
                    return null;
                }
                return new BasicAttribute(CONTENT_LENGTH, new Long(contentLength));
            }
            if (attrID.equals(ALTERNATE_CONTENT_LENGTH)) {
                long contentLength = this.getContentLength();
                if (contentLength < 0L) {
                    return null;
                }
                return new BasicAttribute(ALTERNATE_CONTENT_LENGTH, new Long(contentLength));
            }
        } else {
            return this.attributes.get(attrID);
        }
        return null;
    }

    public Attribute put(Attribute attribute) {
        if (this.attributes == null) {
            try {
                return this.put(attribute.getID(), attribute.get());
            }
            catch (NamingException e) {
                return null;
            }
        }
        return this.attributes.put(attribute);
    }

    public Attribute put(String attrID, Object val) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.put(attrID, val);
    }

    public Attribute remove(String attrID) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(attrID);
    }

    public NamingEnumeration getAll() {
        if (this.attributes == null) {
            long contentLength;
            String resourceType;
            String name;
            Date lastModifiedDate;
            Vector<BasicAttribute> attributes = new Vector<BasicAttribute>();
            Date creationDate = this.getCreationDate();
            if (creationDate != null) {
                attributes.addElement(new BasicAttribute(CREATION_DATE, creationDate));
                attributes.addElement(new BasicAttribute(ALTERNATE_CREATION_DATE, creationDate));
            }
            if ((lastModifiedDate = this.getLastModifiedDate()) != null) {
                attributes.addElement(new BasicAttribute(LAST_MODIFIED, lastModifiedDate));
                attributes.addElement(new BasicAttribute(ALTERNATE_LAST_MODIFIED, lastModifiedDate));
            }
            if ((name = this.getName()) != null) {
                attributes.addElement(new BasicAttribute(NAME, name));
            }
            if ((resourceType = this.getResourceType()) != null) {
                attributes.addElement(new BasicAttribute(TYPE, resourceType));
                attributes.addElement(new BasicAttribute(ALTERNATE_TYPE, resourceType));
            }
            if ((contentLength = this.getContentLength()) >= 0L) {
                Long contentLengthLong = new Long(contentLength);
                attributes.addElement(new BasicAttribute(CONTENT_LENGTH, contentLengthLong));
                attributes.addElement(new BasicAttribute(ALTERNATE_CONTENT_LENGTH, contentLengthLong));
            }
            return new RecyclableNamingEnumeration(attributes);
        }
        return this.attributes.getAll();
    }

    public NamingEnumeration getIDs() {
        if (this.attributes == null) {
            long contentLength;
            String resourceType;
            Date lastModifiedDate;
            Vector<String> attributeIDs = new Vector<String>();
            Date creationDate = this.getCreationDate();
            if (creationDate != null) {
                attributeIDs.addElement(CREATION_DATE);
                attributeIDs.addElement(ALTERNATE_CREATION_DATE);
            }
            if ((lastModifiedDate = this.getLastModifiedDate()) != null) {
                attributeIDs.addElement(LAST_MODIFIED);
                attributeIDs.addElement(ALTERNATE_LAST_MODIFIED);
            }
            if (this.getName() != null) {
                attributeIDs.addElement(NAME);
            }
            if ((resourceType = this.getResourceType()) != null) {
                attributeIDs.addElement(TYPE);
                attributeIDs.addElement(ALTERNATE_TYPE);
            }
            if ((contentLength = this.getContentLength()) >= 0L) {
                attributeIDs.addElement(CONTENT_LENGTH);
                attributeIDs.addElement(ALTERNATE_CONTENT_LENGTH);
            }
            return new RecyclableNamingEnumeration(attributeIDs);
        }
        return this.attributes.getIDs();
    }

    public int size() {
        if (this.attributes == null) {
            int size = 0;
            if (this.getCreationDate() != null) {
                size += 2;
            }
            if (this.getLastModifiedDate() != null) {
                size += 2;
            }
            if (this.getName() != null) {
                ++size;
            }
            if (this.getResourceType() != null) {
                size += 2;
            }
            if (this.getContentLength() >= 0L) {
                size += 2;
            }
            return size;
        }
        return this.attributes.size();
    }

    public Object clone() {
        return this;
    }

    public boolean isCaseIgnored() {
        return false;
    }

    static {
        format.setTimeZone(gmtZone);
        formats[0].setTimeZone(gmtZone);
        formats[1].setTimeZone(gmtZone);
        formats[2].setTimeZone(gmtZone);
    }
}

