/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.jdbc.EmbeddedSimpleDataSource;

public class SignatureChecker {
    private static final String WILDCARD = "%";
    private static final String[] SYSTEM_SCHEMAS = new String[]{"SQLJ", "SYSCS_UTIL", "SYSIBM"};
    private ParsedArgs _parsedArgs;
    private ArrayList _procedures = new ArrayList();
    private ArrayList _functions = new ArrayList();
    private boolean _debugging = false;
    private static LocalizedResource _messageFormatter;

    private SignatureChecker(ParsedArgs parsedArgs) {
        this._parsedArgs = parsedArgs;
    }

    public static void main(String[] stringArray) {
        ParsedArgs parsedArgs = new ParsedArgs(stringArray);
        if (!parsedArgs.isValid()) {
            SignatureChecker.printUsage();
            System.exit(1);
        } else {
            SignatureChecker signatureChecker = new SignatureChecker(parsedArgs);
            signatureChecker.execute();
        }
    }

    private void execute() {
        try {
            Connection connection = this._parsedArgs.isJ2ME() ? this.getJ2MEConnection() : this.getJ2SEConnection();
            if (connection == null) {
                SignatureChecker.println(SignatureChecker.formatMessage("SC_NO_CONN"));
                return;
            }
            this.matchSignatures(connection);
            connection.close();
        }
        catch (Throwable throwable) {
            SignatureChecker.printThrowable(throwable);
        }
    }

    private void matchSignatures(Connection connection) throws SQLException {
        this.matchProcedures(connection);
        this.matchFunctions(connection);
    }

    private void matchProcedures(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.findProcedures(databaseMetaData);
        this.countProcedureArgs(databaseMetaData);
        int n = this._procedures.size();
        for (int i = 0; i < n; ++i) {
            SQLRoutine sQLRoutine = this.getProcedure(i);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = sQLRoutine.getArgCount();
            stringBuffer.append("call ");
            stringBuffer.append(sQLRoutine.getQualifiedName());
            stringBuffer.append("( ");
            for (int j = 0; j < n2; ++j) {
                if (j > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(" ? ");
            }
            stringBuffer.append(" )");
            this.checkSignature(connection, sQLRoutine, stringBuffer.toString(), this.makeReadableSignature(sQLRoutine));
        }
    }

    private void matchFunctions(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.findFunctions(databaseMetaData);
        this.countFunctionArgs(databaseMetaData);
        int n = this._functions.size();
        for (int i = 0; i < n; ++i) {
            SQLRoutine sQLRoutine = this.getFunction(i);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = sQLRoutine.getArgCount();
            if (sQLRoutine.isTableFunction()) {
                stringBuffer.append("select * from table( ");
            } else {
                stringBuffer.append("values(  ");
            }
            stringBuffer.append(sQLRoutine.getQualifiedName());
            stringBuffer.append("( ");
            for (int j = 0; j < n2; ++j) {
                if (j > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(" ? ");
            }
            stringBuffer.append(" ) )");
            if (sQLRoutine.isTableFunction()) {
                stringBuffer.append(" s");
            }
            this.checkSignature(connection, sQLRoutine, stringBuffer.toString(), this.makeReadableSignature(sQLRoutine));
        }
    }

    private String makeReadableSignature(SQLRoutine sQLRoutine) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = sQLRoutine.getArgCount();
        stringBuffer.append(sQLRoutine.getQualifiedName());
        stringBuffer.append("( ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(" " + sQLRoutine.getArgType(i) + " ");
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    private void findProcedures(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getProcedures(null, null, WILDCARD);
        while (resultSet.next()) {
            String string = resultSet.getString(2);
            String string2 = resultSet.getString(3);
            if (this.isSystemSchema(string)) continue;
            this.putProcedure(string, string2);
        }
        resultSet.close();
    }

    private void countProcedureArgs(DatabaseMetaData databaseMetaData) throws SQLException {
        int n = this._procedures.size();
        for (int i = 0; i < n; ++i) {
            SQLRoutine sQLRoutine = this.getProcedure(i);
            ResultSet resultSet = databaseMetaData.getProcedureColumns(null, sQLRoutine.getSchema(), sQLRoutine.getName(), WILDCARD);
            while (resultSet.next()) {
                sQLRoutine.addArg(resultSet.getString(7));
            }
            resultSet.close();
        }
    }

    private void findFunctions(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            Method method = databaseMetaData.getClass().getMethod("getFunctions", String.class, String.class, String.class);
            ResultSet resultSet = (ResultSet)method.invoke((Object)databaseMetaData, null, null, WILDCARD);
            while (resultSet.next()) {
                String string = resultSet.getString(2);
                String string2 = resultSet.getString(3);
                short s = resultSet.getShort(5);
                if (this.isSystemSchema(string)) continue;
                boolean bl = s == 2;
                this.putFunction(string, string2, bl);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    private void countFunctionArgs(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            Method method = databaseMetaData.getClass().getMethod("getFunctionColumns", String.class, String.class, String.class, String.class);
            int n = this._functions.size();
            for (int i = 0; i < n; ++i) {
                SQLRoutine sQLRoutine = this.getFunction(i);
                ResultSet resultSet = (ResultSet)method.invoke((Object)databaseMetaData, null, sQLRoutine.getSchema(), sQLRoutine.getName(), WILDCARD);
                while (resultSet.next()) {
                    short s = resultSet.getShort(5);
                    if (s == 4 || s == 5) continue;
                    sQLRoutine.addArg(resultSet.getString(7));
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    private void checkSignature(Connection connection, SQLRoutine sQLRoutine, String string, String string2) {
        try {
            PreparedStatement preparedStatement = this.prepareStatement(connection, string);
            preparedStatement.close();
            SignatureChecker.println(SignatureChecker.formatMessage("SC_FOUND_MATCH", string2));
        }
        catch (SQLException sQLException) {
            SignatureChecker.println(SignatureChecker.formatMessage("SC_UNRESOLVABLE", string2, sQLException.getMessage()));
        }
    }

    private Connection getJ2MEConnection() throws SQLException {
        EmbeddedSimpleDataSource embeddedSimpleDataSource = new EmbeddedSimpleDataSource();
        embeddedSimpleDataSource.setDatabaseName(this._parsedArgs.getJ2meDatabaseName());
        return embeddedSimpleDataSource.getConnection();
    }

    private Connection getJ2SEConnection() throws SQLException {
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            Class.forName("org.apache.derby.jdbc.ClientDriver");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class<?> clazz = Class.forName("java.sql.DriverManager");
            Method method = clazz.getDeclaredMethod("getConnection", String.class);
            return (Connection)method.invoke(null, this._parsedArgs.getJ2seConnectionUrl());
        }
        catch (Throwable throwable) {
            SignatureChecker.printThrowable(throwable);
            return null;
        }
    }

    private PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        if (this._debugging) {
            SignatureChecker.println("Preparing: " + string);
        }
        return connection.prepareStatement(string);
    }

    private static void printUsage() {
        SignatureChecker.println(SignatureChecker.formatMessage("SC_USAGE"));
    }

    private static void printThrowable(Throwable throwable) {
        throwable.printStackTrace();
    }

    private static void println(String string) {
        System.out.println(string);
    }

    private boolean isSystemSchema(String string) {
        int n = SYSTEM_SCHEMAS.length;
        for (int i = 0; i < n; ++i) {
            if (!SYSTEM_SCHEMAS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private void putProcedure(String string, String string2) {
        this._procedures.add(new SQLRoutine(string, string2, false));
    }

    private SQLRoutine getProcedure(int n) {
        return (SQLRoutine)this._procedures.get(n);
    }

    private void putFunction(String string, String string2, boolean bl) {
        this._functions.add(new SQLRoutine(string, string2, bl));
    }

    private SQLRoutine getFunction(int n) {
        return (SQLRoutine)this._functions.get(n);
    }

    private static String formatMessage(String string) {
        return SignatureChecker.getMessageFormatter().getTextMessage(string);
    }

    private static String formatMessage(String string, String string2) {
        return SignatureChecker.getMessageFormatter().getTextMessage(string, string2);
    }

    private static String formatMessage(String string, String string2, String string3) {
        return SignatureChecker.getMessageFormatter().getTextMessage(string, string2, string3);
    }

    private static LocalizedResource getMessageFormatter() {
        if (_messageFormatter == null) {
            _messageFormatter = LocalizedResource.getInstance();
        }
        return _messageFormatter;
    }

    class SQLRoutine {
        private String _schema;
        private String _name;
        private boolean _isTableFunction;
        private ArrayList _argList = new ArrayList();

        public SQLRoutine(String string, String string2, boolean bl) {
            this._schema = string;
            this._name = string2;
            this._isTableFunction = bl;
        }

        public void addArg(String string) {
            this._argList.add(string);
        }

        public String getSchema() {
            return this._schema;
        }

        public String getName() {
            return this._name;
        }

        public int getArgCount() {
            return this._argList.size();
        }

        public String getArgType(int n) {
            return (String)this._argList.get(n);
        }

        public boolean isTableFunction() {
            return this._isTableFunction;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SQLRoutine( ");
            stringBuffer.append(this._schema + ", ");
            stringBuffer.append(this._name + ", ");
            stringBuffer.append("isTableFunction = " + this._isTableFunction + ", ");
            stringBuffer.append(" argCount = " + this.getArgCount());
            stringBuffer.append(" )");
            return stringBuffer.toString();
        }

        private String doubleQuote(String string) {
            return '\"' + string + '\"';
        }

        public String getQualifiedName() {
            return this.doubleQuote(this._schema) + '.' + this.doubleQuote(this._name);
        }
    }

    static class ParsedArgs {
        private boolean _isValid = false;
        private boolean _isJ2ME = !this.classExists("java.sql.DriverManager");
        private String _j2seConnectionUrl;
        private String _j2meDatabaseName;

        public ParsedArgs(String[] stringArray) {
            this.parseArgs(stringArray);
        }

        public boolean isValid() {
            return this._isValid;
        }

        public boolean isJ2ME() {
            return this._isJ2ME;
        }

        public String getJ2seConnectionUrl() {
            return this._j2seConnectionUrl;
        }

        public String getJ2meDatabaseName() {
            return this._j2meDatabaseName;
        }

        private void parseArgs(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            if (stringArray.length == 0) {
                return;
            }
            if (this.isJ2ME()) {
                if (stringArray.length != 1) {
                    return;
                }
                this._j2meDatabaseName = stringArray[0];
                this._isValid = true;
            } else {
                if (stringArray.length != 1) {
                    return;
                }
                this._j2seConnectionUrl = stringArray[0];
                this._isValid = true;
            }
        }

        private boolean classExists(String string) {
            try {
                Class.forName(string);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }
}

