/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.text;

public class IndentedStringFormat {
    private int column;
    private boolean alignmentIsRight;

    public IndentedStringFormat(int n) {
        this(n, false);
    }

    public IndentedStringFormat(int n, boolean bl) {
        this.column = n;
        this.alignmentIsRight = bl;
    }

    public String format(String string) {
        int n = string.length();
        if (n > this.column) {
            return string.substring(0, this.column);
        }
        if (this.alignmentIsRight) {
            return IndentedStringFormat.fillSpace(this.column - n) + string;
        }
        return string + IndentedStringFormat.fillSpace(this.column - n);
    }

    public static String fillSpace(int n) {
        if (n < 1) {
            return "";
        }
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray);
    }
}

