/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.loader;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import jp.nyx.SecureSwitchUtility;

public class NyxBootLoader {
    private URLClassLoader loader;
    private URL[] urls;
    private FileFilter jarFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (pathname == null || !pathname.canRead()) {
                return false;
            }
            return pathname.getName().endsWith(".jar");
        }
    };

    public NyxBootLoader(File[] libs) {
        this.urls = this.toURL(libs);
        this.loader = new URLClassLoader(this.urls);
    }

    public NyxBootLoader(File[] libs, ClassLoader parent) {
        this.urls = this.toURL(libs);
        this.loader = new URLClassLoader(this.urls, parent);
    }

    public NyxBootLoader(File[] libs, ClassLoader parent, URLStreamHandlerFactory factory) {
        this.urls = this.toURL(libs);
        this.loader = new URLClassLoader(this.urls, parent, factory);
    }

    public NyxBootLoader(File[] files, File[] dirs) {
        this.urls = this.toURL(files, dirs);
        this.loader = new URLClassLoader(this.urls);
    }

    public NyxBootLoader(File[] files, File[] dirs, ClassLoader parent) {
        this.urls = this.toURL(files, dirs);
        this.loader = new URLClassLoader(this.urls, parent);
    }

    public NyxBootLoader(File[] files, File[] dirs, ClassLoader parent, URLStreamHandlerFactory factory) {
        this.urls = this.toURL(files, dirs);
        this.loader = new URLClassLoader(this.urls, parent, factory);
    }

    public NyxBootLoader(URL[] urls) {
        this.urls = urls;
        this.loader = new URLClassLoader(urls);
    }

    public NyxBootLoader(URL[] urls, ClassLoader parent) {
        this.urls = urls;
        this.loader = new URLClassLoader(urls, parent);
    }

    public NyxBootLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this.urls = urls;
        this.loader = new URLClassLoader(urls, parent, factory);
    }

    private URL[] toURL(File[] libs, File[] dirs) {
        HashSet<URL> u = new HashSet<URL>();
        for (File f : libs) {
            this.toURL(f, u);
        }
        for (File f : dirs) {
            try {
                u.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                SecureSwitchUtility.getErr().println("Illegal Dir '" + f.toString() + "'");
            }
            this.toURL(f, u);
        }
        return u.toArray(new URL[0]);
    }

    private URL[] toURL(File[] libs) {
        HashSet<URL> u = new HashSet<URL>();
        for (File f : libs) {
            this.toURL(f, u);
        }
        return u.toArray(new URL[0]);
    }

    private void toURL(File lib, Set<URL> urlSet) {
        if (lib == null) {
            return;
        }
        if (!lib.canRead()) {
            SecureSwitchUtility.getErr().println("Can't read '" + lib.toString() + "'");
            return;
        }
        if (lib.isFile()) {
            try {
                urlSet.add(lib.toURI().toURL());
            }
            catch (MalformedURLException e) {
                SecureSwitchUtility.getErr().println("Illegal File '" + lib.toString() + "'");
            }
            return;
        }
        if (!lib.isDirectory()) {
            return;
        }
        for (File f : lib.listFiles(this.jarFileFilter)) {
            this.toURL(f, urlSet);
        }
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    public URL findResource(String name) {
        return this.loader.findResource(name);
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        return this.loader.findResources(name);
    }

    public URL[] getUrls() {
        return this.urls;
    }
}

