/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.server.ServerAssociationStore;

public class InMemoryServerAssociationStore
implements ServerAssociationStore {
    private static Logger _log = Logger.getLogger((Class)InMemoryServerAssociationStore.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private String _timestamp = Long.toString(new Date().getTime());
    private int _counter = 0;
    private Map _handleMap = new HashMap();

    public synchronized Association generate(String type, int expiryIn) throws AssociationException {
        this.removeExpired();
        String handle = this._timestamp + "-" + this._counter++;
        Association association = Association.generate(type, handle, expiryIn);
        this._handleMap.put(handle, association);
        if (DEBUG) {
            _log.debug((Object)("Generated association, handle: " + handle + " type: " + type + " expires in: " + expiryIn + " seconds."));
        }
        return association;
    }

    public synchronized Association load(String handle) {
        this.removeExpired();
        return (Association)this._handleMap.get(handle);
    }

    public synchronized void remove(String handle) {
        if (DEBUG) {
            _log.debug((Object)("Removing association, handle: " + handle));
        }
        this._handleMap.remove(handle);
        this.removeExpired();
    }

    private synchronized void removeExpired() {
        String handle;
        HashSet<String> handleToRemove = new HashSet<String>();
        Iterator<Object> handles = this._handleMap.keySet().iterator();
        while (handles.hasNext()) {
            handle = (String)handles.next();
            Association association = (Association)this._handleMap.get(handle);
            if (!association.hasExpired()) continue;
            handleToRemove.add(handle);
        }
        handles = handleToRemove.iterator();
        while (handles.hasNext()) {
            handle = (String)handles.next();
            if (DEBUG) {
                _log.debug((Object)("Removing expired association, handle: " + handle));
            }
            this._handleMap.remove(handle);
        }
    }

    protected synchronized int size() {
        return this._handleMap.size();
    }
}

