/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.SignerId;

public class SignerInformation {
    private SignerId sid;
    private SignerInfo info;
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier encryptionAlgorithm;
    private ASN1Set signedAttributes;
    private ASN1Set unsignedAttributes;
    private CMSProcessable content;
    private byte[] signature;
    private DERObjectIdentifier contentType;
    private byte[] _digest;
    private byte[] _resultDigest;

    SignerInformation(SignerInfo signerInfo, DERObjectIdentifier dERObjectIdentifier, CMSProcessable cMSProcessable, byte[] byArray) {
        this.info = signerInfo;
        this.sid = new SignerId();
        this.contentType = dERObjectIdentifier;
        try {
            SignerIdentifier signerIdentifier = signerInfo.getSID();
            if (signerIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)signerIdentifier.getId());
                this.sid.setSubjectKeyIdentifier(aSN1OctetString.getOctets());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)signerIdentifier.getId());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                aSN1OutputStream.writeObject((Object)issuerAndSerialNumber.getName());
                this.sid.setIssuer(byteArrayOutputStream.toByteArray());
                this.sid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid sid in SignerInfo");
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm();
        this.signedAttributes = signerInfo.getAuthenticatedAttributes();
        this.unsignedAttributes = signerInfo.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        this.signature = signerInfo.getEncryptedDigest().getOctets();
        this.content = cMSProcessable;
        this._digest = byArray;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((Object)dEREncodable);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public SignerId getSID() {
        return this.sid;
    }

    public int getVersion() {
        return this.info.getVersion().getValue().intValue();
    }

    public String getDigestAlgOID() {
        return this.digestAlgorithm.getObjectId().getId();
    }

    public byte[] getDigestAlgParams() {
        try {
            return this.encodeObj(this.digestAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting digest parameters " + exception);
        }
    }

    public byte[] getContentDigest() {
        if (this._resultDigest == null) {
            throw new IllegalStateException("method can only be called after verify.");
        }
        return (byte[])this._resultDigest.clone();
    }

    public String getEncryptionAlgOID() {
        return this.encryptionAlgorithm.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encryptionAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AttributeTable getSignedAttributes() {
        if (this.signedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.signedAttributes);
    }

    public AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unsignedAttributes);
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public byte[] getEncodedSignedAttributes() throws IOException {
        if (this.signedAttributes != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)byteArrayOutputStream);
            dEROutputStream.writeObject((Object)this.signedAttributes);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doVerify(PublicKey publicKey, AttributeTable attributeTable, String string) throws CMSException, NoSuchAlgorithmException, NoSuchProviderException {
        String string2 = CMSSignedHelper.INSTANCE.getDigestAlgName(this.getDigestAlgOID());
        String string3 = string2 + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string3, string);
        MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string2, string);
        try {
            DERObjectIdentifier dERObjectIdentifier;
            byte[] byArray;
            signature.initVerify(publicKey);
            if (this.signedAttributes == null) {
                if (this.content != null) {
                    this.content.write(new CMSSignedDataGenerator.SigOutputStream(signature));
                    this.content.write(new CMSSignedDataGenerator.DigOutputStream(messageDigest));
                    this._resultDigest = messageDigest.digest();
                    return signature.verify(this.getSignature());
                }
                this._resultDigest = this._digest;
                return this.verifyDigest(this._digest, publicKey, this.getSignature(), string);
            }
            if (this.content != null) {
                this.content.write(new CMSSignedDataGenerator.DigOutputStream(messageDigest));
                byArray = messageDigest.digest();
            } else {
                byArray = this._digest;
            }
            this._resultDigest = byArray;
            Attribute attribute = attributeTable.get(CMSAttributes.messageDigest);
            Attribute attribute2 = attributeTable.get(CMSAttributes.contentType);
            if (attribute == null) {
                throw new SignatureException("no hash for content found in signed attributes");
            }
            if (attribute2 == null) {
                throw new SignatureException("no content type id found in signed attributes");
            }
            DERObject dERObject = attribute.getAttrValues().getObjectAt(0).getDERObject();
            if (dERObject instanceof ASN1OctetString) {
                byte[] byArray2 = ((ASN1OctetString)dERObject).getOctets();
                if (!MessageDigest.isEqual(byArray, byArray2)) {
                    throw new SignatureException("content hash found in signed attributes different");
                }
            } else if (dERObject instanceof DERNull && byArray != null) {
                throw new SignatureException("NULL hash found in signed attributes when one expected");
            }
            if (!(dERObjectIdentifier = (DERObjectIdentifier)attribute2.getAttrValues().getObjectAt(0)).equals((Object)this.contentType)) {
                throw new SignatureException("contentType in signed attributes different");
            }
            signature.update(this.getEncodedSignedAttributes());
            return signature.verify(this.getSignature());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key not appropriate to signature in message.", invalidKeyException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        catch (SignatureException signatureException) {
            throw new CMSException("invalid signature format in message: " + signatureException.getMessage(), signatureException);
        }
    }

    private boolean isNull(DEREncodable dEREncodable) {
        return dEREncodable instanceof ASN1Null || dEREncodable == null;
    }

    private DigestInfo derDecode(byte[] byArray) throws IOException {
        if (byArray[0] != 48) {
            throw new IOException("not a digest info object");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        return new DigestInfo((ASN1Sequence)aSN1InputStream.readObject());
    }

    private boolean verifyDigest(byte[] byArray, PublicKey publicKey, byte[] byArray2, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        String string2 = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        try {
            if (string2.equals("RSA")) {
                Cipher cipher = string != null ? Cipher.getInstance("RSA/ECB/PKCS1Padding", string) : Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(2, publicKey);
                DigestInfo digestInfo = this.derDecode(cipher.doFinal(byArray2));
                if (!digestInfo.getAlgorithmId().getObjectId().equals((Object)this.digestAlgorithm.getObjectId())) {
                    return false;
                }
                if (!this.isNull(digestInfo.getAlgorithmId().getParameters())) {
                    return false;
                }
                byte[] byArray3 = digestInfo.getDigest();
                return MessageDigest.isEqual(byArray, byArray3);
            }
            if (string2.equals("DSA")) {
                Signature signature = string != null ? Signature.getInstance("NONEwithDSA", string) : Signature.getInstance("NONEwithDSA", string);
                signature.initVerify(publicKey);
                signature.update(byArray);
                return signature.verify(byArray2);
            }
            throw new CMSException("algorithm: " + string2 + " not supported in base signatures.");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw noSuchProviderException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CMSException("Exception processing signature: " + generalSecurityException, generalSecurityException);
        }
        catch (IOException iOException) {
            throw new CMSException("Exception decoding signature: " + iOException, iOException);
        }
    }

    public boolean verify(PublicKey publicKey, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.doVerify(publicKey, this.getSignedAttributes(), string);
    }

    public boolean verify(X509Certificate x509Certificate, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        Attribute attribute;
        AttributeTable attributeTable = this.getSignedAttributes();
        if (attributeTable != null && (attribute = attributeTable.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance((Object)attribute.getAttrValues().getObjectAt(0).getDERObject());
            x509Certificate.checkValidity(time.getDate());
        }
        return this.doVerify(x509Certificate.getPublicKey(), attributeTable, string);
    }

    public SignerInfo toSignerInfo() {
        return this.info;
    }

    public static SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable attributeTable) {
        SignerInfo signerInfo = signerInformation.info;
        DERSet dERSet = null;
        if (attributeTable != null) {
            dERSet = new DERSet((DEREncodableVector)attributeTable.toASN1EncodableVector());
        }
        return new SignerInformation(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)dERSet), signerInformation.contentType, signerInformation.content, null);
    }
}

