/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.acegisecurity.providers.cas.CasAuthenticationToken;
import org.acegisecurity.providers.cas.StatelessTicketCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

public class EhCacheBasedTicketCache
implements StatelessTicketCache,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$cas$cache$EhCacheBasedTicketCache == null ? (class$org$acegisecurity$providers$cas$cache$EhCacheBasedTicketCache = EhCacheBasedTicketCache.class$("org.acegisecurity.providers.cas.cache.EhCacheBasedTicketCache")) : class$org$acegisecurity$providers$cas$cache$EhCacheBasedTicketCache));
    private Cache cache;
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$cache$EhCacheBasedTicketCache;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cache, (String)"cache mandatory");
    }

    public CasAuthenticationToken getByTicketId(String serviceTicket) {
        Element element = null;
        try {
            element = this.cache.get((Serializable)((Object)serviceTicket));
        }
        catch (CacheException cacheException) {
            throw new DataRetrievalFailureException("Cache failure: " + cacheException.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache hit: " + (element != null) + "; service ticket: " + serviceTicket));
        }
        if (element == null) {
            return null;
        }
        return (CasAuthenticationToken)element.getValue();
    }

    public Cache getCache() {
        return this.cache;
    }

    public void putTicketInCache(CasAuthenticationToken token) {
        Element element = new Element((Serializable)((Object)token.getCredentials().toString()), (Serializable)token);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + element.getKey()));
        }
        this.cache.put(element);
    }

    public void removeTicketFromCache(CasAuthenticationToken token) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + token.getCredentials().toString()));
        }
        this.removeTicketFromCache(token.getCredentials().toString());
    }

    public void removeTicketFromCache(String serviceTicket) {
        this.cache.remove((Serializable)((Object)serviceTicket));
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

