/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.Selector;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.res.StringManager;

public class InternalNioInputBuffer
implements InputBuffer {
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    protected Request request;
    protected MimeHeaders headers;
    protected boolean parsingHeader;
    protected boolean parsingRequestLine;
    protected int parsingRequestLinePhase = 0;
    protected boolean parsingRequestLineEol = false;
    protected int parsingRequestLineStart = 0;
    protected int parsingRequestLineQPos = -1;
    protected HeaderParsePosition headerParsePos;
    protected boolean swallowInput;
    protected byte[] buf;
    protected int lastValid;
    protected int pos;
    protected int end;
    protected NioChannel socket;
    protected NioSelectorPool pool;
    protected InputBuffer inputStreamInputBuffer;
    protected InputFilter[] filterLibrary;
    protected InputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected HeaderParseData headerData = new HeaderParseData();

    public InternalNioInputBuffer(Request request, int headerBufferSize) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.inputStreamInputBuffer = new SocketInputBuffer();
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.headerData.recycle();
        this.swallowInput = true;
    }

    public void setSocket(NioChannel socket) {
        this.socket = socket;
    }

    public NioChannel getSocket() {
        return this.socket;
    }

    public void setSelectorPool(NioSelectorPool pool) {
        this.pool = pool;
    }

    public NioSelectorPool getSelectorPool() {
        return this.pool;
    }

    public void addFilter(InputFilter filter) {
        InputFilter[] newFilterLibrary = new InputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new InputFilter[this.filterLibrary.length];
    }

    public InputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new InputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addActiveFilter(InputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.inputStreamInputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setRequest(this.request);
    }

    public void setSwallowInput(boolean swallowInput) {
        this.swallowInput = swallowInput;
    }

    public boolean isReadable() throws IOException {
        return this.pos < this.lastValid || this.nbRead() > 0;
    }

    public int nbRead() throws IOException {
        return this.readSocket(true, false);
    }

    public void recycle() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.request.recycle();
        this.socket = null;
        this.lastValid = 0;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
        this.swallowInput = true;
    }

    public void nextRequest() {
        this.request.recycle();
        if (this.lastValid - this.pos > 0) {
            int npos = 0;
            int opos = this.pos;
            while (this.lastValid - opos > opos - npos) {
                System.arraycopy(this.buf, opos, this.buf, npos, opos - npos);
                npos += this.pos;
                opos += this.pos;
            }
            System.arraycopy(this.buf, opos, this.buf, npos, this.lastValid - opos);
        }
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastValid -= this.pos;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
        this.swallowInput = true;
    }

    public void endRequest() throws IOException {
        if (this.swallowInput && this.lastActiveFilter != -1) {
            int extraBytes = (int)this.activeFilters[this.lastActiveFilter].end();
            this.pos -= extraBytes;
        }
    }

    public boolean parseRequestLine(boolean useAvailableData) throws IOException {
        boolean space;
        if (!this.parsingRequestLine) {
            return true;
        }
        if (this.parsingRequestLinePhase == 0) {
            byte chr = 0;
            do {
                if (this.pos < this.lastValid) continue;
                if (useAvailableData) {
                    return false;
                }
                if (this.readSocket(true, false) != 0) continue;
                return false;
            } while ((chr = this.buf[this.pos++]) == 13 || chr == 10);
            --this.pos;
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 1;
        }
        if (this.parsingRequestLinePhase == 1) {
            if (this.pos >= this.lastValid) {
                if (useAvailableData) {
                    return false;
                }
                if (this.readSocket(true, false) == 0) {
                    return false;
                }
            }
            this.parsingRequestLinePhase = 2;
        }
        if (this.parsingRequestLinePhase == 2) {
            space = false;
            while (!space) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    space = true;
                    this.request.method().setBytes(this.buf, this.parsingRequestLineStart, this.pos - this.parsingRequestLineStart);
                }
                ++this.pos;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 3;
        }
        if (this.parsingRequestLinePhase == 3) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            int end = 0;
            while (!space) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    space = true;
                    end = this.pos;
                } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                    this.parsingRequestLineEol = true;
                    space = true;
                    end = this.pos;
                } else if (this.buf[this.pos] == 63 && this.parsingRequestLineQPos == -1) {
                    this.parsingRequestLineQPos = this.pos;
                }
                ++this.pos;
            }
            this.request.unparsedURI().setBytes(this.buf, this.parsingRequestLineStart, end - this.parsingRequestLineStart);
            if (this.parsingRequestLineQPos >= 0) {
                this.request.queryString().setBytes(this.buf, this.parsingRequestLineQPos + 1, end - this.parsingRequestLineQPos - 1);
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, this.parsingRequestLineQPos - this.parsingRequestLineStart);
            } else {
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, end - this.parsingRequestLineStart);
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 4;
        }
        if (this.parsingRequestLinePhase == 4) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            this.end = 0;
            while (!this.parsingRequestLineEol) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 13) {
                    this.end = this.pos;
                } else if (this.buf[this.pos] == 10) {
                    if (this.end == 0) {
                        this.end = this.pos;
                    }
                    this.parsingRequestLineEol = true;
                }
                ++this.pos;
            }
            if (this.end - this.parsingRequestLineStart > 0) {
                this.request.protocol().setBytes(this.buf, this.parsingRequestLineStart, this.end - this.parsingRequestLineStart);
            } else {
                this.request.protocol().setString("");
            }
            this.parsingRequestLine = false;
            this.parsingRequestLinePhase = 0;
            this.parsingRequestLineEol = false;
            this.parsingRequestLineStart = 0;
            return true;
        }
        throw new IllegalStateException("Invalid request line parse phase:" + this.parsingRequestLinePhase);
    }

    private void expand(int newsize) {
        if (newsize > this.buf.length) {
            byte[] tmp = new byte[newsize];
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            this.buf = tmp;
            Object var2_2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSocket(boolean timeout, boolean block) throws IOException {
        int nRead = 0;
        this.socket.getBufHandler().getReadBuffer().clear();
        if (block) {
            Selector selector = null;
            try {
                selector = this.getSelectorPool().get();
            }
            catch (IOException x) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
                if (att == null) {
                    throw new IOException("Key must be cancelled.");
                }
                nRead = this.getSelectorPool().read(this.socket.getBufHandler().getReadBuffer(), this.socket, selector, att.getTimeout());
            }
            catch (EOFException eof) {
                nRead = -1;
            }
            finally {
                if (selector != null) {
                    this.getSelectorPool().put(selector);
                }
            }
        } else {
            nRead = this.socket.read(this.socket.getBufHandler().getReadBuffer());
        }
        if (nRead > 0) {
            this.socket.getBufHandler().getReadBuffer().flip();
            this.socket.getBufHandler().getReadBuffer().limit(nRead);
            this.expand(nRead + this.pos);
            this.socket.getBufHandler().getReadBuffer().get(this.buf, this.pos, nRead);
            this.lastValid = this.pos + nRead;
            return nRead;
        }
        if (nRead == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return 0;
    }

    public boolean parseHeaders() throws IOException {
        HeaderParseStatus status = HeaderParseStatus.HAVE_MORE_HEADERS;
        while ((status = this.parseHeader()) == HeaderParseStatus.HAVE_MORE_HEADERS) {
        }
        if (status == HeaderParseStatus.DONE) {
            this.parsingHeader = false;
            this.end = this.pos;
            return true;
        }
        return false;
    }

    public HeaderParseStatus parseHeader() throws IOException {
        byte chr = 0;
        while (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (chr != 13 && chr != 10) break;
            if (chr == 10) {
                ++this.pos;
                return HeaderParseStatus.DONE;
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            this.headerData.start = this.pos;
            this.headerParsePos = HeaderParsePosition.HEADER_NAME;
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_NAME) {
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            if (this.buf[this.pos] == 58) {
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE;
                this.headerData.headerValue = this.headers.addValue(this.buf, this.headerData.start, this.pos - this.headerData.start);
            }
            if ((chr = this.buf[this.pos]) >= 65 && chr <= 90) {
                this.buf[this.pos] = (byte)(chr - -32);
            }
            ++this.pos;
            if (this.headerParsePos != HeaderParsePosition.HEADER_VALUE) continue;
            this.headerData.start = this.pos;
            this.headerData.realPos = this.pos;
        }
        boolean eol = false;
        while (this.headerParsePos == HeaderParsePosition.HEADER_VALUE || this.headerParsePos == HeaderParsePosition.HEADER_MULTI_LINE) {
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE) {
                boolean space = true;
                while (space) {
                    if (this.pos >= this.lastValid && !this.fill(true, false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                        ++this.pos;
                        continue;
                    }
                    space = false;
                }
                this.headerData.lastSignificantChar = this.headerData.realPos;
                while (!eol) {
                    if (this.pos >= this.lastValid && !this.fill(true, false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    if (this.buf[this.pos] != 13) {
                        if (this.buf[this.pos] == 10) {
                            eol = true;
                        } else if (this.buf[this.pos] == 32) {
                            this.buf[this.headerData.realPos] = this.buf[this.pos];
                            ++this.headerData.realPos;
                        } else {
                            this.buf[this.headerData.realPos] = this.buf[this.pos];
                            this.headerData.lastSignificantChar = ++this.headerData.realPos;
                        }
                    }
                    ++this.pos;
                }
                this.headerData.realPos = this.headerData.lastSignificantChar;
                this.headerParsePos = HeaderParsePosition.HEADER_MULTI_LINE;
            }
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (this.headerParsePos != HeaderParsePosition.HEADER_MULTI_LINE) continue;
            if (chr != 32 && chr != 9) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                continue;
            }
            eol = false;
            this.buf[this.headerData.realPos] = chr;
            ++this.headerData.realPos;
        }
        this.headerData.headerValue.setBytes(this.buf, this.headerData.start, this.headerData.realPos - this.headerData.start);
        this.headerData.recycle();
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    public int available() {
        int result = this.lastValid - this.pos;
        if (result == 0 && this.lastActiveFilter >= 0) {
            for (int i = 0; result == 0 && i <= this.lastActiveFilter; ++i) {
                result = this.activeFilters[i].available();
            }
        }
        return result;
    }

    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(chunk, req);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(chunk, req);
    }

    protected boolean fill(boolean timeout, boolean block) throws IOException, EOFException {
        boolean read = false;
        if (this.parsingHeader) {
            if (this.lastValid == this.buf.length) {
                throw new IOException(sm.getString("iib.requestheadertoolarge.error"));
            }
            read = this.readSocket(timeout, block) > 0;
        } else {
            if (this.buf.length - this.end < 4500) {
                this.buf = new byte[this.buf.length];
                this.end = 0;
            }
            this.lastValid = this.pos = this.end;
            read = this.readSocket(timeout, block) > 0;
        }
        return read;
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalNioInputBuffer.this.pos >= InternalNioInputBuffer.this.lastValid && !InternalNioInputBuffer.this.fill(true, true)) {
                return -1;
            }
            int length = InternalNioInputBuffer.this.lastValid - InternalNioInputBuffer.this.pos;
            chunk.setBytes(InternalNioInputBuffer.this.buf, InternalNioInputBuffer.this.pos, length);
            InternalNioInputBuffer.this.pos = InternalNioInputBuffer.this.lastValid;
            return length;
        }
    }

    public static class HeaderParseData {
        int start = 0;
        int realPos = 0;
        int lastSignificantChar = 0;
        MessageBytes headerValue = null;

        public void recycle() {
            this.start = 0;
            this.realPos = 0;
            this.lastSignificantChar = 0;
            this.headerValue = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HeaderParsePosition {
        HEADER_START,
        HEADER_NAME,
        HEADER_VALUE,
        HEADER_MULTI_LINE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HeaderParseStatus {
        DONE,
        HAVE_MORE_HEADERS,
        NEED_MORE_DATA;

    }
}

