/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.text.AttributeMap;
import com.sk_jp.text.html.HTMLHandler;
import com.sk_jp.text.html.HTMLLex;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MHTML {
    private List files = new ArrayList();
    private Map tempHTMLs = new HashMap();
    private static final MimetypesFileTypeMap FILETYPE_MAP = new MimetypesFileTypeMap();

    public static void writeMHTML(String string, OutputStream outputStream) throws IOException {
        MHTML mHTML = new MHTML();
        mHTML.addFile(string);
        mHTML.writeTo(outputStream);
    }

    public void addFile(Object object) {
        if (this.files.contains(object)) {
            return;
        }
        this.files.add(object);
    }

    public void reset() {
        this.files.clear();
        Iterator iterator = this.tempHTMLs.values().iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            file.delete();
        }
        this.tempHTMLs.clear();
    }

    public MimeMessage generate() throws IOException {
        this.parseHTMLs();
        if (this.files.size() == 0) {
            return null;
        }
        try {
            MimeMessage mimeMessage = new MimeMessage((Session)null);
            if (this.files.size() == 1) {
                mimeMessage.setDataHandler(this.createDH(this.files.get(0)));
                mimeMessage.setHeader("Content-Transfer-Encoding", "8bit");
            } else {
                MimeMultipart mimeMultipart = new MimeMultipart("related; type=\"text/html\"");
                for (int i = 0; i < this.files.size(); ++i) {
                    Object e = this.files.get(i);
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    mimeBodyPart.setDataHandler(this.createDH(e));
                    mimeBodyPart.setHeader("Content-ID", "<" + e.toString() + ">");
                    if (this.isHTML(e)) {
                        mimeBodyPart.setHeader("Content-Transfer-Encoding", "8bit");
                    }
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                }
                mimeMessage.setContent((Multipart)mimeMultipart);
            }
            return mimeMessage;
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.toString());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            this.generate().writeTo(outputStream);
            this.reset();
        }
        catch (MessagingException messagingException) {
            throw new IOException(messagingException.toString());
        }
    }

    private DataHandler createDH(Object object) {
        if (object instanceof String) {
            File file = (File)this.tempHTMLs.get(object);
            if (file == null) {
                file = new File((String)object);
            }
            FileDataSource fileDataSource = new FileDataSource(file);
            fileDataSource.setFileTypeMap(FILETYPE_MAP);
            return new DataHandler(fileDataSource);
        }
        throw new RuntimeException();
    }

    private boolean isHTML(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.endsWith(".htm")) {
                return true;
            }
            return string.endsWith(".html");
        }
        throw new RuntimeException();
    }

    private InputStream openStream(Object object) throws IOException {
        if (object instanceof String) {
            return new FileInputStream((String)object);
        }
        throw new RuntimeException();
    }

    private void parseHTMLs() throws IOException {
        Handler handler = new Handler();
        HTMLLex hTMLLex = new HTMLLex(handler);
        for (int i = 0; i < this.files.size(); ++i) {
            Object e = this.files.get(i);
            if (!this.isHTML(e)) continue;
            this.tempHTMLs.put(e, handler.newFile());
            try {
                hTMLLex.parse(new InputStreamReader(this.openStream(e), "JISAutoDetect"));
                handler.close();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        MHTML.writeMHTML(stringArray[0], System.out);
    }

    static {
        FILETYPE_MAP.addMimeTypes("audio/x-wav wav WAV\r\naudio/mpeg mpga mp2 mp3");
    }

    private class Handler
    implements HTMLHandler {
        private File outputFile;
        private PrintWriter out;

        private Handler() {
        }

        public File newFile() throws IOException {
            this.outputFile = File.createTempFile("mhtmlfragment", ".html");
            this.outputFile.deleteOnExit();
            this.out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.outputFile)));
            return this.outputFile;
        }

        public void close() {
            this.out.close();
        }

        public boolean enter(String string, AttributeMap attributeMap) {
            if (string.equalsIgnoreCase("a")) {
                String string2 = attributeMap.get("href");
                if (string2 == null) {
                    return false;
                }
                MHTML.this.addFile(string2);
                attributeMap.put("href", "cid:" + string2);
                this.out.print("<a");
                this.out.print(attributeMap);
                this.out.print(">");
                return true;
            }
            if (string.equalsIgnoreCase("area")) {
                String string3 = attributeMap.get("href");
                if (string3 == null) {
                    return false;
                }
                MHTML.this.addFile(string3);
                attributeMap.put("href", "cid:" + string3);
                this.out.print("<area");
                this.out.print(attributeMap);
                this.out.print(">");
                return true;
            }
            if (string.equalsIgnoreCase("frame")) {
                String string4 = attributeMap.get("src");
                if (string4 == null) {
                    return false;
                }
                MHTML.this.addFile(string4);
                attributeMap.put("src", "cid:" + string4);
                this.out.print("<frame");
                this.out.print(attributeMap);
                this.out.print(">");
                return true;
            }
            if (string.equalsIgnoreCase("img")) {
                String string5 = attributeMap.get("src");
                if (string5 == null) {
                    return false;
                }
                MHTML.this.addFile(string5);
                attributeMap.put("src", "cid:" + string5);
                this.out.print("<img");
                this.out.print(attributeMap);
                this.out.print(">");
                return true;
            }
            if (string.equalsIgnoreCase("embed")) {
                String string6 = attributeMap.get("src");
                if (string6 == null) {
                    return false;
                }
                MHTML.this.addFile(string6);
                attributeMap.put("src", "cid:" + string6);
                this.out.print("<embed");
                this.out.print(attributeMap);
                this.out.print(">");
                return true;
            }
            return false;
        }

        public boolean leave(String string) {
            return false;
        }

        public void text(String string) {
            this.out.print(string);
        }
    }
}

