/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id$
 */

#ifndef _BBSTHREAD_UI_H_
#define _BBSTHREAD_UI_H_

#include "asyncbuf.h"
#include "threadlist_view.h"
#include "icon_label.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * åɤGUIϢ
 */
/* ThreadlistInfoΥ֥饹Ū˻Ȥ */
typedef struct _BBSThreadGUIInfo
{
  ThreadlistInfo info;

  /* ǽο쥹Ƭդޡ */
  GtkTextMark *last_read;

  /* ɽɽ֤դޡ */
  GtkTextMark *next_mark;

  /* ġΥ쥹GtkTextBuffer⥪եå */
  gint *offsets;

  gboolean rendering_done;

  /* ɽDATեΥХåե */
  AsyncBuffer *dat_buffer;

  char *last_modified;

  /* Ǹ˳ưʹߤΥ */
  gint view_ignored;
} BBSThreadGUIInfo;


#if 0
/* ThreadlistEntryStateĥƻȤ */
typedef enum
{
  BBS_THREAD_STARTUP = 1 << 2,
} ThreadlistEntryState;
#endif


void initialize_thread_ui(OchushaApplication *application);
BBSThreadGUIInfo * ensure_bbs_thread_info(BBSThread *thread);
GtkWidget *open_bbs_thread(OchushaApplication *application, BBSThread *thread,
			   IconLabel *tab_label);

void refresh_thread(OchushaApplication *application, GtkWidget *widget,
		    BBSThread *thread, IconLabel *tab_label);
void go_to_the_first_response(GtkWidget *widget, BBSThread *thread);
void go_to_the_last_response(GtkWidget *widget, BBSThread *thread);
void jump_to_new_comer_response(GtkWidget *widget, BBSThread *thread);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _BBSTHREAD_UI_H_ */
