/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id$
 */

#include "config.h"

#include "ochusha.h"
#include "ochusha_ui.h"

#include "htmlutils.h"

#include "worker.h"

#include <glib.h>
#include <gtk/gtk.h>

#include <stdio.h>
#include <stdlib.h>

#define INITIAL_NUM_THREADS	2
#define MAXIMUM_NUM_THREADS	32



int
main(int argc, char *argv[])
{
  gchar *resource_file;
  OchushaApplication *application
    = (OchushaApplication *)calloc(1, sizeof(OchushaApplication));

  ochusha_prepare_home(&application->conf);

  g_thread_init(NULL);
  gdk_threads_init();
  gtk_set_locale();
  gtk_init(&argc, &argv);
  bindtextdomain(PACKAGE_NAME, LOCALEDIR);
  textdomain(PACKAGE_NAME);

  bind_textdomain_codeset(PACKAGE_NAME, "UTF-8");

  initialize_default_entity_dictionary();
  initialize_common_converters();
  initialize_worker(INITIAL_NUM_THREADS, MAXIMUM_NUM_THREADS);

  resource_file = ochusha_find_file(&application->conf, OCHUSHA_GTKRC);
  if (resource_file != NULL)
    gtk_rc_parse(resource_file);

  ochusha_init_application(application);

  gdk_threads_enter();
  gtk_main();
  gdk_threads_leave();

  terminate_workers();

  return 0;
}
