/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: boardlist_view.h,v 1.3 2003/05/14 20:58:12 fuyu Exp $
 */

#ifndef _BOARDLIST_VIEW_H_
#define _BOARDLIST_VIEW_H_

#include "ochusha.h"

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif


#define BOARDLIST_VIEW_TYPE			(boardlist_view_get_type())
#define BOARDLIST_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), BOARDLIST_VIEW_TYPE, BoardlistView))
#define BOARDLIST_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), BOARDLIST_VIEW_TYPE, BoardlistViewClass))
#define IS_BOARDLIST_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), BOARDLIST_VIEW_TYPE))
#define IS_BOARDLIST_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), BOARDLIST_VIEW_TYPE))
#define BOARDLIST_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), BOARDLIST_VIEW_TYPE, BoardlistViewClass))


typedef struct _BoardlistView BoardlistView;
typedef struct _BoardlistViewClass BoardlistViewClass;

struct _BoardlistView
{
  GtkScrolledWindow container;

  GtkTreeView *view;
  GtkTreeModel *model;

  GtkTreeSelection *selection;

  gdouble last_event_x;
  gdouble last_event_y;
  guint last_event_button;
};


struct _BoardlistViewClass
{
  GtkScrolledWindowClass parent_class;

  void (*open_view)(BoardlistView *boardlist_view, OchushaBulletinBoard *board,
		    gboolean in_tab);
  void (*select_category)(BoardlistView *boardlist_view,
			  OchushaBoardCategory *category);
  void (*category_expanded)(BoardlistView *boardlist_view,
			    OchushaBoardCategory *category);
  void (*category_collapsed)(BoardlistView *boardlist_view,
			     OchushaBoardCategory *category);
};


GType boardlist_view_get_type(void);
GtkWidget *boardlist_view_new(void);
void boardlist_view_open(BoardlistView *view, GSList *category_list);

void boardlist_view_expand_category(BoardlistView *view,
				    OchushaBoardCategory *category);
void boardlist_view_collapse_category(BoardlistView *view,
				      OchushaBoardCategory *category);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _BOARDLIST_VIEW_H_ */
