/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_board_jbbs.h,v 1.2 2004/01/15 02:12:14 fuyu Exp $
 */

#ifndef _OCHUSHA_BOARD_JBBS_H_
#define _OCHUSHA_BOARD_JBBS_H_

#include "ochusha_board_2ch.h"

#include <glib-object.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define OCHUSHA_TYPE_BOARD_JBBS			(ochusha_board_jbbs_get_type())
#define OCHUSHA_BOARD_JBBS(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_BOARD_JBBS, OchushaBoardJBBS))
#define OCHUSHA_BOARD_JBBS_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_BOARD_JBBS, OchushaBoardJBBSClass))
#define OCHUSHA_IS_BOARD_JBBS(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_BOARD_JBBS))
#define OCHUSHA_IS_BOARD_JBBS_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_BOARD_JBBS))
#define OCHUSHA_BOARD_JBBS_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_BOARD_JBBS, OchushaBoardJBBSClass))


typedef struct _OchushaBoardJBBS OchushaBoardJBBS;
typedef struct _OchushaBoardJBBSClass OchushaBoardJBBSClass;


struct _OchushaBoardJBBS
{
  OchushaBoard2ch parent_object;
};


struct _OchushaBoardJBBSClass
{
  OchushaBoard2chClass parent_class;
};


GType ochusha_board_jbbs_get_type(void);
OchushaBulletinBoard *ochusha_board_jbbs_new(const gchar *name,
					     const gchar *url);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_BOARD_JBBS_H_ */
