/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * This is completely derived from TinyScheme 1.33 even though
 * the source code literally seems not like that ;-).
 *
 * $Id: ts_core.h,v 1.4 2004/01/05 13:16:32 fuyu Exp $
 */

/* T I N Y S C H E M E    1 . 3 3
 *   Dimitrios Souflis (dsouflis@acm.org)
 *   Based on MiniScheme (original credits follow)
 * (MINISCM)               coded by Atsushi Moriwaki (11/5/1989)
 * (MINISCM)           E-MAIL :  moriwaki@kurims.kurims.kyoto-u.ac.jp
 * (MINISCM) This version has been modified by R.C. Secrist.
 * (MINISCM)
 * (MINISCM) Mini-Scheme is now maintained by Akira KIDA.
 * (MINISCM)
 * (MINISCM) This is a revised and modified version by Akira KIDA.
 * (MINISCM)	current version is 0.85k4 (15 May 1994)
 *
 */

/*
 * LICENSE TERMS
 *
 * Copyright (c) 2000, Dimitrios Souflis
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * Neither the name of Dimitrios Souflis nor the names of the
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TS_CORE_H_
#define _TS_CORE_H_

#include <stdio.h>


/* static configuration */

#ifndef USE_TRACING
# define USE_TRACING 1
#endif

/* To force system errors through user-defined error handling
 * (see *error-hook*)
 */
#ifndef USE_ERROR_HOOK
# define USE_ERROR_HOOK 1
#endif

/* Enable qualified qualifier */
#ifndef USE_COLON_HOOK
# define USE_COLON_HOOK 1
#endif


typedef struct _TSCore TSCore;
typedef struct _TSCell TSCell;
typedef TSCell *(*TSForeignFunc)(TSCore *, TSCell *);

typedef void * (*func_alloc)(size_t);
typedef void (*func_dealloc)(void *);



/*------------------ Ugly internals -----------------------------------*/
/*------------------ Of interest only to FFI users --------------------*/


enum scheme_port_kind
{
  port_free = 0,
  port_file = 1,
  port_string = 2,
  port_input = 16,
  port_output = 32
};


typedef struct port
{
  unsigned char kind;
  union
  {
    struct
    {
      FILE *file;
      int closeit;
    } stdio;
    struct
    {
      char *start;
      char *past_the_end;
      char *curr;
    } string;
  } rep;
} port;


/* num, for generic arithmetic */
typedef struct num
{
  char is_fixnum;
  union
  {
    long ivalue;
    double rvalue;
  } value;
} num;


/* cell structure */
struct _TSCell
{
  unsigned int flag;
  union
  {
    struct
    {
      char *svalue;
      size_t length;
    } string;
    num number;
    port *port;
    TSForeignFunc ff;
    struct
    {
      TSCell *car;
      TSCell *cdr;
    } cons;
    struct
    {
      void *pointer;
      void (*destructor)(void *);
    } fo;
  } object;
};


struct _TSCore
{
  func_alloc malloc;
  func_dealloc free;

  int retcode;

  /* arrays for segments */
#define CELL_NSEGMENT   10    /* # of segments for cells */
  char *alloc_seg[CELL_NSEGMENT];
  TSCell *cell_seg[CELL_NSEGMENT];
  int last_cell_seg;


  /* We use 4 registers. */
  TSCell *args;		/* register for arguments of function */
  TSCell *envir;	/* stack register for current environment */
  TSCell *code;		/* register for current code */
  TSCell *dump;		/* stack register for next evaluation */

  TSCell _sink;
  TSCell *sink;		/* when mem. alloc. fails */
  TSCell _nil;
  TSCell *nil;		/* special cell representing empty cell */
  TSCell _t;
  TSCell *t;		/* special cell representing #t */
  TSCell _f;
  TSCell *f;		/* special cell representing #f */
  TSCell _eof_obj;
  TSCell *eof_obj;	/* special cell representing end-of-file object */
  TSCell *oblist;	/* pointer to symbol table */
  TSCell *global_env;	/* pointer to global environment */

  TSCell *ext_roots;	/* pointer to external roots */

  /* global pointers to special symbols */
  TSCell *lambda;	/* pointer to syntax lambda */
  TSCell *quote;	/* pointer to syntax quote */
  TSCell *qquote;	/* pointer to symbol quasiquote */
  TSCell *unquote;	/* pointer to symbol unquote */
  TSCell *unquotesp;	/* pointer to symbol unquote-splicing */
  TSCell *feed_to;	/* => */
  TSCell *colon_hook;	/* *colon-hook* */
  TSCell *error_hook;	/* *error-hook* */
  TSCell *sharp_hook;	/* *sharp-hook* */

  TSCell *free_cell;	/* pointer to top of free cells */
  long fcells;		/* # of free cells */

  TSCell *inport;
  TSCell *outport;
  TSCell *save_inport;
  TSCell *loadport;

#define MAXFIL 64
  port load_stack[MAXFIL];	/* Stack of open files for port -1 (LOADing) */
  int nesting_stack[MAXFIL];
  int file_i;
  int nesting;

#define LINESIZE 1024
  char linebuff[LINESIZE];
  char strbuff[256];

  int tok;
  TSCell *value;
  int op;

  void *ext_data;	/* For the benefit of foreign functions */
  long gensym_cnt;

  void *dump_base;	/* pointer to base of allocated dump stack */
  int dump_size;	/* number of frames allocated for dump stack */

  int print_flag;
  int tracing;
  int interactive_repl;	/* are we in an interactive REPL? */
  char gc_verbose;	/* if gc_verbose is not zero, print gc status */
  char no_memory;	/* Whether mem. alloc. has failed */
};


/*
 * semi public APIs
 * -- for aggressive users who don't worry about compatibilies
 */
/* semi private APIs -- for CORE users like FFI */

/* TSCell APIs */
TSCell *ts_core_mk_cell_cons(TSCore *sc, TSCell *a, TSCell *d, int immutable);
TSCell *ts_core_mk_cell_integer(TSCore *sc, long num);
TSCell *ts_core_mk_cell_real(TSCore *sc, double num);
TSCell *ts_core_mk_cell_symbol(TSCore *sc, const char *name);
TSCell *ts_core_mk_cell_string(TSCore *sc, const char *str);
TSCell *ts_core_mk_cell_character(TSCore *sc, int c);
TSCell *ts_core_mk_cell_foreign_func(TSCore *sc, TSForeignFunc f);

TSCell *ts_core_mk_cell_counted_string(TSCore *sc,
				       const char *str, size_t len);
TSCell *ts_core_mk_cell_port(TSCore *sc, port *p);
TSCell *ts_core_mk_cell_closure(TSCore *sc, TSCell *c, TSCell *e);
TSCell *ts_core_mk_cell_continuation(TSCore *sc, TSCell *d);
TSCell *ts_core_mk_cell_number(TSCore *sc, num n);
TSCell *ts_core_mk_cell_empty_string(TSCore *sc, size_t len, char fill);
TSCell *ts_core_mk_cell_vector(TSCore *sc, int len);
TSCell *ts_core_mk_cell_atom(TSCore *sc, char *q);
TSCell *ts_core_mk_cell_sharp_constant(TSCore *sc, char *name);
TSCell *ts_core_mk_cell_foreign_object(TSCore *sc, void *pointer,
				       void (*destructor)(void *));

TSCell *ts_core_list_reverse(TSCore *sc, TSCell *list);
TSCell *ts_core_list_reverse_in_place(TSCore *sc, TSCell *term, TSCell *list);
TSCell *ts_core_list_append(TSCore *sc, TSCell *a, TSCell *b);

void ts_core_register_external_root(TSCore *sc, TSCell *cell);
void ts_core_unregister_external_root(TSCore *sc, TSCell *cell);


TSCore *ts_core_init_new(void);
TSCore *ts_core_init_new_custom_alloc(func_alloc malloc_func,
				      func_dealloc free_func);
int ts_core_init(TSCore *sc);
int ts_core_init_custom_alloc(TSCore *sc, func_alloc, func_dealloc);
void ts_core_deinit(TSCore *sc);

void ts_core_set_input_port_file(TSCore *sc, FILE *fin);
void ts_core_set_input_port_string(TSCore *sc, char *start, char *past_the_end);
void ts_core_set_output_port_file(TSCore *sc, FILE *fin);
void ts_core_set_output_port_string(TSCore *sc, char *start, char *past_the_end);
void ts_core_load_file(TSCore *sc, FILE *fin);
void ts_core_load_string(TSCore *sc, const char *cmd);
void ts_core_set_external_data(TSCore *sc, void *p);
void ts_core_define(TSCore *sc, TSCell *env, TSCell *symbol, TSCell *value);
void ts_core_apply0(TSCore *sc, const char *name);
TSCell *ts_core_eval(TSCore *sc, TSCell *symbol, TSCell *args);
TSCell *ts_core_call(TSCore *sc, TSCell *func, TSCell *args);


enum scheme_types {
  T_STRING = 1,
  T_NUMBER = 2,
  T_SYMBOL = 3,
  T_PROC = 4,
  T_PAIR = 5,
  T_CLOSURE = 6,
  T_CONTINUATION = 7,
  T_FOREIGN = 8,
  T_CHARACTER = 9,
  T_PORT = 10,
  T_VECTOR = 11,
  T_MACRO = 12,
  T_PROMISE = 13,
  T_ENVIRONMENT = 14,
  T_FOREIGN_OBJECT = 15,
  T_LAST_SYSTEM_TYPE = 15
};


/* macros for cell operations */
#define TYPE_BITS	 5
#define T_MASKTYPE      31    /* 0000000000011111 */
#define T_SYNTAX      4096    /* 0001000000000000 */
#define T_IMMUTABLE   8192    /* 0010000000000000 */

#define CONS(sc, a, b)			ts_core_mk_cell_cons(sc, a, b, 0)
#define IMMUTABLE_CONS(sc, a, b)	ts_core_mk_cell_cons(sc, a, b, 1)

#define TYPEFLAG(p)      	((p)->flag)
#define TYPE(p)          	(TYPEFLAG(p) & T_MASKTYPE)
#define STRVALUE(p)		((p)->object.string.svalue)
#define STRLENGTH(p)		((p)->object.string.length)

#define IS_INTEGER(p)		((p)->object.number.is_fixnum)
#define IS_REAL(p)		(!(p)->object.number.is_fixnum)

#define IS_CHARACTER(p)		(TYPE(p) == T_CHARACTER)
#define IS_CLOSURE(p)		(TYPE(p) == T_CLOSURE)
#define IS_CONTINUATION(p)	(TYPE(p) == T_CONTINUATION)
#define SET_ENVIRONMENT(p)	TYPEFLAG(p) = T_ENVIRONMENT
#define IS_ENVIRONMENT(p)	(TYPE(p) == T_ENVIRONMENT)
#define IS_FOREIGN(p)		(TYPE(p) == T_FOREIGN)
#define IS_MACRO(p)		(TYPE(p) == T_MACRO)
#define IS_NUMBER(p)		(TYPE(p) == T_NUMBER)
#define IS_PROC(p)		(TYPE(p) == T_PROC)
#define IS_PROMISE(p)		(TYPE(p) == T_PROMISE)
#define IS_STRING(p)		(TYPE(p) == T_STRING)
#define IS_SYMBOL(p)		(TYPE(p) == T_SYMBOL)
#define IS_VECTOR(p)		(TYPE(p) == T_VECTOR)

#define IS_PAIR(p)		(TYPE(p) == T_PAIR)
#define IS_PORT(p)		(TYPE(p) == T_PORT)
#define IS_INPORT(p)		(IS_PORT(p) && p->object.port->kind & port_input)
#define IS_OUTPORT(p)		(IS_PORT(p) && p->object.port->kind & port_output)

#define IS_FOREIGN_OBJECT(p)	(TYPE(p) == T_FOREIGN_OBJECT)

#define IS_SYNTAX(p)		(TYPEFLAG(p) & T_SYNTAX)
#define IS_IMMUTABLE(p)		(TYPEFLAG(p) & T_IMMUTABLE)
#define SET_IMMUTABLE(p)	TYPEFLAG(p) |= T_IMMUTABLE


#define IVALUE_UNCHECKED(p)	((p)->object.number.value.ivalue)
#define RVALUE_UNCHECKED(p)	((p)->object.number.value.rvalue)
#define SET_INTEGER(p)		(p)->object.number.is_fixnum=1;
#define SET_REAL(p)		(p)->object.number.is_fixnum=0;

#define CAR(p)			((p)->object.cons.car)
#define CDR(p)			((p)->object.cons.cdr)
#define CAAR(p)			CAR(CAR(p))
#define CADR(p)			CAR(CDR(p))
#define CDAR(p)			CDR(CAR(p))
#define CDDR(p)			CDR(CDR(p))
#define CADAR(p)		CAR(CDR(CAR(p)))
#define CADDR(p)		CAR(CDR(CDR(p)))
#define CADAAR(p)		CAR(CDR(CAR(CAR(p))))
#define CADDDR(p)		CAR(CDR(CDR(CDR(p))))
#define CDDDDR(p)		CDR(CDR(CDR(CDR(p))))


#define NVALUE(p)		((p)->object.number)
#define NUM_IVALUE(n)		(n.is_fixnum ? (n).value.ivalue : (long)(n).value.rvalue)
#define NUM_RVALUE(n)		(!n.is_fixnum ? (n).value.rvalue : (double)(n).value.ivalue)

#define IVALUE(p)		(IS_INTEGER(p) ? (p)->object.number.value.ivalue : (long)(p)->object.number.value.rvalue)
#define RVALUE(p)		(!IS_INTEGER(p) ? (p)->object.number.value.rvalue : (double)(p)->object.number.value.ivalue)
#define CHARVALUE(p)		(IVALUE_UNCHECKED(p))



#endif	/* _TS_CORE_H_ */
