/* mod_tree_data_list.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This is a modified version of GtkTreeDataList from GTK+-2.2.4 by the
 * Ochusha Project.  See the AUTHORS file for a list of people on the
 * Ochusha Project.  See the ChangeLog files for a list of changes.
 * These files are distributed with ochusha at
 * http://ochusha.sourceforge.jp/.
 *
 * Since libmodifiedgtk2 only has limited set of modified widgets and
 * is intended to be used with original GTK+, I don't want to cause name
 * space conflictions with original widgets sets from GTK+.  Therefore,
 * ALL PUBLICLY AVAILABLE NAMES ARE RENAMED.
 *
 * $Id: mod_tree_data_list.h,v 1.2 2004/02/05 00:40:01 fuyu Exp $
 */

#ifndef __MOD_TREE_DATA_LIST_H__
#define __MOD_TREE_DATA_LIST_H__

#include <glib.h>
#include <glib-object.h>
#include "gtk/gtk.h"

typedef struct _ModTreeDataList ModTreeDataList;
struct _ModTreeDataList
{
  ModTreeDataList *next;

  union {
    gint	   v_int;
    gint8          v_char;
    guint8         v_uchar;
    guint	   v_uint;
    glong	   v_long;
    gulong	   v_ulong;
    gint64	   v_int64;
    guint64        v_uint64;
    gfloat	   v_float;
    gdouble        v_double;
    gpointer	   v_pointer;
  } data;
};

typedef struct _ModTreeDataSortHeader
{
  gint sort_column_id;
  GtkTreeIterCompareFunc func;
  gpointer data;
  GtkDestroyNotify destroy;
} ModTreeDataSortHeader;

ModTreeDataList *_mod_tree_data_list_alloc          (void);
void             _mod_tree_data_list_free           (ModTreeDataList *list,
						     GType           *column_headers);
gboolean         _mod_tree_data_list_check_type     (GType            type);
void             _mod_tree_data_list_node_to_value  (ModTreeDataList *list,
						     GType            type,
						     GValue          *value);
void             _mod_tree_data_list_value_to_node  (ModTreeDataList *list,
						     GValue          *value);

ModTreeDataList *_mod_tree_data_list_node_copy      (ModTreeDataList *list,
                                                     GType            type);

/* Header code */
gint                   mod_tree_data_list_compare_func (GtkTreeModel *model,
							GtkTreeIter  *a,
							GtkTreeIter  *b,
							gpointer      user_data);
GList *                _mod_tree_data_list_header_new  (gint          n_columns,
							GType        *types);
void                   _mod_tree_data_list_header_free (GList        *header_list);
ModTreeDataSortHeader *_mod_tree_data_list_get_header  (GList        *header_list,
							gint          sort_column_id);


#endif /* __MOD_TREE_DATA_LIST_H__ */
