//
//  NSFileManager+OpenMetaKit.m
//  OpenMetaKit
//
//  Created by s-take on 09/02/08.
//  
//  The MIT License
//  
//  Copyright (c) 2009 s-take.
//  
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//  
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//  
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.
//  

#import "NSFileManager+OpenMetaKit.h"
#import "NSFileManager+OpenMetaKitPrivate.h"


@implementation NSFileManager (OpenMetaKit)

- (NSArray *)tagsOfFileAtPath:(NSString *)path
{
	NSData *data = [self dataForExtendedAttribute:OMKUserTagsAttributeName ofFileAtPath:path error:NULL];
	id decoded = [NSPropertyListSerialization propertyListFromData:data
												  mutabilityOption:NSPropertyListImmutable
															format:NULL
												  errorDescription:NULL];
	if([decoded isKindOfClass:[NSArray class]]) {
		if([decoded count]) {
			return decoded;
		}
	}
	return nil;
}

- (void)setTags:(NSArray *)tags ofFileAtPath:(NSString *)path storesHistory:(BOOL)flag
{
	NSData *data = [NSPropertyListSerialization dataFromPropertyList:tags format:NSPropertyListBinaryFormat_v1_0 errorDescription:NULL];
	// if flag is true, append the new tags to tag history.
	if(flag) {
		[self updateTagHistoryWithTags:tags];
	}
	NSError *error = [self setData:data forExtendedAttribute:OMKUserTagsAttributeName ofFileAtPath:path];
	if(!error) {
		[self touchUserTaggedDateOfFileAtPath:path withDate:nil];
	}
}

- (float)ratingOfFileAtPath:(NSString *)path
{
	NSData *data = [self dataForExtendedAttribute:OMKUserRatingAttributeName ofFileAtPath:path error:NULL];
	id decoded = [NSPropertyListSerialization propertyListFromData:data
												  mutabilityOption:NSPropertyListImmutable
															format:NULL
												  errorDescription:NULL];
	if([decoded isKindOfClass:[NSNumber class]]) {
		return [decoded floatValue];
	}
	return 0.0;
}
- (void)setRating:(float)rating ofFileAtPath:(NSString *)path
{
	NSData *data = [NSPropertyListSerialization dataFromPropertyList:[NSNumber numberWithFloat:rating]
															  format:NSPropertyListBinaryFormat_v1_0
													errorDescription:NULL];
	[self setData:data forExtendedAttribute:OMKUserRatingAttributeName ofFileAtPath:path];
}

- (NSArray *)tagHistory
{
	CFArrayRef recents = CFPreferencesCopyAppValue(CFSTR("recentlyEnteredTags"), CFSTR("com.openmeta.shared"));
	NSArray *arrayToReturn;
	if(recents) {
		arrayToReturn = [NSArray arrayWithArray:(NSArray *)recents];
		CFRelease(recents);
	}
	if(!arrayToReturn) {
		arrayToReturn = [NSArray array];
	}
	return arrayToReturn;
}

@end
