#include <jni.h>

#ifndef _JSTRING_H_
#define _JSTRING_H_

#ifdef __cplusplus
extern "C" {
#endif

extern const char * GetStringChars(JNIEnv *env, jstring string, const char *encoding, int *length) {
    if (string) {
        char *bytes = NULL;
        jstring charset;
        jthrowable ex = (*env)->ExceptionOccurred(env);
        if (ex) {
            // ̗ONA
            (*env)->ExceptionClear(env);
        }

        charset = (*env)->NewStringUTF(env, encoding);
        if (charset) {
            jclass clazz = (*env)->GetObjectClass(env, string);
            if (clazz) {
                static jmethodID mid_getBytes = 0;
                jbyteArray buff;

                if (!mid_getBytes) {
                    mid_getBytes = (*env)->GetMethodID(env, clazz, "getBytes", "(Ljava/lang/String;)[B");
                    if (!mid_getBytes) {
                        (*env)->DeleteLocalRef(env, clazz);
                        (*env)->DeleteLocalRef(env, charset);
                        (*env)->DeleteLocalRef(env, ex);
                        return NULL;
                    }
                }

                buff = (jbyteArray)(*env)->CallObjectMethod(env, string, mid_getBytes, charset);
                if (buff) {
                    int len = (int)(*env)->GetArrayLength(env, buff);
                    bytes = (char *)calloc(len + 1, sizeof(char));
                    if (bytes) {
                        (*env)->GetByteArrayRegion(env, buff, 0, len, (jbyte *)bytes);
                        bytes[len] = '\0';
                        if (length) {
                            *length = len;
                        }
                    } else {
                        ThrowOutOfMemoryError(env);
                    }
                    (*env)->DeleteLocalRef(env, buff);
                }
                (*env)->DeleteLocalRef(env, clazz);
            }
            (*env)->DeleteLocalRef(env, charset);
        }

        if (ex) {
            if ((*env)->ExceptionCheck(env) == JNI_FALSE) {
                // ĂO߂
                (*env)->Throw(env, ex);
            }
            (*env)->DeleteLocalRef(env, ex);
        }

        return (const char *)bytes;
    }
    return NULL;

}

#ifdef __GNUC__
#define ARG_UNUSED  __attribute__((unused))
#else
#define ARG_UNUSED
#endif

/*
 * GetStringUTF8Chars()ŐꂽcharzB
 * @see http://www.ne.jp/asahi/hishidama/home/tech/java/jni_code.html#ReleaseStringMS932Chars
 */
extern void ReleaseStringChars(JNIEnv *env ARG_UNUSED, jstring string ARG_UNUSED, const OnigUChar *bytes) {
    free((void *)bytes);
}

#define GetStringUTF8Chars(env, jstr, len) GetStringChars(env, jstr, "UTF-8", len)
#define ReleaseStringUTF8Chars(env, jstr, bytes) ReleaseStringChars(env, jstr, bytes)

#ifdef __cplusplus
}
#endif
#endif
