package onig4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import static onig4j.OnigRegex.onig_get_default_case_fold_flag;
import static onig4j.OnigRegex.onig_set_default_case_fold_flag;
import static onig4j.OnigRegex.ONIG_NORMAL;

/**
 * OnigCaseFoldType enum class.
 * @author calico
 * @see <a href="http://www.geocities.jp/kosako3/oniguruma/">Oniguruma</a>
 * @see <a href="http://www.geocities.jp/kosako3/oniguruma/index_ja.html">鬼車</a>
 */
public enum OnigCaseFoldType {
    /**
     * Not implemented in the Oniguruma version 5.9.1 yet.
     */
    ONIGENC_CASE_FOLD_HIRAGANA_KATAKANA(1 << 1),
    
    /**
     * Not implemented in the Oniguruma version 5.9.1 yet.
     */
    ONIGENC_CASE_FOLD_KATAKANA_WIDTH(1 << 2),
    
    /**
     * case fold type for Turkish and Azerbaijan language.<br/>
     * NOTE: The Oniguruma library where USE_UNICODE_CASE_FOLD_TURKISH_AZERI was enabled is necessary.
     */
    ONIGENC_CASE_FOLD_TURKISH_AZERI(1 << 20),
    
    /** minimum */
    ONIGENC_CASE_FOLD_MIN(1 << 30);
    
    private final int value;
    
    private OnigCaseFoldType(int value) {
        this.value = value;
    }
    
    static EnumSet<OnigCaseFoldType> valuesOf(final int values) {
        final List<OnigCaseFoldType> flags = new ArrayList<OnigCaseFoldType>();
        for (final OnigCaseFoldType cf : OnigCaseFoldType.values()) {
            if ((values & cf.value) == cf.value) {
                flags.add(cf);
            }
        }
        return (flags.size() != 0 ? EnumSet.copyOf(flags) : EnumSet.noneOf(OnigCaseFoldType.class));
    }

    static int value(OnigCaseFoldType flag) {
        if (flag != null) {
            return flag.value;
        }
        return ONIGENC_CASE_FOLD_NONE;
    }

    static int values(Collection<OnigCaseFoldType> flags) {
        if (flags != null) {
            int values = ONIGENC_CASE_FOLD_NONE;
            for (final OnigCaseFoldType cf : flags) {
                if (cf != null) {
                    values |= cf.value;
                }
            }
            return values;
        }
        return ONIGENC_CASE_FOLD_NONE;
    }

    static int values(OnigCaseFoldType... flags) {
        if (flags != null) {
            int values = ONIGENC_CASE_FOLD_NONE;
            for (final OnigCaseFoldType cf : flags) {
                if (cf != null) {
                    values |= cf.value;
                }
            }
            return values;
        }
        return ONIGENC_CASE_FOLD_NONE;
    }
    
    /**
     * invoke onig_get_default_case_fold_flag() function.
     * @return The default case fold flag
     */
    public static EnumSet<OnigCaseFoldType> getDefaultCaseFoldType() {
        return valuesOf(onig_get_default_case_fold_flag());
    }
    
    /**
     * invoke onig_set_default_case_fold_flag() function.
     * @param flags The default case fold flag
     */
    private static void setDefaultCaseFoldType(int flags) {
        final int ret = onig_set_default_case_fold_flag(flags);
        if (ret != ONIG_NORMAL) {
            throw new IllegalArgumentException(OnigRegex.getErrorMessage(ret, null));
        }
    }
    
    /**
     * invoke onig_set_default_case_fold_flag() function.
     * @param flags The default case fold flag
     */
    public static void setDefaultCaseFoldType(OnigCaseFoldType... flags) {
        setDefaultCaseFoldType(values(flags));
    }
    
    /**
     * invoke onig_set_default_case_fold_flag() function.
     * @param flags The default case fold flag
     */
    public static void setDefaultCaseFoldType(Collection<OnigCaseFoldType> flags) {
        setDefaultCaseFoldType(values(flags));
    }

//    public final static int INTERNAL_ONIGENC_CASE_FOLD_MULTI_CHAR = (1 << 30);
    public final static int ONIGENC_MAX_COMP_CASE_FOLD_CODE_LEN = 3;
    public final static int ONIGENC_GET_CASE_FOLD_CODES_MAX_NUM = 13;
    
    final static int ONIGENC_CASE_FOLD_NONE = 0;
}
