package onig4j;

import java.io.Closeable;

/**
 * Handle for Oniguruma API.
 * @author calico
 */
abstract class OnigHandle implements Closeable {
    
    /**
     * object handle.
     */
    protected volatile long handle;
    
    /**
     * invoke free() method.
     * @see #free()
     */
    public final void close() {
        if (handle != 0) {
            synchronized (this) {
                free();
            }
        }
    }

    /**
     * invoke close() method.
     * @throws java.lang.Throwable
     * @see #close()
     */
    @Override
    protected final void finalize() throws Throwable {
        close();
        super.finalize();
    }
    
    /**
     * Free memory used by handle.
     */
    protected abstract void free();
}
