package onig4j;

import java.util.Collection;
import java.util.EnumSet;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class OnigCaseFoldTypeTest {

    @Test
    public void valuesOf() {
        assertTrue(OnigCaseFoldType.valuesOf(1 << 1).contains(OnigCaseFoldType.ONIGENC_CASE_FOLD_HIRAGANA_KATAKANA));
        assertTrue(OnigCaseFoldType.valuesOf(1 << 2).contains(OnigCaseFoldType.ONIGENC_CASE_FOLD_KATAKANA_WIDTH));
        assertTrue(OnigCaseFoldType.valuesOf(1 << 20).contains(OnigCaseFoldType.ONIGENC_CASE_FOLD_TURKISH_AZERI));
        assertTrue(OnigCaseFoldType.valuesOf(1 << 30).contains(OnigCaseFoldType.ONIGENC_CASE_FOLD_MIN));
        assertEquals(0, OnigCaseFoldType.valuesOf(1 << 10).size());
    }
    
    @Test
    public void values() {
        assertEquals(0, OnigCaseFoldType.value((OnigCaseFoldType) null));
        assertEquals(0, OnigCaseFoldType.values((Collection<OnigCaseFoldType>) null));
        
        assertEquals(1 << 1, OnigCaseFoldType.value(OnigCaseFoldType.ONIGENC_CASE_FOLD_HIRAGANA_KATAKANA));
                
        assertEquals(
                1 << 1 | 1 << 2,
                OnigCaseFoldType.values(
                        EnumSet.of(
                            OnigCaseFoldType.ONIGENC_CASE_FOLD_HIRAGANA_KATAKANA,
                            OnigCaseFoldType.ONIGENC_CASE_FOLD_KATAKANA_WIDTH
                        )
                    )
            );
        
        assertEquals(
                1 << 20 | 1 << 30,
                OnigCaseFoldType.values(
                        OnigCaseFoldType.ONIGENC_CASE_FOLD_TURKISH_AZERI,
                        OnigCaseFoldType.ONIGENC_CASE_FOLD_MIN
                    )
            );
    }
    
    @Test
    public void getDefaultCaseFoldType() {
        assertTrue(OnigCaseFoldType.getDefaultCaseFoldType().contains(OnigCaseFoldType.ONIGENC_CASE_FOLD_MIN));
    }
    
    @Test
    public void setDefaultCaseFoldType() {
        assertTrue(OnigCaseFoldType.getDefaultCaseFoldType().contains(OnigCaseFoldType.ONIGENC_CASE_FOLD_MIN));
        
        OnigCaseFoldType.setDefaultCaseFoldType(OnigCaseFoldType.ONIGENC_CASE_FOLD_TURKISH_AZERI);
        
        assertTrue(OnigCaseFoldType.getDefaultCaseFoldType().contains(OnigCaseFoldType.ONIGENC_CASE_FOLD_TURKISH_AZERI));
        assertFalse(OnigCaseFoldType.getDefaultCaseFoldType().contains(OnigCaseFoldType.ONIGENC_CASE_FOLD_MIN));
    }
    
}