package onig4j;

/**
 * Capture history data tree class
 * @author calico
 * @see OnigRegion#getCaptureTreeNode()
 * @see <a href="http://www.geocities.jp/kosako3/oniguruma/">Oniguruma</a>
 * @see <a href="http://www.geocities.jp/kosako3/oniguruma/index_ja.html">鬼車</a>
 */
public class OnigCaptureTreeNode {
    /** object handle. */
    private long handle;

    /** The group number */
    public final int group;
    
    /** The begin position */
    public final int begin;
    
    /** The end position */
    public final int end;
    
    /** The allocated count */
    public final int allocated;
    
    /** The number of children */
    public final int count;
    
    /**
     * defualt constructor.
     * @param handle The pointer of OnigCaptureTreeNode
     * @param group The group number
     * @param begin The begin position
     * @param end The end positio
     * @param allocated The allocated count
     * @param num_childs The number of children
     * @see OnigRegion#getCaptureTreeNode()
     */
    OnigCaptureTreeNode(long handle, int group, int begin, int end, int allocated, int num_childs) {
        this.handle = handle;
        this.group = group;
        this.begin = begin;
        this.end = end;
        this.allocated = allocated;
        this.count = num_childs;
    }

    /**
     * Returns an array of OnigCaptureTreeNode that contains all children of this node.
     * @return The all children of this node
     * @throws java.lang.IllegalStateException When parent OnigRegeion objects have already closed or cleared.
     */
    public OnigCaptureTreeNode[] getChildNodes() {
        if (handle == 0) {
            throw new IllegalStateException("handle is invalid");
        }
        
        OnigCaptureTreeNode[] children = null;
        if (count >= 0) {
            children = new OnigCaptureTreeNode[count];
            for (int i = 0; i < count; ++i) {
                children[i] = getChildNode(handle, i);
            }
        }
        return children;
    }
    
    private static native OnigCaptureTreeNode getChildNode(long handle, int i);

    void close() {
        handle = 0;
    }
}
