package onig4j;

import org.junit.Test;
import static org.junit.Assert.*;
import static onig4j.OnigOptionType.*;
import static onig4j.OnigSyntaxType.*;

/**
 *
 * @author calico
 */
public class OnigSyntaxTypeTest {

    @Test
    public void clinit() {
        long tm = System.currentTimeMillis();
        OnigSyntaxType syntax = ONIG_SYNTAX_ASIS;
        
        System.out.println(System.currentTimeMillis() - tm);
    }

    @Test
    public void isBuiltIn() {
        for (final OnigSyntaxType syntax : OnigSyntaxType.values()) {
            assertTrue(syntax.isBuiltIn());
        }
        
        OnigSyntaxType syntax = ONIG_SYNTAX_ASIS.clone();
        assertFalse(syntax.isBuiltIn());
    }
    
    @Test
    public void close() throws InterruptedException {
        for (final OnigSyntaxType syntax : OnigSyntaxType.values()) {
            syntax.close();
            assertTrue(syntax.handle != 0);
        }
        
        OnigRegex regex = null;
        OnigSyntaxType syntax = null;
        
        regex = new OnigRegex("abc", ONIG_SYNTAX_ASIS);
        assertSame(ONIG_SYNTAX_ASIS, regex.getSyntaxType());        

        syntax = ONIG_SYNTAX_ASIS.clone();
        regex = new OnigRegex("abc", syntax);
        final OnigSyntaxType syn = regex.getSyntaxType();
        assertEquals(syntax, syn);
        assertSame(syntax, syn);
        
        if (syntax != null) {
            syntax.close();
            syntax = null;
        }

        Thread.sleep(1000);
        System.gc();
        
        int ret = regex.search("aaabccc");
        assertEquals(2, ret);
        
        ret = regex.search("aabcccc");
        ret = regex.search("abccc");
        ret = regex.search("aaaaaaaaaaabc");
        assertNotNull(regex.getSyntaxType());
        
//        assertEquals(ONIG_SYNTAX_ASIS.handle, handle);        
    }

//    @Test
//    public void hashCode_() {
//        OnigRegex regex = null;
//        OnigSyntaxType syntax = null;
//        
//        regex = new OnigRegex("abc", ONIG_SYNTAX_ASIS);
//        assertEquals(ONIG_SYNTAX_ASIS.hashCode(), regex.getSyntaxType().hashCode());
//        
//        syntax = ONIG_SYNTAX_ASIS.clone();
//        regex = new OnigRegex("abc", syntax);
//        OnigSyntaxType syntax2 = regex.getSyntaxType();
//        assertEquals(syntax.hashCode(), syntax2.hashCode());
//        assertFalse(syntax == syntax2);
//        assertTrue(syntax.equals(syntax2));
//    }
    
    @Test
    public void operator() {
        final OnigSyntaxType syn = new OnigSyntaxType();

        assertEquals(0, syn.getOperator());
        
        syn.setOperator(ONIG_SYN_OP_VARIABLE_META_CHARACTERS);
        assertEquals(ONIG_SYN_OP_VARIABLE_META_CHARACTERS, syn.getOperator());
        
        syn.addOperator(ONIG_SYN_OP_DOT_ANYCHAR);
        assertEquals(
                ONIG_SYN_OP_VARIABLE_META_CHARACTERS | ONIG_SYN_OP_DOT_ANYCHAR,
                syn.getOperator()
            );

        syn.removeOperator(ONIG_SYN_OP_VARIABLE_META_CHARACTERS);
        assertEquals(ONIG_SYN_OP_DOT_ANYCHAR, syn.getOperator());
    }
    
    @Test
    public void operator2() {
        final OnigSyntaxType syn = new OnigSyntaxType();

        assertEquals(0, syn.getOperator2());
        
        syn.setOperator2(ONIG_SYN_OP2_INEFFECTIVE_ESCAPE);
        assertEquals(ONIG_SYN_OP2_INEFFECTIVE_ESCAPE, syn.getOperator2());
        
        syn.addOperator2(ONIG_SYN_OP2_CCLASS_SET_OP);
        assertEquals(
                ONIG_SYN_OP2_INEFFECTIVE_ESCAPE | ONIG_SYN_OP2_CCLASS_SET_OP,
                syn.getOperator2()
            );

        syn.removeOperator2(ONIG_SYN_OP2_INEFFECTIVE_ESCAPE);
        assertEquals(ONIG_SYN_OP2_CCLASS_SET_OP, syn.getOperator2());
    }
    
    @Test
    public void behavior() {
        final OnigSyntaxType syn = new OnigSyntaxType();

        assertEquals(0, syn.getBehavior());
        
        syn.setBehavior(ONIG_SYN_CONTEXT_INDEP_ANCHORS);
        assertEquals(ONIG_SYN_CONTEXT_INDEP_ANCHORS, syn.getBehavior());
        
        syn.addBehavior(ONIG_SYN_ALLOW_INTERVAL_LOW_ABBREV);
        assertEquals(
                ONIG_SYN_CONTEXT_INDEP_ANCHORS | ONIG_SYN_ALLOW_INTERVAL_LOW_ABBREV,
                syn.getBehavior()
            );

        syn.removeBehavior(ONIG_SYN_CONTEXT_INDEP_ANCHORS);
        assertEquals(ONIG_SYN_ALLOW_INTERVAL_LOW_ABBREV, syn.getBehavior());
    }
    
    @Test
    public void options() {
        final OnigSyntaxType syn = new OnigSyntaxType();

        assertEquals(0, syn.getOptions());
        
        syn.setOptions(ONIG_OPTION_IGNORECASE);
        assertEquals(ONIG_OPTION_IGNORECASE.value, syn.getOptions());
        
        syn.addOptions(ONIG_OPTION_CAPTURE_GROUP);
        assertEquals(
                ONIG_OPTION_IGNORECASE.value | ONIG_OPTION_CAPTURE_GROUP.value,
                syn.getOptions()
            );

        syn.removeOptions(ONIG_OPTION_IGNORECASE);
        assertEquals(ONIG_OPTION_CAPTURE_GROUP.value, syn.getOptions());
    }
}