/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.query;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.ErrorMessage;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.plugin.query.AbstractQuery;

public class Query_JDBCCallable
extends AbstractQuery {
    private static final String VERSION = "4.0.0 (2005/08/31)";

    @Override
    public void execute() {
        this.execute(null);
    }

    @Override
    public void execute(String[] stringArray) {
        CallableStatement callableStatement = null;
        try {
            int n;
            callableStatement = this.getConnection().prepareCall(this.getStatement());
            callableStatement.setQueryTimeout(DB_MAX_QUERY_TIMEOUT);
            callableStatement.registerOutParameter(1, 4);
            callableStatement.registerOutParameter(2, 12);
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    callableStatement.setObject(n + 3, (Object)StringUtil.rTrim((String)stringArray[n]));
                }
            }
            callableStatement.execute();
            n = callableStatement.getInt(1);
            this.setErrorCode(n);
            if (n > 0) {
                String string = callableStatement.getString(2);
                ErrorMessage errorMessage = new ErrorMessage("Query_JDBCCallable Error!!");
                errorMessage.addMessage(new String[]{string});
                this.setErrorMessage(errorMessage);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.setErrorCode(8);
                String string = sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsSystem.CR + this.getStatement() + HybsSystem.CR;
                this.rollback();
                this.realClose();
                throw new HybsSystemException(string, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                Closer.stmtClose(callableStatement);
                throw throwable;
            }
        }
        Closer.stmtClose((Statement)callableStatement);
    }
}

