/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opengion.fukurou.taglet.DocletTagWriter;
import org.opengion.fukurou.taglet.DocletUtil;
import org.opengion.fukurou.util.LogWriter;

public final class DocletTaglib {
    private static Map<String, String> map = new HashMap<String, String>();
    private static final String OG_FOR_SMPL = "og.formSample";
    private static final String OG_TAG_NAME = "og.tag";
    private static final String OG_GROUP = "og.group";
    private static final String OG_TAG_CLASS = "org.opengion.hayabusa.taglib";
    private static final String ENCODE = "UTF-8";

    private DocletTaglib() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc rootDoc) {
        String string = DocletUtil.getOption("-version", rootDoc.options());
        String string2 = DocletUtil.getOption("-outfile", rootDoc.options());
        DocletTagWriter docletTagWriter = null;
        try {
            docletTagWriter = new DocletTagWriter(string2, ENCODE);
            docletTagWriter.printTag("<?xml version=\"1.0\" encoding=\"", ENCODE, "\" ?>");
            docletTagWriter.printTag("<javadoc>");
            docletTagWriter.printTag("  <version>", string, "</version>");
            docletTagWriter.printTag("  <description></description>");
            DocletTaglib.writeContents(rootDoc.classes(), docletTagWriter);
            docletTagWriter.printTag("</javadoc>");
        }
        catch (IOException iOException) {
            LogWriter.log(iOException);
        }
        finally {
            if (docletTagWriter != null) {
                docletTagWriter.close();
            }
        }
        return true;
    }

    private static void writeContents(ClassDoc[] classDocArray, DocletTagWriter docletTagWriter) {
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassDoc classDoc = classDocArray[i];
            String string = classDoc.qualifiedName();
            if (!classDoc.isPublic() || string.indexOf(OG_TAG_CLASS) < 0) continue;
            Tag[] tagArray = classDoc.firstSentenceTags();
            String string2 = DocletUtil.htmlFilter(classDoc.commentText());
            Tag[] tagArray2 = classDoc.tags(OG_FOR_SMPL);
            Tag[] tagArray3 = classDoc.tags(OG_GROUP);
            docletTagWriter.printTag("<classDoc>");
            docletTagWriter.printTag("  <tagClass>", string, "</tagClass>");
            docletTagWriter.printTag("  <description>");
            docletTagWriter.printTag(DocletTaglib.makeGroupTag(tagArray3));
            docletTagWriter.printTag(tagArray);
            docletTagWriter.printTag("</description>");
            docletTagWriter.printTag("  <contents>", string2, "</contents>");
            docletTagWriter.printTag("  <formSample>", tagArray2, "</formSample>");
            map.clear();
            String string3 = classDoc.name();
            while (!"BodyTagSupport".equals(string3) && !"TagSupport".equals(string3)) {
                String string4 = "false";
                if ("HTMLTagSupport".equals(string3)) {
                    string4 = "true";
                }
                MethodDoc[] methodDocArray = classDoc.methods();
                for (int j = 0; j < methodDocArray.length; ++j) {
                    String string5;
                    Tag[] tagArray4;
                    if (!methodDocArray[j].isPublic() || (tagArray4 = methodDocArray[j].tags(OG_TAG_NAME)).length <= 0 || map.containsKey(string5 = DocletUtil.removeSetter(methodDocArray[j].name()))) continue;
                    map.put(string5, string3);
                    Tag[] tagArray5 = methodDocArray[j].firstSentenceTags();
                    string2 = DocletUtil.htmlFilter(methodDocArray[j].commentText());
                    docletTagWriter.printTag("  <method>");
                    docletTagWriter.printTag("    <name>", string5, "</name>");
                    docletTagWriter.printTag("    <htmlExtend>", string4, "</htmlExtend>");
                    docletTagWriter.printTag("    <description>", tagArray5, "</description>");
                    docletTagWriter.printTag("    <contents>");
                    docletTagWriter.printTag(string2);
                    docletTagWriter.printTag(tagArray4);
                    docletTagWriter.printTag("    </contents>");
                    docletTagWriter.printTag("  </method>");
                }
                Type type = classDoc.superclassType();
                if (type == null) break;
                classDoc = type.asClassDoc();
                string3 = classDoc.name();
            }
            docletTagWriter.printTag("  </classDoc>");
        }
    }

    private static String makeGroupTag(Tag[] tagArray) {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (int i = 0; i < tagArray.length; ++i) {
            String string = DocletUtil.htmlFilter(tagArray[i].text());
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            return "\u3010" + stringBuilder.toString() + "\u3011";
        }
        return "";
    }

    public static int optionLength(String string) {
        if (string.equalsIgnoreCase("-version")) {
            return 2;
        }
        if (string.equalsIgnoreCase("-outfile")) {
            return 2;
        }
        return 0;
    }
}

