/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.opengion.fukurou.mail.MailMessage;
import org.opengion.fukurou.mail.MailReceiveListener;
import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;

public class MailRX {
    public static final int MAX_ROW_COUNT = 100;
    public static final boolean DELETE_MESSAGE = false;
    public static final String PROTOCOL = "pop3";
    public static final int PORT = -1;
    public static final String MBOX = "INBOX";
    public static final String CHARSET = "ISO-2022-JP";
    private MailReceiveListener listener = null;
    private String host = null;
    private String user = null;
    private String passwd = null;
    private String protocol = "pop3";
    private int port = -1;
    private String mbox = "INBOX";
    private boolean deleteFlag = false;
    private String charset = "ISO-2022-JP";
    private int maxRowCount = 100;
    private final List<HybsEntry> matchList = new ArrayList<HybsEntry>();
    private boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MessagingException, NoSuchProviderException {
        Object object;
        this.debugMsg("\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u89e3\u6790\u3001\u53d6\u5f97");
        this.debugMsg("\u6307\u5b9a\u306e\u6761\u4ef6\u306b\u30de\u30c3\u30c1\u3057\u305f\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u307f\u629c\u304d\u51fa\u3059\u6761\u4ef6\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        HybsEntry[] hybsEntryArray = this.matchList.toArray(new HybsEntry[this.matchList.size()]);
        SearchTerm[] searchTermArray = new SearchTerm[hybsEntryArray.length];
        for (int i = 0; i < hybsEntryArray.length; ++i) {
            object = hybsEntryArray[i].getKey();
            searchTermArray[i] = "Subject".equalsIgnoreCase((String)object) ? new SubjectTerm(hybsEntryArray[i].getValue()) : ("From".equalsIgnoreCase((String)object) ? new FromStringTerm(hybsEntryArray[i].getValue()) : ("Body".equalsIgnoreCase((String)object) ? new BodyTerm(hybsEntryArray[i].getValue()) : new HeaderTerm((String)object, hybsEntryArray[i].getValue())));
        }
        AndTerm andTerm = new AndTerm(searchTermArray);
        this.debugMsg("\u7a7a\u306e properties \u3092\u8a2d\u5b9a");
        object = new Properties();
        ((Properties)object).setProperty("mail.mime.charset", this.charset);
        ((Properties)object).setProperty("mail.mime.decodetext.strict", "false");
        ((Properties)object).setProperty("mail.mime.address.strict", "false");
        this.debugMsg("session \u3092\u53d6\u5f97");
        Session session = Session.getInstance((Properties)object, null);
        Store store = null;
        Folder folder = null;
        try {
            this.debugMsg("store \u306e\u53d6\u5f97 protocol=", this.protocol);
            store = session.getStore(this.protocol);
            this.debugMsg("\u30b5\u30fc\u30d0\u30fc\u3068 connect \u3057\u307e\u3059\u3002");
            store.connect(this.host, this.port, this.user, this.passwd);
            this.debugMsg("folder \u306e\u53d6\u5f97");
            folder = store.getFolder(this.mbox);
            if (this.deleteFlag) {
                folder.open(2);
            } else {
                folder.open(1);
            }
            this.debugMsg("\u30e1\u30c3\u30bb\u30fc\u30b8\u60c5\u5831\u306e\u53d6\u5f97");
            Message[] messageArray = folder.search((SearchTerm)andTerm);
            int n = messageArray.length;
            for (int i = 0; i < n && i < this.maxRowCount; ++i) {
                MailMessage mailMessage = new MailMessage(messageArray[i], this.host, this.user);
                this.debugMsg("[", String.valueOf(i), "]", mailMessage.getMessageID(), " \u53d7\u4fe1\u4e2d");
                messageArray[i].setFlag(Flags.Flag.DELETED, this.deleteFlag);
                boolean bl = true;
                if (this.listener != null) {
                    bl = this.listener.receive(mailMessage);
                }
                String string = mailMessage.getNotificationTo();
                if (!bl || string == null) continue;
                MailTX mailTX = new MailTX(this.host);
                mailTX.setFrom(this.user);
                mailTX.setTo(StringUtil.csv2Array(string));
                mailTX.setSubject("\u53d7\u9818:" + mailMessage.getSubject());
                mailTX.setMessage(mailMessage.getContent());
                mailTX.sendmail();
            }
        }
        catch (Throwable throwable) {
            this.debugMsg("\u30bb\u30c3\u30b7\u30e7\u30f3\u7d42\u4e86\u51e6\u7406");
            if (folder != null) {
                folder.close(this.deleteFlag);
            }
            if (store != null) {
                store.close();
            }
            throw throwable;
        }
        this.debugMsg("\u30bb\u30c3\u30b7\u30e7\u30f3\u7d42\u4e86\u51e6\u7406");
        if (folder != null) {
            folder.close(this.deleteFlag);
        }
        if (store != null) {
            store.close();
        }
    }

    public void setHost(String string) {
        if (string == null) {
            String string2 = "host \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string2);
        }
        this.host = string;
    }

    public void setUser(String string) {
        if (string == null) {
            String string2 = "user \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string2);
        }
        this.user = string;
    }

    public void setPasswd(String string) {
        if (string == null) {
            String string2 = "passwd \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string2);
        }
        this.passwd = string;
    }

    public void setProtocol(String string) {
        if (string == null) {
            String string2 = "protocol \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string2);
        }
        this.protocol = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setMbox(String string) {
        if (string == null) {
            String string2 = "mbox \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string2);
        }
        this.mbox = string;
    }

    public void setMailReceiveListener(MailReceiveListener mailReceiveListener) {
        this.listener = mailReceiveListener;
    }

    public void setDelete(boolean bl) {
        this.deleteFlag = bl;
    }

    public void setCharset(String string) {
        if (string == null) {
            String string2 = "charset \u306b null \u306f\u30bb\u30c3\u30c8\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new IllegalArgumentException(string2);
        }
        this.charset = string;
    }

    public void setMaxRowCount(int n) {
        this.maxRowCount = n;
    }

    public void addMatchTerm(HybsEntry hybsEntry) {
        this.matchList.add(hybsEntry);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    private void debugMsg(String ... stringArray) {
        if (this.debug) {
            for (String string : stringArray) {
                System.out.print(string);
            }
            System.out.println();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.mail.MailRX <host> <user> <passwd> [<saveDir>]");
            System.exit(1);
        }
        final String string = stringArray.length == 4 ? stringArray[3] : null;
        MailRX mailRX = new MailRX();
        mailRX.setHost(stringArray[0]);
        mailRX.setUser(stringArray[1]);
        mailRX.setPasswd(stringArray[2]);
        mailRX.setCharset(CHARSET);
        MailReceiveListener mailReceiveListener = new MailReceiveListener(){

            @Override
            public boolean receive(MailMessage mailMessage) {
                System.out.println(mailMessage.getSimpleMessage());
                if (string != null) {
                    mailMessage.saveSimpleMessage(string);
                }
                return true;
            }
        };
        mailRX.setMailReceiveListener(mailReceiveListener);
        mailRX.start();
    }
}

