/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.xml.HybsXMLSave;

public final class SystemInstaller {
    private final String VERSION;
    private final String SYSTEM_ID;
    private final String CONTEXT_NAME;
    private final String HOST_URL;
    private final Connection connection;
    public static final String GE12_XML = "org/opengion/hayabusa/common/GE12.xml";
    public static final String SEL_MAX_ENG = "select PARAM from GE12 where SYSTEM_ID='**' and PARAM_ID='ENGINE_INFO' and FGJ='1' and KBSAKU='0'";
    public static final String SEL_SYS_ENG = "select PARAM from GE12 where SYSTEM_ID=? and PARAM_ID='ENGINE_INFO' and KBSAKU='0' and CONTXT_PATH=? and FGJ='1'";

    public SystemInstaller(String string, String string2, String string3, String string4, Connection connection) {
        this.VERSION = string;
        this.SYSTEM_ID = string2;
        this.CONTEXT_NAME = string3;
        this.HOST_URL = string4;
        this.connection = connection;
    }

    public void insupd() throws SQLException, UnsupportedEncodingException {
        System.out.println("    Start System Version Check ( " + this.SYSTEM_ID + " ) : loadVersion [ " + this.VERSION + " ]");
        String string = this.getOldMaxVersion();
        System.out.println("     max old version = [ " + string + " ]");
        if ("none".equalsIgnoreCase(string)) {
            String string2 = System.getenv("INSTALL_CONTEXTS");
            if (string2 != null && string2.length() > 0) {
                System.out.println("      Start System Install : install type ( " + string2 + " )");
                String[] stringArray = StringUtil.csv2Array((String)string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println("       install ( " + stringArray[i] + " )");
                    this.loadXMLScript("install", stringArray[i]);
                    this.connection.commit();
                }
                this.dbXMLResourceInsert();
                this.connection.commit();
            }
            return;
        }
        if (string == null || string.compareTo(this.VERSION) < 0) {
            System.out.println("       Start SystemParameter reload");
            this.dbXMLResourceInsert();
            this.connection.commit();
        }
        String string3 = this.getOldSystemVersion();
        System.out.println("     system old version = [ " + string3 + " ]");
        if (string3 == null || string3.compareTo(this.VERSION) < 0) {
            System.out.println("       update ( " + this.CONTEXT_NAME + " )");
            this.loadXMLScript("update", this.CONTEXT_NAME);
            this.connection.commit();
        }
    }

    private void loadXMLScript(String string, String string2) throws SQLException {
        BufferedReader bufferedReader;
        Object object;
        File[] fileArray;
        String string3 = System.getenv("APP_BASE");
        String string4 = this.connection.getMetaData().getDatabaseProductName();
        String string5 = string3 + File.separator + string2.toLowerCase(Locale.JAPAN) + File.separator;
        String string6 = null;
        File[] fileArray2 = new File(string5 + "db").listFiles();
        if (fileArray2 == null || fileArray2.length == 0) {
            System.out.println("       DB Folder not found. ");
            return;
        }
        for (int i = 0; i < fileArray2.length; ++i) {
            if (string4.toLowerCase(Locale.JAPAN).indexOf(fileArray2[i].getName()) < 0) continue;
            string6 = fileArray2[i].getAbsolutePath();
            break;
        }
        if (string6 == null) {
            System.out.println("       Script Folder for [ " + string4 + " ] not found ");
            return;
        }
        ArrayList arrayList = new ArrayList();
        FileUtil.getFileList((File)new File(string6 + File.separator + "xml" + File.separator + string), (boolean)true, arrayList);
        if (!arrayList.isEmpty()) {
            fileArray = arrayList.iterator();
            while (fileArray.hasNext()) {
                String string7 = (String)fileArray.next();
                object = new File(string7);
                bufferedReader = new BufferedReader(FileUtil.getBufferedReader((File)object, (String)"UTF-8"));
                HybsXMLSave hybsXMLSave = new HybsXMLSave(this.connection, ((File)object).getName());
                hybsXMLSave.insertXML((Reader)bufferedReader);
            }
            System.out.println("        DB Enviroment Installed , [ " + arrayList.size() + " ] scripts loaded ");
        }
        if ((fileArray = new File(string5 + "db" + File.separator + "xml").listFiles()) != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                object = new BufferedReader(FileUtil.getBufferedReader((File)fileArray[i], (String)"UTF-8"));
                bufferedReader = new HybsXMLSave(this.connection, fileArray[i].getName());
                bufferedReader.insertXML((Reader)object);
            }
            System.out.println("        DB Data Files Installed , [ " + fileArray.length + " ] files loaded ");
        }
        System.out.println("       .completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOldMaxVersion() {
        String string;
        block6: {
            Statement statement = null;
            ResultSet resultSet = null;
            string = null;
            try {
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery(SEL_MAX_ENG);
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                }
                Closer.resultClose((ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                string = "none";
                break block6;
            }
            finally {
                Closer.resultClose(resultSet);
                Closer.stmtClose((Statement)statement);
            }
            Closer.stmtClose((Statement)statement);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOldSystemVersion() throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            preparedStatement = this.connection.prepareStatement(SEL_SYS_ENG);
            preparedStatement.setString(1, this.SYSTEM_ID);
            preparedStatement.setString(2, this.HOST_URL);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        catch (Throwable throwable) {
            Closer.resultClose(resultSet);
            Closer.stmtClose((Statement)preparedStatement);
            throw throwable;
        }
        Closer.resultClose((ResultSet)resultSet);
        Closer.stmtClose((Statement)preparedStatement);
        return string;
    }

    private void dbXMLResourceInsert() throws UnsupportedEncodingException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(GE12_XML);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        HybsXMLSave hybsXMLSave = new HybsXMLSave(this.connection, "GE12");
        hybsXMLSave.insertXML((Reader)bufferedReader);
        int n = hybsXMLSave.getInsertCount();
        int n2 = hybsXMLSave.getDeleteCount();
        System.out.print("        XML Engine Resource Reconfiguration ");
        System.out.println("DELETE=[" + n2 + "],INSERT=[" + n + "] finished.");
        System.out.println("      .completed");
    }
}

