/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.util.Random;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.ExecThreadManager;
import org.opengion.hayabusa.report2.QueueManager;

public class QueueManager_DIRECT
implements QueueManager {
    private final int timeout = HybsSystem.sysInt("REPORT_DAEMON_TIMEOUT");
    private static final String SYSTEM_ID = HybsSystem.sys("SYSTEM_ID");
    private static final Random RANDOM = new Random();
    private String listId;
    private String outputName;
    private String lang;
    private String outputType;
    private String templateName;
    private String printerName;
    private boolean fglocal;
    private boolean fgcut;
    private DBTableModel body;
    private DBTableModel header;
    private DBTableModel footer;
    private boolean isEnd = false;
    private String errMsg = null;

    @Override
    public void create() {
        ExecQueue execQueue = new ExecQueue();
        execQueue.setSystemId(SYSTEM_ID);
        execQueue.setYkno("DIRECT_" + Long.toString(RANDOM.nextLong() & Long.MAX_VALUE));
        execQueue.setListId(this.listId);
        execQueue.setLang(this.lang);
        execQueue.setOutputName(this.outputName);
        execQueue.setOutputType(this.outputType);
        execQueue.setThreadId("_DIRECT_");
        execQueue.setTemplateName(this.templateName);
        execQueue.setPrinterName(this.printerName);
        execQueue.setFglocal(this.fglocal);
        execQueue.setFgcut(this.fgcut);
        execQueue.setBody(this.body);
        execQueue.setHeader(this.header);
        execQueue.setFooter(this.footer);
        execQueue.setManager(this);
        ExecThreadManager.insertQueue(execQueue);
    }

    @Override
    public void set(ExecQueue execQueue) {
    }

    @Override
    public void execute(ExecQueue execQueue) {
    }

    @Override
    public void complete(ExecQueue execQueue) {
        this.isEnd = true;
    }

    @Override
    public void error(ExecQueue execQueue) {
        this.isEnd = true;
        this.errMsg = execQueue.getMsg();
    }

    public void waitExec() {
        long l = System.currentTimeMillis();
        while (true) {
            if (this.isEnd) {
                if (this.errMsg == null) break;
                throw new HybsSystemException(this.errMsg);
            }
            if ((int)(System.currentTimeMillis() - l) > this.timeout * 1000) {
                throw new HybsSystemException("\u5e33\u7968\u51e6\u7406\u3067\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u306b\u306a\u308a\u307e\u3057\u305f");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final void setListId(String string) {
        this.listId = string;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public final void setOutputName(String string) {
        this.outputName = string;
    }

    public final void setOutputType(String string) {
        this.outputType = string;
    }

    public final void setTemplateName(String string) {
        this.templateName = string;
    }

    public final void setPrinterName(String string) {
        this.printerName = string;
    }

    public void setFglocal(boolean bl) {
        this.fglocal = bl;
    }

    public void setFgcut(boolean bl) {
        this.fgcut = bl;
    }

    public void setBody(DBTableModel dBTableModel) {
        this.body = dBTableModel;
    }

    public void setHeader(DBTableModel dBTableModel) {
        this.header = dBTableModel;
    }

    public void setFooter(DBTableModel dBTableModel) {
        this.footer = dBTableModel;
    }
}

